/*
 * Decompiled with CFR 0.152.
 */
package termopl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import termopl.CommonResources;
import termopl.FormsView;
import termopl.GroupsView;
import termopl.InfoPanel;
import termopl.PictButton;
import termopl.Preferences;
import termopl.SentencesView;
import termopl.Term;
import termopl.TermEx;
import termopl.TermoPL;
import termopl.TermoPLDocument;

public class TermsView
extends JPanel {
    public static final String SELECT_WARNING = "No file selected for term extraction.";
    public static final String EXTRACT_WARNING = "Extract terms.";
    public static final String COMPARE_WARNING = "Compare terms.";
    public static final String CANCEL_WARNING = "Cancelled.";
    public static final String SEARCH_FAILED = "No terms found.";
    private static final String[] HEADERS = new String[]{"#", "Rank", "Term", "C-value", "?", "Length", "Freq_s", "Freq_in", "Context #"};
    private static final String[] CMETHODS = new String[]{"LL", "TFITF", "CSmw", "TW"};
    private static final int[] SIZES = new int[]{70, 70, 360, 100, 80, 100, 100, 100, 100};
    private TermoPLDocument doc;
    private JScrollPane tableScrollPane;
    private TermTable table;
    private CntrlPanel1 cntrlPanel1;
    private CntrlPanel2 cntrlPanel2;
    private InfoPanel infoPanel;
    private Component bottomComponent;
    private Term selectedTerm;
    private String searchString;
    private Runnable scrollToSelectedRow;
    private int selectedTermIndex;
    private int matchingTermIndex;
    private int matchingTermCounter;
    private int numOfMatchingTerms;
    private boolean patternError;
    private boolean columnsAreVisible;

    public TermsView(TermoPLDocument doc) {
        this.doc = doc;
        this.searchString = "";
        this.selectedTerm = null;
        this.selectedTermIndex = -1;
        this.matchingTermIndex = -1;
        this.matchingTermCounter = 0;
        this.patternError = false;
        this.numOfMatchingTerms = 0;
        this.setLayout(new BorderLayout());
        this.arrangeComponents();
        if (doc.getTerms() != null) {
            this.table.showColumns(true);
        }
        this.setTableDimensions();
        this.scrollToSelectedRow = new Runnable(){

            @Override
            public void run() {
                int row = TermsView.this.table.getSelectedRow();
                TermsView.this.table.scrollRectToVisible(TermsView.this.table.getCellRect(row, 0, true));
            }
        };
    }

    public void arrangeComponents() {
        PlaceHolder ph = new PlaceHolder();
        this.table = new TermTable(ph);
        this.tableScrollPane = new JScrollPane(this.table);
        this.tableScrollPane.getViewport().setBackground(CommonResources.LIGHT_GRAY);
        this.tableScrollPane.setCorner("UPPER_RIGHT_CORNER", ph);
        this.tableScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
        this.add((Component)this.tableScrollPane, "Center");
        this.cntrlPanel2 = new CntrlPanel2();
        this.infoPanel = new InfoPanel();
        this.add((Component)this.infoPanel, "South");
        this.bottomComponent = this.infoPanel;
        if (this.doc.getSelectedFiles() == null && this.doc.getNewFiles() == null) {
            this.infoPanel.setWarning(SELECT_WARNING);
            this.infoPanel.setAccessory(this.doc.selectAction);
        }
        if (this.doc.isLoaded()) {
            this.finishCreate();
        }
    }

    public void finishCreate() {
        this.cntrlPanel1 = new CntrlPanel1();
        this.add((Component)this.cntrlPanel1, "North");
        this.revalidate();
    }

    public void setTableDimensions() {
        int s = 0;
        int i = 0;
        while (i < SIZES.length) {
            s += SIZES[i];
            ++i;
        }
        if (!this.doc.getPreferences().applyContrastiveRanking) {
            s -= SIZES[4];
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(s += this.tableScrollPane.getVerticalScrollBar().getPreferredSize().width, 800));
    }

    public void resetResults() {
        this.table.resetResults();
    }

    public void resetSearch() {
        this.setNumOfMatches();
        if (this.numOfMatchingTerms > 0 && !this.doc.getPreferences().filterResults) {
            this.findNext();
        }
    }

    public void clearSearch() {
        this.matchingTermIndex = -1;
        this.matchingTermCounter = 0;
        this.numOfMatchingTerms = 0;
        this.cntrlPanel1.numOfMatches(-1);
    }

    public void setSearchString(String str) {
        this.searchString = str;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void search(String str) {
        Term[] terms = this.doc.getTerms();
        Preferences prefs = this.doc.getPreferences();
        if (terms != null) {
            if (str.equals("")) {
                int i = 0;
                while (i < terms.length) {
                    terms[i].setMatching(false);
                    ++i;
                }
            } else {
                Pattern patt;
                String srchPattern = str;
                int n = 0;
                int popt = 64;
                if (!prefs.caseSensitive) {
                    popt |= 2;
                }
                if (!prefs.regEx) {
                    srchPattern = Pattern.quote(srchPattern);
                    if (prefs.entireWord) {
                        srchPattern = "(\\s|^)" + srchPattern + "(\\s|$)";
                    }
                }
                try {
                    patt = Pattern.compile(srchPattern, popt);
                    this.patternError = false;
                }
                catch (PatternSyntaxException exception) {
                    patt = null;
                    this.patternError = true;
                }
                if (!this.patternError) {
                    int i = 0;
                    while (i < terms.length) {
                        Matcher matcher = patt.matcher(terms[i].str);
                        if (matcher.find()) {
                            terms[i].setMatching(true);
                            ++n;
                        } else {
                            terms[i].setMatching(false);
                        }
                        ++i;
                    }
                }
                this.numOfMatchingTerms = n;
                this.matchingTermCounter = 0;
                this.matchingTermIndex = -1;
                this.searchString = str;
                this.cntrlPanel1.numOfMatches(n);
                this.cntrlPanel1.updateNavButtons();
                if (n > 0 && !prefs.filterResults) {
                    this.findNext();
                }
            }
        }
        this.searchString = str;
    }

    public void search() {
        this.setSearchString("");
        this.cntrlPanel1.doSearch();
    }

    public void setNumOfMatches() {
        Term[] terms = this.doc.getTerms();
        int n = 0;
        int i = 0;
        while (i < this.doc.getTableSize()) {
            if (terms[i].isMatching()) {
                ++n;
            }
            ++i;
        }
        this.numOfMatchingTerms = n;
        this.matchingTermCounter = 0;
        this.matchingTermIndex = -1;
        this.cntrlPanel1.numOfMatches(n);
        this.cntrlPanel1.updateNavButtons();
    }

    public void findNext() {
        if (this.matchingTermCounter < this.numOfMatchingTerms) {
            int n = this.matchingTermIndex + 1;
            Term[] terms = this.doc.getTerms();
            int i = n;
            while (i < this.doc.getTableSize()) {
                if (terms[i].isMatching()) {
                    this.matchingTermIndex = i;
                    ++this.matchingTermCounter;
                    break;
                }
                ++i;
            }
            this.table.clearSelection();
            this.selectedTermIndex = this.matchingTermIndex;
            this.table.addRowSelectionInterval(this.selectedTermIndex, this.selectedTermIndex);
            this.cntrlPanel1.updateNavButtons();
            this.showSelected();
        }
    }

    public void findPrevious() {
        if (this.matchingTermCounter > 0) {
            int n = this.matchingTermIndex - 1;
            Term[] terms = this.doc.getTerms();
            int i = n;
            while (i >= 0) {
                if (terms[i].isMatching()) {
                    this.matchingTermIndex = i;
                    --this.matchingTermCounter;
                    break;
                }
                --i;
            }
            this.table.clearSelection();
            this.selectedTermIndex = this.matchingTermIndex;
            this.table.addRowSelectionInterval(this.selectedTermIndex, this.selectedTermIndex);
            this.cntrlPanel1.updateNavButtons();
            this.showSelected();
        }
    }

    public void showSelected() {
        EventQueue.invokeLater(this.scrollToSelectedRow);
    }

    public void showProgress(boolean show) {
        this.showProgress(show, true);
    }

    public void showProgress(boolean show, boolean allowCancel) {
        if (show) {
            if (this.bottomComponent == this.infoPanel) {
                this.remove(this.bottomComponent);
                this.add((Component)this.cntrlPanel2, "South");
                this.bottomComponent = this.cntrlPanel2;
                this.cntrlPanel2.allowCancel(allowCancel);
                this.revalidate();
                this.repaint();
            }
        } else if (this.bottomComponent == this.cntrlPanel2) {
            this.remove(this.bottomComponent);
            this.add((Component)this.infoPanel, "South");
            this.bottomComponent = this.infoPanel;
            this.revalidate();
            this.repaint();
        }
    }

    public void changeProgress(int type) {
        this.cntrlPanel2.changeProgress(type);
    }

    public void reportTagging(String fname) {
        this.cntrlPanel2.reportTagging(fname);
    }

    public void reportPreprocessing(String fname) {
        this.cntrlPanel2.reportPreprocessing(fname);
    }

    public void report(float value) {
        this.cntrlPanel2.report(value);
    }

    public void report(String fileName, int count) {
        this.cntrlPanel2.report(fileName, count);
    }

    public void report(int count, float value) {
        this.cntrlPanel2.report(count, value);
    }

    public void report(int processed, int total, float value) {
        this.cntrlPanel2.report(processed, total, value);
    }

    public void finalize() {
        this.cntrlPanel2.finalize();
    }

    public void pleaseWait() {
        this.cntrlPanel2.pleaseWait();
    }

    public void setInfo(String info) {
        this.infoPanel.setInfo(info);
    }

    public void setWarning(String warning) {
        this.infoPanel.setWarning(warning);
    }

    public void setAccessory(AbstractAction action) {
        this.infoPanel.setAccessory(action);
    }

    public void refreshColumns() {
        this.table.showColumns(false);
        this.table.showColumns(true);
    }

    public TermTable getTermTable() {
        return this.table;
    }

    public Term getSelectedTerm() {
        return this.selectedTerm;
    }

    public void setSelectedTerm(Term term) {
        Term[] terms = this.doc.getTerms();
        int i = 0;
        while (i < terms.length) {
            if (terms[i] == term) {
                this.table.setRowSelectionInterval(i, i);
                this.showSelected();
            }
            ++i;
        }
    }

    public void changeFontSize() {
        this.table.changeFontSize();
    }

    private class CntrlPanel1
    extends JPanel {
        private JPanel mainPanel;
        private JPanel searchOptionsPanel;
        private JCheckBox showTopRanked;
        private JCheckBox showMultiWordTermsOnly;
        private JCheckBox filter;
        private JCheckBox caseSensitive;
        private JCheckBox entireWord;
        private JCheckBox regEx;
        private JLabel show;
        private JLabel topRanked;
        private JLabel numOfMatches;
        private JLabel searchLabel;
        private JTextField searchField;
        private JTextField numTopRanked;
        private JTextField minLengthField;
        private JTextField maxLengthField;
        private PictButton prevButton;
        private PictButton nextButton;
        private PictButton searchButton;

        public CntrlPanel1() {
            Preferences prefs = TermsView.this.doc.getPreferences();
            JLabel label = new JLabel(" - ");
            this.setLayout(new BoxLayout(this, 1));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)), BorderFactory.createEmptyBorder(5, 8, 3, 8)));
            this.mainPanel.setBackground(CommonResources.GRAY);
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
            this.showTopRanked = new JCheckBox();
            this.showTopRanked.setOpaque(false);
            this.showTopRanked.setSelected(prefs.trimResults);
            this.mainPanel.add(this.showTopRanked);
            this.show = new JLabel("Show ");
            this.mainPanel.add(this.show);
            this.numTopRanked = new JTextField(Integer.toString(prefs.maxResults), 4);
            Dimension dim = this.numTopRanked.getPreferredSize();
            this.numTopRanked.setMaximumSize(dim);
            this.mainPanel.add(this.numTopRanked);
            this.topRanked = new JLabel(" top-ranked terms");
            this.mainPanel.add(this.topRanked);
            this.mainPanel.add(Box.createHorizontalStrut(16));
            this.showMultiWordTermsOnly = new JCheckBox("Multi-word terms of length ");
            this.showMultiWordTermsOnly.setOpaque(false);
            this.showMultiWordTermsOnly.setSelected(prefs.multiWordTermsOnly);
            this.mainPanel.add(this.showMultiWordTermsOnly);
            this.minLengthField = new JTextField(Integer.toString(prefs.minLength), 2);
            dim = this.minLengthField.getPreferredSize();
            this.minLengthField.setMaximumSize(dim);
            this.maxLengthField = new JTextField(2);
            if (prefs.maxLength > 0) {
                this.maxLengthField.setText(Integer.toString(prefs.maxLength));
            }
            dim = this.maxLengthField.getPreferredSize();
            this.maxLengthField.setMaximumSize(dim);
            this.mainPanel.add(this.minLengthField);
            this.mainPanel.add(label);
            this.mainPanel.add(this.maxLengthField);
            this.mainPanel.add(Box.createHorizontalStrut(16));
            this.mainPanel.add(Box.createHorizontalGlue());
            this.numOfMatches = new JLabel();
            this.numOfMatches.setVisible(false);
            this.mainPanel.add(this.numOfMatches);
            this.mainPanel.add(Box.createHorizontalStrut(16));
            this.prevButton = new PictButton("left.png", "left_pressed.png", "left_rollover.png");
            this.prevButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.prevButton.setBorderPainted(true);
            this.prevButton.setContentAreaFilled(true);
            this.mainPanel.add(this.prevButton);
            this.prevButton.setVisible(false);
            this.mainPanel.add(Box.createHorizontalStrut(4));
            this.nextButton = new PictButton("right.png", "right_pressed.png", "right_rollover.png");
            this.nextButton.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.lightGray), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.nextButton.setBorderPainted(true);
            this.nextButton.setContentAreaFilled(true);
            this.nextButton.setVisible(false);
            this.mainPanel.add(this.nextButton);
            this.mainPanel.add(Box.createHorizontalStrut(16));
            this.searchButton = new PictButton("search.png", "search_pressed.png", "search_rollover.png");
            this.mainPanel.add(this.searchButton);
            this.mainPanel.add(Box.createHorizontalStrut(4));
            this.searchLabel = new JLabel("Search: ");
            this.mainPanel.add(this.searchLabel);
            this.searchField = new JTextField(10);
            dim = this.searchField.getPreferredSize();
            this.searchField.setMaximumSize(dim);
            this.mainPanel.add(this.searchField);
            this.filter = new JCheckBox("Filter results");
            this.filter.setOpaque(false);
            this.filter.setSelected(prefs.filterResults);
            this.mainPanel.add(this.filter);
            this.add(this.mainPanel);
            this.searchOptionsPanel = new JPanel();
            this.searchOptionsPanel.setVisible(false);
            this.searchOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)), BorderFactory.createEmptyBorder(2, 8, 1, 8)));
            this.searchOptionsPanel.setLayout(new BoxLayout(this.searchOptionsPanel, 0));
            this.searchOptionsPanel.add(Box.createHorizontalGlue());
            this.caseSensitive = new JCheckBox("Case sensitive");
            this.caseSensitive.setSelected(prefs.caseSensitive);
            this.caseSensitive.putClientProperty("JComponent.sizeVariant", "small");
            this.searchOptionsPanel.add(this.caseSensitive);
            this.entireWord = new JCheckBox("Entire word");
            this.entireWord.setSelected(prefs.entireWord);
            this.entireWord.setEnabled(!prefs.regEx);
            this.entireWord.putClientProperty("JComponent.sizeVariant", "small");
            this.searchOptionsPanel.add(this.entireWord);
            this.regEx = new JCheckBox("Regular expression");
            this.regEx.setSelected(prefs.regEx);
            this.regEx.putClientProperty("JComponent.sizeVariant", "small");
            this.searchOptionsPanel.add(this.regEx);
            this.add(this.searchOptionsPanel);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TermsView.this.doc.trim(CntrlPanel1.this.showTopRanked.isSelected(), CntrlPanel1.this.showMultiWordTermsOnly.isSelected(), CntrlPanel1.this.filter.isSelected());
                }
            };
            this.numTopRanked.addActionListener(action);
            this.minLengthField.addActionListener(action);
            this.maxLengthField.addActionListener(action);
            this.showTopRanked.addActionListener(action);
            this.showMultiWordTermsOnly.addActionListener(action);
            this.numTopRanked.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CntrlPanel1.this.updateMaxResults();
                }
            });
            this.numTopRanked.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CntrlPanel1.this.updateMaxResults();
                }
            });
            this.minLengthField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CntrlPanel1.this.updateMinLength();
                }
            });
            this.minLengthField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CntrlPanel1.this.updateMinLength();
                }
            });
            this.maxLengthField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CntrlPanel1.this.updateMaxLength();
                }
            });
            this.maxLengthField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    CntrlPanel1.this.updateMaxLength();
                }
            });
            this.searchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CntrlPanel1.this.searchOptionsPanel.setVisible(!CntrlPanel1.this.searchOptionsPanel.isVisible());
                }
            });
            action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CntrlPanel1.this.searchField.selectAll();
                }
            };
            this.searchField.addActionListener(action);
            this.searchField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CntrlPanel1.this.doSearch();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CntrlPanel1.this.doSearch();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            this.nextButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TermsView.this.findNext();
                }
            });
            this.prevButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TermsView.this.findPrevious();
                }
            });
            this.filter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (TermsView.this.doc.getTerms() == null) {
                        CntrlPanel1.this.prevButton.setVisible(false);
                        CntrlPanel1.this.nextButton.setVisible(false);
                        CntrlPanel1.this.numOfMatches.setVisible(false);
                    } else {
                        TermsView.this.doc.trim(CntrlPanel1.this.showTopRanked.isSelected(), CntrlPanel1.this.showMultiWordTermsOnly.isSelected(), CntrlPanel1.this.filter.isSelected());
                        boolean f = !CntrlPanel1.this.filter.isSelected() && TermsView.this.numOfMatchingTerms > 0;
                        CntrlPanel1.this.prevButton.setVisible(f);
                        CntrlPanel1.this.nextButton.setVisible(f);
                    }
                }
            });
            this.caseSensitive.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences prefs = TermsView.this.doc.getPreferences();
                    if (prefs.caseSensitive != CntrlPanel1.this.caseSensitive.isSelected()) {
                        TermoPL.preferences.caseSensitive = prefs.caseSensitive = !prefs.caseSensitive;
                        TermoPL.preferences.setModified(true);
                        CntrlPanel1.this.doSearch(true);
                    }
                }
            });
            this.entireWord.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences prefs = TermsView.this.doc.getPreferences();
                    if (prefs.entireWord != CntrlPanel1.this.entireWord.isSelected()) {
                        TermoPL.preferences.entireWord = prefs.entireWord = !prefs.entireWord;
                        TermoPL.preferences.setModified(true);
                        CntrlPanel1.this.doSearch(true);
                    }
                }
            });
            this.regEx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences prefs = TermsView.this.doc.getPreferences();
                    if (prefs.regEx != CntrlPanel1.this.regEx.isSelected()) {
                        TermoPL.preferences.regEx = prefs.regEx = !prefs.regEx;
                        TermoPL.preferences.setModified(true);
                        CntrlPanel1.this.entireWord.setEnabled(!CntrlPanel1.this.regEx.isSelected());
                        CntrlPanel1.this.doSearch(true);
                    }
                }
            });
        }

        public void doSearch() {
            this.doSearch(false);
        }

        public void doSearch(boolean enforce) {
            String str = this.searchField.getText();
            if (!str.equals(TermsView.this.searchString) || enforce) {
                this.numOfMatches(-1);
                TermsView.this.search(str);
                if (this.filter.isSelected()) {
                    TermsView.this.doc.trim(this.showTopRanked.isSelected(), this.showMultiWordTermsOnly.isSelected(), this.filter.isSelected());
                }
            }
        }

        public void updateNavButtons() {
            this.prevButton.setEnabled(TermsView.this.matchingTermCounter > 1);
            this.nextButton.setEnabled(TermsView.this.matchingTermCounter < TermsView.this.numOfMatchingTerms);
        }

        public void updateMaxResults() {
            Preferences prefs = TermsView.this.doc.getPreferences();
            try {
                int m = Integer.parseInt(this.numTopRanked.getText());
                if (m != prefs.maxResults) {
                    prefs.maxResults = m;
                    TermoPL.preferences.maxResults = m;
                    TermoPL.preferences.setModified(true);
                    if (prefs.trimResults) {
                        TermsView.this.doc.trim(prefs.trimResults, prefs.multiWordTermsOnly, prefs.filterResults);
                    }
                }
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
                this.numTopRanked.setText(Integer.toString(prefs.maxResults));
            }
            this.numTopRanked.selectAll();
        }

        public void updateMinLength() {
            Preferences prefs = TermsView.this.doc.getPreferences();
            try {
                TermoPL.preferences.minLength = prefs.minLength = Integer.parseInt(this.minLengthField.getText());
                TermoPL.preferences.setModified(true);
                if (prefs.trimResults) {
                    TermsView.this.doc.trim(prefs.trimResults, prefs.multiWordTermsOnly, prefs.filterResults);
                }
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
                this.minLengthField.setText(Integer.toString(prefs.minLength));
            }
            this.minLengthField.selectAll();
        }

        public void updateMaxLength() {
            Preferences prefs = TermsView.this.doc.getPreferences();
            try {
                String str = this.maxLengthField.getText().trim();
                if (str.isEmpty()) {
                    if (prefs.maxLength > 0) {
                        prefs.maxLength = -1;
                        TermoPL.preferences.maxLength = -1;
                        TermoPL.preferences.setModified(true);
                        if (prefs.trimResults) {
                            TermsView.this.doc.trim(prefs.trimResults, prefs.multiWordTermsOnly, prefs.filterResults);
                        }
                    }
                } else {
                    int len = Integer.parseInt(str);
                    if (len != prefs.maxLength) {
                        prefs.maxLength = len;
                        TermoPL.preferences.maxLength = len;
                        TermoPL.preferences.setModified(true);
                        if (prefs.trimResults) {
                            TermsView.this.doc.trim(prefs.trimResults, prefs.multiWordTermsOnly, prefs.filterResults);
                        }
                    }
                }
            }
            catch (NumberFormatException exception) {
                Toolkit.getDefaultToolkit().beep();
                if (prefs.maxLength < 0) {
                    this.maxLengthField.setText("");
                }
                this.maxLengthField.setText(Integer.toString(prefs.maxLength));
            }
            this.maxLengthField.selectAll();
        }

        public void numOfMatches(int n) {
            if (n < 0) {
                this.nextButton.setVisible(false);
                this.prevButton.setVisible(false);
                this.numOfMatches.setVisible(false);
            } else if (n == 0) {
                if (TermsView.this.searchString.equals("")) {
                    this.numOfMatches.setText("");
                    this.numOfMatches.setVisible(false);
                } else {
                    this.numOfMatches.setText("No matches");
                    this.numOfMatches.setVisible(true);
                }
                this.nextButton.setVisible(false);
                this.prevButton.setVisible(false);
            } else if (n == 1) {
                this.numOfMatches.setText("1 match");
                this.nextButton.setVisible(false);
                this.prevButton.setVisible(false);
                this.numOfMatches.setVisible(true);
            } else {
                boolean f;
                boolean bl = f = !TermsView.this.searchString.equals("") && !this.filter.isSelected();
                if (TermsView.this.searchString.equals("")) {
                    this.numOfMatches.setText("");
                } else {
                    this.numOfMatches.setText(String.valueOf(n) + " matches");
                }
                this.nextButton.setVisible(f);
                this.prevButton.setVisible(f);
                this.numOfMatches.setVisible(true);
            }
        }
    }

    private class CntrlPanel2
    extends JPanel {
        private JProgressBar progress;
        private JButton cancelButton;
        private JLabel progressLabel;
        private JLabel extracted;
        private JLabel fileNameLabel;
        private JLabel fileName;
        private JLabel normalized;
        private Component hspace;
        private Dimension progressDim;
        private Dimension indeterminateProgressDim;

        public CntrlPanel2() {
            this.setBackground(CommonResources.GRAY);
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.progress = new JProgressBar();
            this.progress.setMinimum(0);
            this.progress.setMaximum(100);
            this.progress.setIndeterminate(true);
            if (TermoPL.isMacOS) {
                this.progress.putClientProperty("JProgressBar.style", "circular");
            }
            this.indeterminateProgressDim = this.progress.getPreferredSize();
            this.progressDim = new Dimension();
            this.progressDim.width = 80;
            this.progressDim.height = this.indeterminateProgressDim.height;
            if (!TermoPL.isMacOS) {
                this.indeterminateProgressDim.width = 80;
            }
            this.progress.setMaximumSize(this.progressDim);
            this.add(this.progress);
            this.add(Box.createHorizontalStrut(16));
            this.fileNameLabel = new JLabel();
            this.add(this.fileNameLabel);
            this.fileName = new JLabel();
            this.add(this.fileName);
            this.hspace = Box.createHorizontalStrut(16);
            this.add(this.hspace);
            this.progressLabel = new JLabel("Matched maximal phrases: ");
            this.add(this.progressLabel);
            this.extracted = new JLabel();
            this.add(this.extracted);
            this.normalized = new JLabel();
            this.normalized.setVisible(false);
            this.add(this.normalized);
            this.add(Box.createHorizontalGlue());
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TermsView.this.doc.cancel();
                }
            });
            this.add(this.cancelButton);
        }

        public void allowCancel(boolean f) {
            this.cancelButton.setVisible(f);
        }

        public void finalize() {
            this.progress.setVisible(false);
            this.hspace.setVisible(false);
            this.fileName.setVisible(false);
            this.fileNameLabel.setVisible(false);
            this.extracted.setVisible(false);
            this.normalized.setVisible(false);
            this.progressLabel.setText("Finalizing...");
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void pleaseWait() {
            this.progress.setIndeterminate(true);
            this.progress.setPreferredSize(this.indeterminateProgressDim);
            this.progress.setVisible(true);
            this.hspace.setVisible(false);
            this.fileName.setVisible(false);
            this.fileNameLabel.setVisible(false);
            this.extracted.setVisible(false);
            this.normalized.setVisible(false);
            this.progressLabel.setText("Wait...");
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void changeProgress(int type) {
            this.progress.setValue(0);
            this.progress.setVisible(true);
            if (type == 0) {
                this.extracted.setVisible(false);
                this.normalized.setVisible(false);
                this.fileName.setVisible(false);
                this.fileNameLabel.setVisible(false);
                this.hspace.setVisible(false);
                this.progress.setIndeterminate(true);
                this.progress.setPreferredSize(this.progressDim);
                this.progressLabel.setText("Loading Contrastive Set of Terms...");
            } else if (type == 1) {
                this.allowCancel(true);
                this.extracted.setVisible(true);
                this.normalized.setVisible(false);
                this.fileName.setVisible(true);
                this.fileNameLabel.setVisible(true);
                this.fileNameLabel.setText("File: ");
                this.hspace.setVisible(true);
                this.progressLabel.setVisible(true);
                this.progressLabel.setText("Matched maximal phrases: ");
                this.progress.setIndeterminate(true);
                this.progress.setPreferredSize(this.indeterminateProgressDim);
            } else if (type == 2) {
                this.allowCancel(true);
                this.extracted.setVisible(true);
                this.normalized.setVisible(false);
                this.fileName.setVisible(true);
                this.fileNameLabel.setVisible(true);
                this.fileNameLabel.setText("File: ");
                this.hspace.setVisible(true);
                this.progressLabel.setVisible(true);
                this.progressLabel.setText("Extracted terms: ");
                this.progress.setIndeterminate(true);
                this.progress.setPreferredSize(this.indeterminateProgressDim);
            } else if (type == 3) {
                this.extracted.setVisible(false);
                this.normalized.setVisible(false);
                this.fileName.setVisible(false);
                this.fileNameLabel.setVisible(false);
                this.hspace.setVisible(false);
                this.progressLabel.setText("Merging...");
                this.progress.setIndeterminate(false);
                this.progress.setPreferredSize(this.progressDim);
            } else if (type >= 6 && type <= 8) {
                this.progress.setVisible(false);
                this.extracted.setVisible(false);
                this.normalized.setVisible(false);
                this.fileName.setVisible(false);
                this.fileNameLabel.setVisible(false);
                this.hspace.setVisible(false);
                if (type == 6) {
                    this.progressLabel.setText("Building term hierarchy...");
                    this.progress.setIndeterminate(false);
                    this.progress.setPreferredSize(this.progressDim);
                } else if (type == 7) {
                    this.progressLabel.setText("Loading WordNet...");
                    this.progress.setIndeterminate(true);
                    this.progress.setPreferredSize(this.indeterminateProgressDim);
                } else {
                    this.progressLabel.setText("Analysing terms with WordNet...");
                    this.progress.setIndeterminate(false);
                    this.progress.setPreferredSize(this.progressDim);
                }
                this.progress.setVisible(true);
            } else {
                this.extracted.setVisible(true);
                this.normalized.setVisible(false);
                this.fileName.setVisible(false);
                this.fileNameLabel.setVisible(false);
                this.hspace.setVisible(false);
                this.progress.setIndeterminate(false);
                this.progress.setPreferredSize(this.progressDim);
                if (type == 4) {
                    this.progressLabel.setText("Extracted terms: ");
                } else {
                    this.extracted.setVisible(false);
                    this.normalized.setVisible(true);
                    this.normalized.setText("");
                    if (((TermsView)TermsView.this).doc.getPreferences().calculateBaseForms) {
                        this.progressLabel.setText("Base Forms: ");
                    } else {
                        this.progressLabel.setText("Simplified Forms: ");
                    }
                }
            }
            this.repaint();
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void reportTagging(String fName) {
            this.fileNameLabel.setText("Tagging file " + fName + "...");
            this.fileName.setVisible(false);
            this.progressLabel.setVisible(false);
            this.extracted.setVisible(false);
            this.allowCancel(false);
        }

        public void reportPreprocessing(String fName) {
            this.fileNameLabel.setText("Preprocessing file " + fName + "...");
            this.fileName.setVisible(false);
            this.progressLabel.setVisible(false);
            this.extracted.setVisible(false);
            this.allowCancel(true);
        }

        public void report(float value) {
            this.progress.setValue((int)(100.0f * value));
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void report(String name, int count) {
            if (!this.fileName.getText().equals(name)) {
                this.fileName.setText(name);
            }
            this.extracted.setText(Integer.toString(count));
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void report(int count, float value) {
            this.extracted.setText(Integer.toString(count));
            this.progress.setValue((int)(100.0f * value));
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void report(int processed, int total, float value) {
            this.progress.setValue((int)(100.0f * value));
            this.normalized.setText(String.valueOf(Integer.toString(processed)) + "/" + Integer.toString(total));
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class PlaceHolder
    extends JPanel {
        private boolean show = false;

        public PlaceHolder() {
            this.setBackground(CommonResources.LIGHT_GRAY);
        }

        public void showBottomLine(boolean f) {
            if (this.show != f) {
                this.show = f;
                this.repaint();
            }
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.show) {
                graphics.setColor(Color.lightGray);
                if (TermoPL.isMacOS) {
                    graphics.drawLine(0, this.getHeight() - 2, this.getWidth(), this.getHeight() - 2);
                    graphics.setColor(Color.white);
                    graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                } else {
                    graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
                }
            }
        }
    }

    private class RowRenderer
    extends DefaultTableCellRenderer {
        private final Border border = BorderFactory.createEmptyBorder(0, 4, 0, 4);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(Color.black);
                if (table.getColumnCount() == HEADERS.length) {
                    this.setBackground(TermsView.this.doc.getTerms()[row].getColor());
                } else if (row % 2 == 0) {
                    this.setBackground(CommonResources.VLIGHT_BLUE);
                } else {
                    this.setBackground(Color.white);
                }
            }
            this.setValue(value);
            this.setFont(TermoPL.preferences.plainFont);
            this.setBorder(this.border);
            if (column <= 1) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }

    private class TableHeader
    extends JTableHeader {
        private PlaceHolder corner;
        private boolean initialized;

        public TableHeader(TableColumnModel model) {
            super(model);
            this.corner = new PlaceHolder();
            this.initialized = false;
            this.setDefaultRenderer(new TableHeaderRenderer());
            this.setReorderingAllowed(false);
            this.corner.setLocation(0, 0);
            this.corner.showBottomLine(TermsView.this.columnsAreVisible);
            this.add(this.corner);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent event) {
                    TableColumnModel tcm = TableHeader.this.getColumnModel();
                    int column = tcm.getColumnIndexAtX(event.getX());
                    if (column > 0) {
                        if (!(((TermsView)((TableHeader)TableHeader.this).TermsView.this).doc.getPreferences().applyContrastiveRanking && TermsView.this.doc.getCTerms() != null || column <= 3)) {
                            ++column;
                        }
                        ((TermTable)TableHeader.this.getTable()).sortTable(column);
                    }
                }
            });
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            FontMetrics fm = this.getFontMetrics(TermoPL.preferences.boldFont);
            dim.height = fm.getHeight() + 4;
            return dim;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.moveCorner();
            this.initialized = true;
        }

        public void moveCorner() {
            TableColumnModel tcm = this.getColumnModel();
            Rectangle rect = this.getHeaderRect(tcm.getColumnCount() - 1);
            this.corner.setLocation(rect.x + rect.width, 0);
            this.corner.setSize(this.getWidth() - rect.x - rect.width, this.getHeight());
        }

        @Override
        public void resizeAndRepaint() {
            TableColumnModel model = this.getColumnModel();
            super.resizeAndRepaint();
            if (this.initialized) {
                this.moveCorner();
                this.corner.showBottomLine(model.getColumnCount() > 0);
            }
        }
    }

    private class TableHeaderRenderer
    implements TableCellRenderer {
        private JLabel renderer;
        private ImageIcon down1;
        private ImageIcon down2;
        private ImageIcon up1;
        private ImageIcon up2;

        public TableHeaderRenderer() {
            this.initIcons();
            this.initRenderer();
        }

        private void initIcons() {
            URL url = ClassLoader.getSystemClassLoader().getResource("down_1.gif");
            this.down1 = new ImageIcon(url);
            url = ClassLoader.getSystemClassLoader().getResource("down_2.gif");
            this.down2 = new ImageIcon(url);
            url = ClassLoader.getSystemClassLoader().getResource("up_1.gif");
            this.up1 = new ImageIcon(url);
            url = ClassLoader.getSystemClassLoader().getResource("up_2.gif");
            this.up2 = new ImageIcon(url);
        }

        private void initRenderer() {
            Border headerBorder = UIManager.getBorder("TableHeader.cellBorder");
            this.renderer = new JLabel();
            this.renderer.setFont(TermoPL.preferences.boldFont);
            this.renderer.setBorder(headerBorder);
            this.renderer.setBackground(UIManager.getColor("TableHeader.background"));
            this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Preferences prefs = TermsView.this.doc.getPreferences();
            this.renderer.setText((String)value);
            if (column > 0) {
                if (!(prefs.applyContrastiveRanking && TermsView.this.doc.getCTerms() != null || column <= 3)) {
                    ++column;
                }
                if (column == prefs.sortedColumn) {
                    if (prefs.sortPrefs[column] > 0) {
                        this.renderer.setIcon(this.up1);
                    } else {
                        this.renderer.setIcon(this.down1);
                    }
                } else if (prefs.sortPrefs[column] > 0) {
                    this.renderer.setIcon(this.up2);
                } else {
                    this.renderer.setIcon(this.down2);
                }
            } else {
                this.renderer.setIcon(null);
            }
            if (column <= 1) {
                this.renderer.setHorizontalAlignment(0);
            } else {
                this.renderer.setHorizontalAlignment(2);
            }
            switch (column) {
                case 0: {
                    if (prefs.saveCount) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 1: {
                    if (prefs.saveRank) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 2: {
                    this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                    break;
                }
                case 3: {
                    if (prefs.saveCV) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 4: {
                    if (prefs.saveComp) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 5: {
                    if (prefs.saveLen) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 6: {
                    if (prefs.saveFreqs) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 7: {
                    if (prefs.saveFreqin) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                    break;
                }
                case 8: {
                    if (prefs.saveContext) {
                        this.renderer.setForeground(UIManager.getColor("TableHeader.foreground"));
                        break;
                    }
                    this.renderer.setForeground(Color.blue);
                }
            }
            return this.renderer;
        }
    }

    private class TableViewModel
    extends AbstractTableModel {
        private DecimalFormat format = new DecimalFormat("#.##");

        @Override
        public int getRowCount() {
            return TermsView.this.doc.getTableSize();
        }

        @Override
        public int getColumnCount() {
            return HEADERS.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Term t = TermsView.this.doc.getTerms()[rowIndex];
            switch (columnIndex) {
                case 0: {
                    return Integer.toString(rowIndex + 1);
                }
                case 1: {
                    return Integer.toString(t.rank);
                }
                case 2: {
                    return t.str;
                }
                case 3: {
                    return this.format.format(t.cvalue);
                }
                case 4: {
                    if (t.getStatus() == 10) {
                        return "n/a";
                    }
                    if (t.contrast == Double.POSITIVE_INFINITY || t.contrast == Double.NEGATIVE_INFINITY) {
                        return "-";
                    }
                    return this.format.format(t.contrast);
                }
                case 5: {
                    return Integer.toString(t.len);
                }
                case 6: {
                    return Integer.toString(t.freq_s);
                }
                case 7: {
                    return Integer.toString(t.freq_in);
                }
                case 8: {
                    return Integer.toString(t.lk);
                }
            }
            return null;
        }
    }

    private class TermTable
    extends JTable {
        private PlaceHolder placeHolder;
        private TableColumn[] tableColumns;

        public TermTable(PlaceHolder placeHolder) {
            this.placeHolder = placeHolder;
            this.initTable();
        }

        public void initTable() {
            TableViewModel model = new TableViewModel();
            FontMetrics fm = this.getFontMetrics(TermoPL.preferences.boldFont);
            this.setModel(model);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(-1, -1, 0, -1), BorderFactory.createLineBorder(Color.lightGray)));
            this.setBackground(CommonResources.LIGHT_GRAY);
            this.setGridColor(Color.lightGray);
            this.setAutoResizeMode(0);
            this.setShowHorizontalLines(false);
            this.setRowHeight(fm.getHeight() + 4);
            TableColumnModel columnModel = this.getColumnModel();
            RowRenderer cellRenderer = new RowRenderer();
            TableHeader tableHeader = new TableHeader(columnModel);
            this.setTableHeader(tableHeader);
            this.tableColumns = new TableColumn[HEADERS.length];
            int i = 0;
            while (i < columnModel.getColumnCount()) {
                TableColumn column;
                this.tableColumns[i] = column = columnModel.getColumn(i);
                column.setHeaderValue(HEADERS[i]);
                column.setCellRenderer(cellRenderer);
                column.setPreferredWidth(SIZES[i]);
                ++i;
            }
            this.changeHeader();
            TermsView.this.columnsAreVisible = true;
            this.showColumns(false);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (!event.getValueIsAdjusting()) {
                        GroupsView gv;
                        SentencesView sv;
                        FormsView fv;
                        int row = TermTable.this.getSelectedRow();
                        if (row >= 0) {
                            TermsView.this.selectedTerm = TermsView.this.doc.getTerms()[row];
                            TermsView.this.selectedTermIndex = row;
                        } else {
                            TermsView.this.selectedTerm = null;
                            TermsView.this.selectedTermIndex = -1;
                        }
                        if (((TermsView)((TermTable)TermTable.this).TermsView.this).doc.getPreferences().collectAllForms && (fv = TermsView.this.doc.getFormsView()) != null) {
                            fv.setData(TermsView.this.selectedTerm);
                        }
                        if (((TermsView)((TermTable)TermTable.this).TermsView.this).doc.getPreferences().makeIndex && (sv = TermsView.this.doc.getSentencesView()) != null) {
                            sv.setData(TermsView.this.selectedTerm);
                        }
                        if (((TermsView)((TermTable)TermTable.this).TermsView.this).doc.getPreferences().makeGroups && (gv = TermsView.this.doc.getGroupsView()) != null) {
                            gv.setData((TermEx)TermsView.this.selectedTerm);
                        }
                    }
                }
            });
        }

        public void changeFontSize() {
            FontMetrics fm = this.getFontMetrics(TermoPL.preferences.plainFont);
            TableColumnModel columnModel = this.getColumnModel();
            TableHeader tableHeader = new TableHeader(columnModel);
            Rectangle r = this.getVisibleRect();
            Point p = r.getLocation();
            int h = fm.getHeight() + 4;
            int x = this.rowAtPoint(p);
            this.setRowHeight(h);
            this.setTableHeader(tableHeader);
            int i = 0;
            while (i < columnModel.getColumnCount()) {
                TableColumn column = columnModel.getColumn(i);
                column.setHeaderRenderer(tableHeader.getDefaultRenderer());
                ++i;
            }
            r.y = x * h;
            this.scrollRectToVisible(r);
            TermsView.this.tableScrollPane.revalidate();
            TermsView.this.tableScrollPane.repaint();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void resetResults() {
            if (TermsView.this.doc.getTerms() == null) {
                this.showColumns(false);
            } else {
                this.showColumns(true);
                this.clearSelection();
                this.revalidate();
                this.scrollRectToVisible(CommonResources.nullRect);
                this.repaint();
            }
            this.getTableHeader().repaint();
        }

        public void sortTable(int column) {
            TermsView.this.doc.sortTable(column);
            Term[] terms = TermsView.this.doc.getTerms();
            if (TermsView.this.selectedTerm != null) {
                int i = 0;
                while (i < terms.length) {
                    if (terms[i] == TermsView.this.selectedTerm) break;
                    ++i;
                }
                this.clearSelection();
                this.addRowSelectionInterval(i, i);
            }
            if (TermsView.this.selectedTerm != null) {
                TermsView.this.showSelected();
            }
            this.repaint();
            this.getTableHeader().repaint();
        }

        public void showColumns(boolean show) {
            if (TermsView.this.columnsAreVisible != show) {
                TermsView.this.columnsAreVisible = show;
                int i = 0;
                while (i < this.tableColumns.length) {
                    if (show) {
                        if (i == 4) {
                            if (((TermsView)TermsView.this).doc.getPreferences().applyContrastiveRanking && TermsView.this.doc.getCTerms() != null) {
                                this.addColumn(this.tableColumns[i]);
                            }
                        } else {
                            this.addColumn(this.tableColumns[i]);
                        }
                    } else {
                        this.removeColumn(this.tableColumns[i]);
                    }
                    ++i;
                }
                if (show) {
                    TableColumnModel columnModel = this.getColumnModel();
                    int i2 = 0;
                    while (i2 < columnModel.getColumnCount()) {
                        TableColumn column = columnModel.getColumn(i2);
                        column.setHeaderRenderer(this.tableHeader.getDefaultRenderer());
                        ++i2;
                    }
                }
            }
            this.placeHolder.showBottomLine(show);
        }

        public void changeHeader() {
            this.tableColumns[4].setHeaderValue(CMETHODS[((TermsView)TermsView.this).doc.getPreferences().contrastiveRankingMethod - 1]);
            this.getTableHeader().repaint();
        }
    }
}

