package termopl;

import java.io.Serializable;
import java.util.*;

@SuppressWarnings("serial")
public class Form implements Serializable
{

	private LinkedList<MatchedToken> tokens;
	private int inner;
	private int standalone;

	public Form()
	{
		this.tokens = null;
		inner = standalone = 0;
	}
	
	public static Form createFromMatchedTokens(LinkedList<MatchedToken> tokens)
	{
		Form form = new Form();
		
		form.tokens = tokens;
		return form;
	}
	
	public static Form createFromTokens(LinkedList<? extends Token> tokens)
	{
		Form form = new Form();
		
		form.tokens = convertToMatchedTokens(tokens);
		return form;
	}
	
	public static LinkedList<MatchedToken> convertToMatchedTokens(LinkedList<? extends Token> tokens)
	{
		LinkedList<MatchedToken> list = new LinkedList<MatchedToken>();
		
		for (Token t : tokens) {
			MatchedToken mt = new MatchedToken(t);
			list.add(mt);
		}
		
		MatchedToken head = findHead(list);
		
		if (head != null) {
			Token ht = head.token;
			int s, e;
			
			head.head = true;
			if (ht instanceof UDToken) s = e = ((UDToken)ht).index;
			else {
				s = ((MultiWordToken)ht).startToken();
				e = ((MultiWordToken)ht).endToken();
			}
			head.computeBaseForm = true;
			for (MatchedToken mt : list) {
				if (mt != head) {
					Token t = mt.token;
					
					if (t instanceof UDToken) {
						UDToken ut = (UDToken)t;
						if (ut.UDLink >= s && ut.UDLink <= e && ExtractorEngine.headPhraseRel(ut)) mt.computeBaseForm = true;
					}
				}
			}
		}
		return list;
	}
	
	public static MatchedToken findHead(LinkedList<MatchedToken> tokens)
	{
		MatchedToken head = null;
		
		for (MatchedToken mt : tokens) {
			Token t = mt.token;
			
			if (t instanceof UDToken) {
				if (!findUDLink(((UDToken)t).UDLink, tokens)) {
					head = mt;
					break;
				}
			}
			else {
				MultiWordToken mwt = (MultiWordToken)t;
				boolean found = false;
				
				for (UDToken ut : mwt.getTokens()) {
					if (findUDLink(ut.UDLink, tokens)) {
						found = true;
						break;
					}
				}
				if (!found) {
					head = mt;
					break;
				}
			}
		}
		return head;
	}
	
	public static boolean findUDLink(int link, LinkedList<MatchedToken> tokens) 
	{
		for (MatchedToken mt : tokens) {
			Token t = mt.token;
			
			if (t instanceof UDToken) {
				if (link == ((UDToken)t).index) return true;
			}
			else {
				MultiWordToken mwt = (MultiWordToken)t;
				
				for (UDToken it : mwt.getTokens()) {
					if (link == it.index) return true;
				}
			}
		}
		return false;
	}
	
	public int hashCode()
	{
		if (tokens == null) return 0;
		return tokens.size();
	}
	
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (obj instanceof Form) {
			Form form = (Form)obj;
			
			if (form.length() != this.length()) return false;
			
			LinkedList<MatchedToken> list = form.getTokens();
			ListIterator<MatchedToken> it1 = list.listIterator();
			ListIterator<MatchedToken> it2 = tokens.listIterator();
			
			while (it1.hasNext()) {
				Token t1 = it1.next().token;
				Token t2 = it2.next().token;
				
				if (!t1.form.equals(t2.form)) return false;
			}
			return true;
		}
		return false;
	}
	
	public void addOccurence(boolean asInner)
	{
		if (asInner) inner++;
		else standalone++;
	}
	
	public LinkedList<MatchedToken> getTokens()
	{
		return tokens;
	}
	
	public MatchedToken getMatchedToken(int index)
	{
		if (tokens != null && tokens.size() > index) return tokens.get(index);
		return null;
	}
	
	public int length()
	{
		if (tokens == null) return 0;
		return tokens.size();
	}
	
	public void addInnerOccurences(int n)
	{
		inner += n;
	}
	
	public int innerOccurences()
	{
		return inner;
	}
	
	public void addStandaloneOccurences(int n)
	{
		standalone += n;
	}
	
	public int standaloneOccurences()
	{
		return standalone;
	}
	
	public int allOccurences()
	{
		return standalone + inner;
	}
	
	public String[] getLemmas()
	{
		String[] lemmas = new String[tokens.size()];
		int i = 0;
		
		for (MatchedToken t : tokens) {
			lemmas[i++] = t.token.lemma;
		}
		return lemmas;
	}
	
	public String getTag()
	{
		String tag = null;
		
		for (MatchedToken mt : getTokens()) {
			if (mt.computeBaseForm) {
				Token t = mt.token;
				
				if (t instanceof MultiWordToken) {
					continue;
				}
				else if (t instanceof UDToken) {
					UDToken ut = (UDToken)t;
					
					tag = ut.UDTag;
					break;
				}
				else {
					tag = t.ctag;
					break;
				}
			}
		}
		return tag;
	}
	
	public String toString()
	{
		StringBuffer buffer = new StringBuffer();
		Token prev = null;
		int index = 0, prevIndex = 0;
		boolean appendSpace = false;
		
		for (MatchedToken mt : getTokens()) {
			Token tok = mt.token;
			
			if (tok instanceof UDToken) index = ((UDToken) tok).index;
			else if (tok instanceof MultiWordToken) index = ((MultiWordToken) tok).endToken();
			else index = prevIndex + 1;
			
			if (prev != null) {
				if (appendSpace || index > prevIndex + 1) buffer.append(" ");
			}
			buffer.append(tok.form);
			appendSpace = tok.spaceAfter;
			prev = tok;
			prevIndex = index;
		}
		return buffer.toString();	
	}
	
	public String occurences()
	{
		return "[" + standalone + "," + inner + "]";
	}
	
}
