package termopl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.border.Border;

@SuppressWarnings("serial")
public class LangCombo extends JComboBox<LanguageInfo> 
{
	
	private Font plain;
	private Font italic;
	private Color comboNormal;
	private Color comboGrayedOut;
	
	public LangCombo()
	{
		plain = getFont();
		italic = plain.deriveFont(Font.ITALIC);
		comboNormal = UIManager.getColor("ComboBox.foreground");
		comboGrayedOut = UIManager.getColor("ComboBox.disabledForeground");
		addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event)
			{
				if (getSelectedIndex() == 0) {
					setFont(italic);
					setForeground(comboGrayedOut);
				}
				else {
					setFont(plain);
					setForeground(comboNormal);
				}
			}
		});
	}
	
	public void addItem(LanguageInfo languageInfo)
	{
		super.addItem(languageInfo);
		setRenderer(new LangRenderer());
	}

	private class LangRenderer extends JLabel implements ListCellRenderer<LanguageInfo>
	{
		
		private Border cellBorder;
		private JLabel selectLabel;
		
		public LangRenderer()
		{
			cellBorder = BorderFactory.createEmptyBorder(2, 8, 2, 0);
			selectLabel = new JLabel("Select...");
		}
		
		public Component getListCellRendererComponent(JList<? extends LanguageInfo> list, LanguageInfo value, int index,
				boolean isSelected, boolean cellHasFocus) 
		{
			JLabel label = this;
			Color color;
			
			if (value.getName() == null && value.getLanguageCode() == null) {
				label = selectLabel;
				label.setFont(italic);
				color = comboGrayedOut;
			}
			else {
				label.setText(value.getName());
				label.setFont(plain);
				color = comboNormal;
			}
			label.setBorder(cellBorder);
			label.setIconTextGap(8);
		    label.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
		    label.setForeground(isSelected ? list.getSelectionForeground() : color);
		    label.setOpaque(true);
			return label;
		}
		
	}
	
}
