package termopl;

import java.awt.Toolkit;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

public class MenuFactory 
{
	
	private static final int keyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
	private static final MenuSelectionListener menuListener = new MenuSelectionListener();
	
	// Create menu bar
	public static JMenuBar createMenuBar(boolean isMacOS)
	{
		LinkedList<String> files = TermoPL.preferences.recentFiles;
		JMenuBar menuBar = new JMenuBar();
		JMenu menu, submenu;
		int mnemonicKey = 0;
		
		// File menu
		if (!isMacOS) mnemonicKey = 'F';
		menu = createMenu("File", mnemonicKey);
		if (!isMacOS) mnemonicKey = 'N';
		menu.add(createMenuItem(Command.newCommand, mnemonicKey, KeyEvent.VK_N, keyMask));
		if (!isMacOS) mnemonicKey = 'O';
		menu.add(createMenuItem(Command.openCommand, mnemonicKey, KeyEvent.VK_O, keyMask));
		if (!isMacOS) mnemonicKey = 'M';
		menu.add(createMenuItem(Command.mergeCommand, mnemonicKey, KeyEvent.VK_M, keyMask));
		if (!isMacOS) mnemonicKey = 'R';
		submenu = createMenu("Open Recent", mnemonicKey);
		for (String path : files) {
			submenu.add(createOpenRecentMenuItem(path));
		}
		menu.add(submenu);
		if (!isMacOS) mnemonicKey = 'C';
		menu.add(createMenuItem(Command.closeCommand, mnemonicKey, KeyEvent.VK_W, keyMask));
		if (!isMacOS) mnemonicKey = 'S';
		menu.add(createMenuItem(Command.saveCommand, mnemonicKey, KeyEvent.VK_S, keyMask));
		if (!isMacOS) mnemonicKey = 'A';
		menu.add(createMenuItem(Command.saveAsCommand, mnemonicKey));
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'W';
		menu.add(createMenuItem(Command.workspaceCommand, mnemonicKey));
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'E';
		menu.add(createMenuItem(Command.exportCommand, mnemonicKey));		
		if (!isMacOS) mnemonicKey = 'P';
		menu.add(createMenuItem(Command.exportFormsCommand, mnemonicKey));		
		if (!isMacOS) mnemonicKey = 'T';
		menu.add(createMenuItem(Command.exportSentencesCommand, mnemonicKey));		
		if (!isMacOS) mnemonicKey = 'G';
		menu.add(createMenuItem(Command.exportGroupsCommand, mnemonicKey));		
		if (!isMacOS) {
			menu.addSeparator();
			mnemonicKey = 'X';
			menu.add(createMenuItem(Command.exitCommand, mnemonicKey));
		}
		menuBar.add(menu);
		
		// Search menu
		if (!isMacOS) mnemonicKey = 'S';
		menu = createMenu("Search", mnemonicKey);
		if (!isMacOS) mnemonicKey = 'E';
		menu.add(createMenuItem(Command.extractCommand, mnemonicKey, KeyEvent.VK_E, keyMask));
		if (!isMacOS) mnemonicKey = 'C';
		menu.add(createMenuItem(Command.compareCommand, mnemonicKey));
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'S';
		menu.add(createMenuItem(Command.selectFilesCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'T';
		menu.add(createMenuItem(Command.selectContrastiveTermsCommand, mnemonicKey));
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'B';
		menu.add(createCheckBoxMenuItem(Command.baseFormsCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'F';
		menu.add(createCheckBoxMenuItem(Command.collectCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'I';
		menu.add(createCheckBoxMenuItem(Command.indexCommand, mnemonicKey));
		if (!isMacOS) {
			menu.addSeparator();
			mnemonicKey = 'P';
			menu.add(createMenuItem(Command.preferencesCommand, mnemonicKey));
		}
		menuBar.add(menu);
		
		// View menu
		if (!isMacOS) mnemonicKey = 'V';
		menu = createMenu("View", mnemonicKey);
		if (!isMacOS) mnemonicKey = 'F';
		menu.add(createMenuItem(Command.formsCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'S';
		menu.add(createMenuItem(Command.sentencesCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'G';
		menu.add(createMenuItem(Command.groupsCommand, mnemonicKey));
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'I';
		menu.add(createMenuItem(Command.increaseCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'D';
		menu.add(createMenuItem(Command.decreaseCommand, mnemonicKey));
		menuBar.add(menu);
		
		// Window menu 
		if (!isMacOS)  mnemonicKey = 'W';
		menu = createMenu("Window", mnemonicKey);
		if (!isMacOS) mnemonicKey = 'S';
		menu.add(createMenuItem(Command.showOneAll, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'D';
		submenu = createMenu("Document Switch List", mnemonicKey);
		menu.add(submenu);
		menu.addSeparator();
		if (!isMacOS) mnemonicKey = 'T';
		menu.add(createMenuItem(Command.tileCommand, mnemonicKey));
		if (!isMacOS) mnemonicKey = 'C';
		menu.add(createMenuItem(Command.cascadeCommand, mnemonicKey));
		menuBar.add(menu);
		
		// Help menu
		mnemonicKey = (isMacOS ? 0 : 'H');
		menu = createMenu("Help ", mnemonicKey);
		if (!isMacOS) {
			mnemonicKey = 'A';
			menu.add(createMenuItem(Command.aboutCommand, mnemonicKey));
			menu.addSeparator();
		}
		mnemonicKey = (isMacOS ? 0 : 'M');
		menu.add(createMenuItem(Command.helpCommand, mnemonicKey));
		menuBar.add(menu);
		
		return menuBar;
	}
	
	// Create menu
	public static JMenu createMenu(String label, int mnemonicKey, MenuListener menuListener)
	{
		JMenu menu = new JMenu(label);
		if (menuListener != null) menu.addMenuListener(menuListener);
		if (mnemonicKey != 0) menu.setMnemonic(mnemonicKey);
		return menu;
	}
	
	public static JMenu createMenu(String label, int mnemonicKey)
	{
		return createMenu(label, mnemonicKey, menuListener); 
	}
	
	// Create menu item
	public static JMenuItem createMenuItem(Command tileCommand, int mnemonicKey)
	{
		JMenuItem menuItem = new JMenuItem(tileCommand);
		
		if (mnemonicKey != 0) menuItem.setMnemonic(mnemonicKey);
		return menuItem;
	}
	
	public static JMenuItem createMenuItem(Command command, int mnemonicKey, int acceleratorKey, int keyMask)
	{
		JMenuItem menuItem = createMenuItem(command, mnemonicKey);
		
		if (acceleratorKey != 0) menuItem.setAccelerator(KeyStroke.getKeyStroke(acceleratorKey, keyMask));
		
		return menuItem;
	}
	
	public static JCheckBoxMenuItem createCheckBoxMenuItem(Command command, int mnemonicKey)
	{
		JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(command);
		
		if (mnemonicKey != 0) menuItem.setMnemonic(mnemonicKey);
		return menuItem;
	}

	@SuppressWarnings("serial")
	public static AssocMenuItem createOpenRecentMenuItem(String path)
	{
		AbstractAction action = new AbstractAction(new File(path).getName()) {
			public void actionPerformed(ActionEvent event)
			{
				AssocMenuItem source = (AssocMenuItem)event.getSource();
				String path = (String)source.getAssociation();
				
				TermoPL.application.open(path);
			}
		};
		return new AssocMenuItem(path, action);
	}
	
	@SuppressWarnings("serial")
	public static AssocRadioButtonMenuItem createDocumentSwitchMenuItem(TermoPLDocument doc)
	{
		AbstractAction action = new AbstractAction(doc.getDocumentDisplayName()) {
			public void actionPerformed(ActionEvent event)
			{
				AssocRadioButtonMenuItem source = (AssocRadioButtonMenuItem)event.getSource();
				TermoPLDocument doc = (TermoPLDocument)source.getAssociation();
				
				TermoPL.application.bringToFront(doc);
			}
		};
		return new AssocRadioButtonMenuItem(doc, action);
	}
	
	@SuppressWarnings("serial")
	public static AssocRadioButtonMenuItem createWindowMenuItem(TermoPLWindow wnd)
	{
		String str = wnd.getTitle();
		int i = str.indexOf('[');
		
		if (i > 0) str = str.substring(0, i - 1);
		
		AbstractAction action = new AbstractAction(str) {
			public void actionPerformed(ActionEvent event)
			{
				AssocRadioButtonMenuItem source = (AssocRadioButtonMenuItem)event.getSource();
				TermoPLWindow wnd = (TermoPLWindow)source.getAssociation();
				
				wnd.select();
			}
		};
		return new AssocRadioButtonMenuItem(wnd, action);
	}
	
	public static void removeRecentFile(String path)
	{
		if (TermoPL.isMacOS) removeRecentFileInAllFrames(path);
		else removeRecentFileInMasterFrame(path);
	}
	
	public static void removeRecentFile(JMenu menu, String path)
	{
		int count = menu.getItemCount();
		AssocMenuItem it = null;
		int i;
		boolean found = false;
		
		for (i = 0; i < count; i++) {
			it = (AssocMenuItem)menu.getItem(i);
			if (((String)it.getAssociation()).equals(path)) {
				found = true;
				break;
			}
		}
		if (found) menu.remove(i);
	}
	
	public static void removeRecentFileInMasterFrame(String path)
	{
		removeRecentFile(getRecentFileMenu(TermoPL.mainWindow.getJMenuBar()), path);
	}
	
	public static void removeRecentFileInAllFrames(String path)
	{
		removeRecentFileInMasterFrame(path);
		
		for (TermoPLDocument document : TermoPL.documents) {
			for (TermoPLWindow window : document.getWindows()) {
				JFrame frame = (JFrame)window;
				
				removeRecentFile(getRecentFileMenu(frame.getJMenuBar()), path);
			}
		}
	}
	
	public static void updateRecentFiles(String path)
	{
		if (TermoPL.isMacOS) updateRecentFilesInAllFrames(path);
		else updateRecentFilesInMasterFrame(path);
	}
	
	public static void updateRecentFiles(JMenu menu, String path)
	{
		int count = menu.getItemCount();
		AssocMenuItem it = null;
		int i;
		boolean found = false;
		
		for (i = 0; i < count; i++) {
			it = (AssocMenuItem)menu.getItem(i);
			if (((String)it.getAssociation()).equals(path)) {
				found = true;
				break;
			}
		}
		if (found) {
			menu.remove(i);
			menu.insert(it, 0);
		}
		else {
			if (count >= TermoPL.MAX_RECENT_FILES) menu.remove(count - 1);
			it = createOpenRecentMenuItem(path);
			menu.insert(it, 0);
		}
	}
	
	public static void updateRecentFilesInMasterFrame(String path)
	{
		updateRecentFiles(getRecentFileMenu(TermoPL.mainWindow.getJMenuBar()), path);
	}
	
	public static void updateRecentFilesInAllFrames(String path)
	{
		updateRecentFilesInMasterFrame(path);
		
		for (TermoPLDocument document : TermoPL.documents) {
			for (TermoPLWindow window : document.getWindows()) {
				JFrame frame = (JFrame)window;
				
				updateRecentFiles(getRecentFileMenu(frame.getJMenuBar()), path);
			}
		}
	}
	
	public static void addToDocumentSwitchMenu(TermoPLDocument doc)
	{
		if (TermoPL.isMacOS) addToDocumentSwitchMenuInAllFrames(doc);
		else addToDocumentSwitchMenuInMasterFrame(doc);
	}

	public static void addToDocumentSwitchMenu(JMenu menu, TermoPLDocument doc)
	{
		AssocRadioButtonMenuItem it = createDocumentSwitchMenuItem(doc);
		
		menu.add(it);
	}
	
	public static void addToDocumentSwitchMenuInMasterFrame(TermoPLDocument doc)
	{
		addToDocumentSwitchMenu(getDocumentSwitchMenu(TermoPL.mainWindow.getJMenuBar()), doc);
	}
	
	public static void addToDocumentSwitchMenuInAllFrames(TermoPLDocument doc)
	{
		addToDocumentSwitchMenuInMasterFrame(doc);
		
		for (TermoPLDocument document : TermoPL.documents) {
			for (TermoPLWindow window : document.getWindows()) {
				JFrame frame = (JFrame)window;
				
				addToDocumentSwitchMenu(getDocumentSwitchMenu(frame.getJMenuBar()), doc);
			}
		}
	}
	
	public static void removeFromDocumentSwitchMenu(TermoPLDocument doc)
	{
		if (TermoPL.isMacOS) removeFromDocumentSwitchMenuInAllFrames(doc);
		else removeFromDocumentSwitchMenuInMasterFrame(doc);
	}
	
	public static void removeFromDocumentSwitchMenu(JMenu menu, TermoPLDocument doc)
	{
		int count = menu.getItemCount();
		AssocRadioButtonMenuItem it = null;
		int i;
		boolean found = false;
		
		for (i = 0; i < count; i++) {
			it = (AssocRadioButtonMenuItem)menu.getItem(i);
			if (((TermoPLDocument)it.getAssociation()).equals(doc)) {
				found = true;
				break;
			}
		}
		if (found) menu.remove(i);
	}
	
	public static void removeFromDocumentSwitchMenuInMasterFrame(TermoPLDocument doc)
	{
		removeFromDocumentSwitchMenu(getDocumentSwitchMenu(TermoPL.mainWindow.getJMenuBar()), doc);	
	}
	
	public static void removeFromDocumentSwitchMenuInAllFrames(TermoPLDocument doc)
	{
		removeFromDocumentSwitchMenuInMasterFrame(doc);	
		
		for (TermoPLDocument document : TermoPL.documents) {
			for (TermoPLWindow window : document.getWindows()) {
				JFrame frame = (JFrame)window;
				
				removeFromDocumentSwitchMenu(getDocumentSwitchMenu(frame.getJMenuBar()), doc);
			}
		}
	}
	
	public static void resetSelection(TermoPLDocument doc, TermoPLWindow wnd)
	{
		if (TermoPL.isMacOS) resetSelection(doc, wnd, ((JFrame)wnd).getJMenuBar());
		else resetSelection(doc, wnd, TermoPL.mainWindow.getJMenuBar());
	}
	
	public static void resetSelection(TermoPLDocument doc, TermoPLWindow wnd, JMenuBar mbar)
	{
		JMenu menu = getWindowMenu(mbar);
		int count = menu.getItemCount();
		
		if (count > 5) {
			for (int i = 6; i < count; i++) {
				AssocRadioButtonMenuItem it = (AssocRadioButtonMenuItem)(menu.getItem(i));
				
				it.setSelected(it.getAssociation() == wnd);
			}
		}
		menu = getDocumentSwitchMenu(mbar);
		count = menu.getItemCount();
		for (int i = 0; i < count; i++) {
			AssocRadioButtonMenuItem it = (AssocRadioButtonMenuItem)(menu.getItem(i));
			
			it.setSelected(it.getAssociation() == doc);
		}
	}
	
	public static void addToWindowMenu(JMenu menu, TermoPLWindow wnd)
	{
		AssocRadioButtonMenuItem it = createWindowMenuItem(wnd);
		int count = menu.getItemCount();
		
		if (count == 5) menu.addSeparator();
		menu.add(it);
	}
	
	public static void resetWindowMenu(TermoPLDocument doc)
	{
		resetWindowMenu(getWindowMenu(TermoPL.mainWindow.getJMenuBar()), doc);
	}
	
	public static void resetWindowMenu(TermoPLDocument doc, TermoPLWindow wnd)
	{
		resetWindowMenu(getWindowMenu(((JFrame)(wnd)).getJMenuBar()), doc);
	}
	
	public static void resetWindowMenu(JMenu menu, TermoPLDocument doc)
	{
		int count = menu.getItemCount() - 5;
		
		if (count > 0) {
			for (int i = 0; i < count; i++) menu.remove(5);
		}
		for (TermoPLWindow window : doc.getWindows()) {
			addToWindowMenu(menu, window);
		}
	}
	
	public static JMenu getRecentFileMenu(JMenuBar mbar)
	{
		return (JMenu)(mbar.getMenu(0).getItem(3));
	}
	
	public static JMenu getDocumentSwitchMenu(JMenuBar mbar)
	{
		return (JMenu)(mbar.getMenu(3).getItem(1));
	}
	
	public static JMenu getWindowMenu(JMenuBar mbar)
	{
		return mbar.getMenu(3);
	}
	
}
