package termopl;

import java.io.*;
import java.util.*;

public class TParser extends Parser 
{

	private File tagsetFile;
	private Tagset tagset;
	
	public TParser(File file, Object owner)
	{
		super(owner);
		tagsetFile = file;
	}
	
	public void parse()
	{
		tagset = new Tagset();
		try {
			reader = new BufferedReader(new InputStreamReader(
				new FileInputStream(tagsetFile), "UTF8"));
			getSymbol();
			if (symbol == Symbol.IDENTIFIER) {
				identifier = identifier.toLowerCase();
				if (identifier.equals("tag")) {
					getSymbol();
					if (symbol == Symbol.EQ) {
						getSymbol();
						if (symbol == Symbol.IDENTIFIER) {
							if (identifier.toLowerCase().equals("pos")) {
								tagset.setType(Tagset.POS_TAG);
							}
							else {
								error(ParserError.KEYWORD_POS);
								skip(Symbol.LANGLE);
							}
						}
					}
					else {
						error(ParserError.EQ_EXPECTED);
						skip(Symbol.LANGLE);
					}
				}
				else if (identifier.equals("delimiter")) {
					getSymbol();
					if (symbol == Symbol.EQ) {
						getSymbol();
						if (symbol == Symbol.STRING) {
							if (string.isEmpty()) tagset.setDelimiter("(?!^)");
							else tagset.setDelimiter(string);
						}
						else {
							error(ParserError.STRING_EXPECTED);
							skip(Symbol.LANGLE);
						}
					}
					else {
						error(ParserError.EQ_EXPECTED);
						skip(Symbol.LANGLE);
					}
				}
				else {
					error(ParserError.KEYWORD_TAG_DELIMITER);
					skip(Symbol.LANGLE);
				}
				getSymbol();
			}
			if (tagset.getType() != Tagset.POS_TAG) {
				if (symbol == Symbol.LANGLE) {
					getSymbol();
					if (symbol == Symbol.IDENTIFIER) {
						if (!identifier.equals("categories")) {
							error(ParserError.KEYWORD_CATEGORIES);
							skip(Symbol.LANGLE);
						}
						else {
							getSymbol();
							if (symbol == Symbol.IDENTIFIER) {
								if (!identifier.equals("by")) {
									error(ParserError.KEYWORD_BY);
									skip(Symbol.LANGLE);
								}
								else {
									getSymbol();
									if (symbol == Symbol.IDENTIFIER) {
										if (identifier.equals("positions")) {
											getSymbol();
											if (symbol == Symbol.RANGLE) parseCategoriesByPositions();
											else {
												error(ParserError.RANGLE_EXPECTED);
												skip(Symbol.LANGLE);
											}
	
										}
										else if (identifier.equals("values")) {
											getSymbol();
											if (symbol == Symbol.RANGLE) parseCategoriesByValues();
											else {
												error(ParserError.RANGLE_EXPECTED);
												skip(Symbol.LANGLE);
											}
	
										}
										else {
											error(ParserError.KEYWORD_POS_VAL);
											skip(Symbol.LANGLE);
										}
									}
									else {
										error(ParserError.KEYWORD_POS_VAL);
										skip(Symbol.LANGLE);
									}
								}
							}
							else {
								error(ParserError.KEYWORD_BY);
								skip(Symbol.LANGLE);
							}
						}
					}
					else {
						error(ParserError.KEYWORD_CATEGORIES);
						skip(Symbol.LANGLE);
					}
				}
				else {
					error(ParserError.LANGLE_EXPECTED);
					skip(Symbol.LANGLE);
				}
				if (symbol == Symbol.LANGLE) {
					getSymbol();
					if (symbol == Symbol.IDENTIFIER) {
						if (!identifier.equals("definitions")) {
							error(ParserError.KEYWORD_DEFINITIONS);
							skip(Symbol.EMPTY);
						}
						else {
							getSymbol();
							if (symbol == Symbol.RANGLE) parseDefinitions();
							else {
								error(ParserError.RANGLE_EXPECTED);
								skip(Symbol.EMPTY);
							}
						}
					}
					else {
						error(ParserError.KEYWORD_DEFINITIONS);
						skip(Symbol.EMPTY);
					}
				}
				getSymbol();
				if (symbol != Symbol.EMPTY) {
					error(ParserError.END_OF_FILE_EXPECTED);
				}
			}
			else if (symbol != Symbol.EMPTY) {
				error(ParserError.END_OF_FILE_EXPECTED);
			}
		}
		catch (Exception exception) {
			try {
				error(exception.getStackTrace().toString());
			} 
			catch (ParserException e) {
			}
		}
		if (!noErrors()) tagset = null;
		reportErrors();
	}
	
	public void parseCategoriesByPositions() throws ParserException
	{
		LinkedList<String> list = new LinkedList<String>();
		LinkedList<String> clsList = new LinkedList<String>();
		String cls = null;
		Symbol prev = Symbol.EMPTY;
		
		tagset.setType(Tagset.CATEGORY_BY_POSITION);
		getSymbol();
		while (!tooManyErrors() && symbol != Symbol.LANGLE && symbol != Symbol.EMPTY) {
			if (symbol == Symbol.IDENTIFIER) {
				if (prev == Symbol.IDENTIFIER) {
					if (list.isEmpty()) {
						error(ParserError.COMMA_EXPECTED);
					}
					else {
						if (cls == null) tagset.setDefaultCategories(list);
						else tagset.addCategoriesToClass(cls, list);
						cls = null;
						list = new LinkedList<String>();
						list.add(identifier);
					}
				}
				else list.add(identifier);
			}
			else if (symbol == Symbol.COMMA) {
				if (prev != Symbol.IDENTIFIER) {
					error(ParserError.ILLEGAL_SYMBOL);
					skip(Symbol.IDENTIFIER, Symbol.LANGLE);
				}
			}
			else if (symbol == Symbol.COLON) {
				if (prev != Symbol.IDENTIFIER) {
					error(ParserError.ILLEGAL_SYMBOL);
					skip(Symbol.IDENTIFIER, Symbol.LANGLE);
				}
				else {
					cls = list.removeLast();
					
					if (clsList.contains(cls)) {
						error(ParserError.CLASS_DEFINED);
					}
					clsList.add(cls);
				}
			}
			else {
				error(ParserError.ILLEGAL_SYMBOL);
				skip(Symbol.IDENTIFIER, Symbol.LANGLE);
			}
			prev = symbol;
			getSymbol();
		}
		if (!list.isEmpty()) {
			if (cls == null) tagset.setDefaultCategories(list);
			else tagset.addCategoriesToClass(cls, list);
		}
		if (tagset.getCategories().isEmpty()) error(ParserError.NO_CATEGORY_DEFINED);
	}
	
	public void parseCategoriesByValues() throws ParserException
	{
		LinkedList<String> list = new LinkedList<String>();
		String cat = null;
		Symbol prev = Symbol.EMPTY;
		boolean mustBeColon = false;
		
		tagset.setType(Tagset.CATEGORY_BY_VALUE);
		getSymbol();
		while (!tooManyErrors() && symbol != Symbol.LANGLE && symbol != Symbol.EMPTY) {
			if (mustBeColon) {
				mustBeColon = false;
				if (symbol != Symbol.COLON) error(ParserError.COLON_EXPECTED);
			}
			else {
				if (symbol == Symbol.IDENTIFIER) {
					if (cat == null) {
						cat = identifier;
						mustBeColon = true;
					}
					else if (prev == Symbol.IDENTIFIER) {
						if (tagset.isCategoryDefined(identifier)) error(ParserError.CATEGORY_DEFINED);
						tagset.addCategory(cat, list);
						list = new LinkedList<String>();
						cat = identifier;
						mustBeColon = true;
					}
					else list.add(identifier);
				}
				else if (symbol == Symbol.COMMA) {
					if (prev != Symbol.IDENTIFIER) {
						error(ParserError.ILLEGAL_SYMBOL);
						skip(Symbol.IDENTIFIER, Symbol.LANGLE);
					}
				}
				else if (symbol == Symbol.COLON) {
					if (prev != Symbol.IDENTIFIER) {
						error(ParserError.ILLEGAL_SYMBOL);
						skip(Symbol.IDENTIFIER, Symbol.LANGLE);
					}
				}
				else {
					error(ParserError.ILLEGAL_SYMBOL);
					skip(Symbol.IDENTIFIER, Symbol.LANGLE);
				}
			}
			prev = symbol;
			getSymbol();
		}
		if (!list.isEmpty()) tagset.addCategory(cat, list);
		if (tagset.getCategories().isEmpty()) error(ParserError.NO_CATEGORY_DEFINED);
	}
	
	public void parseDefinitions() throws ParserException
	{
		String list = "";
		String sym = null;
		Symbol prev = Symbol.EMPTY;
		boolean mustBeEQ = false;
		
		getSymbol();
		while (!tooManyErrors() && symbol != Symbol.LANGLE && symbol != Symbol.EMPTY) {
			if (mustBeEQ) {
				mustBeEQ = false;
				if (symbol != Symbol.EQ) error(ParserError.EQ_EXPECTED);
			}
			else {
				if (symbol == Symbol.IDENTIFIER) {
					if (sym == null) {
						sym = identifier;
						mustBeEQ = true;
					}
					else if (prev == Symbol.IDENTIFIER) {
						tagset.addDefinition(sym, list);
						list = "";
						sym = identifier;
						mustBeEQ = true;
					}
					else {
						if (list.isEmpty()) list = identifier;
						else list += "," + identifier;
					}
				}
				else if (symbol == Symbol.COMMA) {
					if (prev != Symbol.IDENTIFIER) {
						error(ParserError.ILLEGAL_SYMBOL);
						skip(Symbol.IDENTIFIER, Symbol.LANGLE);
					}
				}
				else if (symbol == Symbol.EQ) {
					if (prev != Symbol.IDENTIFIER) {
						error(ParserError.ILLEGAL_SYMBOL);
						skip(Symbol.IDENTIFIER, Symbol.LANGLE);
					}
				}
				else {
					error(ParserError.ILLEGAL_SYMBOL);
					skip(Symbol.IDENTIFIER, Symbol.LANGLE);
				}
			}
			prev = symbol;
			getSymbol();
		}
		if (!list.isEmpty()) tagset.addDefinition(sym, list);
	}
	
	public void getSymbol() throws ParserException
	{
		int ch = SPACE;
		
		while (Character.isWhitespace(ch)) ch = getNextChar();
		scanPos = charCount - 1;
		if (Character.isLetter(ch)) {
			buffer.setLength(0);
			while (isIdentifierChar(ch)) {
				buffer.append((char)ch);
				ch = getNextChar();
			}
			identifier = buffer.toString();
			symbol = Symbol.IDENTIFIER;
			if (noSkipChar(ch)) charCount--;
		}
		else if (ch == QUOTE) getString();
		else if (ch == LANGLE) symbol = Symbol.LANGLE;
		else if (ch == RANGLE) symbol = Symbol.RANGLE;
		else if (ch == COMMA) symbol = Symbol.COMMA;
		else if (ch == COLON) symbol = Symbol.COLON;
		else if (ch == EQ) symbol = Symbol.EQ;
		else if (ch == EOF) symbol = Symbol.EMPTY;
		else symbol = Symbol.UNKNOWN;
	}
	
	public boolean noSkipChar(int ch)
	{
		return ch == QUOTE || ch == LANGLE || ch == RANGLE || ch == COMMA || ch == COLON || ch == EQ;
	}
	
	public Tagset getTagset()
	{
		return tagset;
	}
	
}
