package termopl;

import java.util.*;

public class Tagset 
{

	public static final int UNDEFINED_TYPE 	      = -1;
	public static final int CATEGORY_BY_POSITION  =  0;
	public static final int CATEGORY_BY_VALUE 	  =  1;
	public static final int POS_TAG				  =  2;
	public static final String DEAULT_DELIMITER   = ":";
	
	private HashSet<String> categories;
	private HashMap<String, String> catByValue;
	private HashMap<String, HashMap<String, Integer>> catByPosition;
	private HashMap<String, Integer> defaultCategories;
	private HashMap<String, String> definitions;
	private String delim;
	private int type;
	
	public Tagset()
	{
		this(UNDEFINED_TYPE);
		delim = DEAULT_DELIMITER;
	}
	
	public Tagset(int type)
	{
		this.type = type;
		delim = DEAULT_DELIMITER;
		categories = new HashSet<String>();
		definitions = new HashMap<String, String>();
		defaultCategories = null;
	}
	
	public static Tagset createDefaultTagset()
	{
		Tagset tagset = new Tagset(CATEGORY_BY_VALUE);
		
		tagset.addDefaultCategories();
		return tagset;
	}

	public void addDefaultCategories()
	{
		addCategory("number", "sg", "pl");
		addCategory("case", "nom", "gen", "dat", "acc", "inst", "loc", "voc");
		addCategory("gender", "m1", "m2", "m3", "f", "n");
		addCategory("sgender", "pt", "ncol", "col");
		addCategory("person", "pri", "sec", "ter");
		addCategory("degree", "pos", "com", "sup");
		addCategory("aspect", "imperf", "perf");
		addCategory("negation", "aff", "neg");
		addCategory("accent", "akc", "nakc");
		addCategory("pprep", "praep", "npraep");
		addCategory("accom", "congr", "rec");
		addCategory("aggl", "nagl", "agl");
		addCategory("vocality", "wok", "nwok");
		addCategory("fstop", "pun", "npun");
		definitions.put("agreement", "number,case,gender");
	}
	
	public void addCategory(String cat, String... values)
	{
		if (catByValue == null) catByValue = new HashMap<String, String>();
		categories.add(cat);
		for (String val : values) catByValue.put(val, cat);
	}
	
	public void addCategory(String cat, List<String> values)
	{
		if (catByValue == null) catByValue = new HashMap<String, String>();
		categories.add(cat);
		for (String val : values) catByValue.put(val, cat);
	}
	
	public void addCategoriesToClass(String cls, String... clist)
	{
		if (catByPosition == null) catByPosition = new HashMap<String, HashMap<String, Integer>>();
		
		HashMap<String, Integer> index = new HashMap<String, Integer>();
		
		for (int i = 0; i < clist.length; i++) {
			categories.add(clist[i]);
			index.put(clist[i], i + 1);
		}
		catByPosition.put(cls, index);
	}
	
	public void addCategoriesToClass(String cls, List<String> clist)
	{
		if (catByPosition == null) catByPosition = new HashMap<String, HashMap<String, Integer>>();
		
		HashMap<String, Integer> index = new HashMap<String, Integer>();
		
		int i = 0;
		
		for (String cat : clist) {
			categories.add(cat);
			index.put(cat, ++i);
		}
		catByPosition.put(cls, index);
	}
	
	public void setDefaultCategories(List<String> clist)
	{
		defaultCategories = new HashMap<String, Integer>();
		
		for (int i = 0; i < clist.size(); i++) {
			String cat = clist.get(i);
			
			categories.add(cat);
			defaultCategories.put(cat, i + 1);
		}
	}
	
	public boolean isCategoryDefined(String cat)
	{
		categories.contains(cat);
		return false;
	}
	
	public void addDefinition(String symbol, String definition)
	{
		definitions.put(symbol,  definition);
	}
	
	public String getDefinition(String symbol)
	{
		if (definitions.containsKey(symbol)) return definitions.get(symbol);
		return null;
	}
	
	public void setType(int type)
	{
		this.type = type;
	}
	
	public int getType()
	{
		return type;
	}
	
	public void setDelimiter(String delim)
	{
		this.delim = delim;
	}
	
	public String getDelimiter()
	{
		return delim;
	}
	
	public HashSet<String> getCategories()
	{
		return categories;
	}
	
	public HashMap<String, HashMap<String, Integer>> getCategoriesByPositions()
	{
		return catByPosition;
	}
	
	public HashMap<String, String> getCategoriesByValues()
	{
		return catByValue;
	}
	
	public String getPos(String tag)
	{
		return getPos(tag.split(delim));
	}
	
	public String getPos(String[] tag)
	{
		return tag[0];
	}
	
	public String getCategory(Token token, String cat)
	{
		return getCategory(token.getTag(this), cat);
	}
	
	public String getCategory(String tag, String cat)
	{
		return getCategory(tag.split(delim), cat);
	}
	
	public String getCategory(String[] tag, String cat)
	{
		if (tag != null && tag.length > 1) {
			if (type == CATEGORY_BY_VALUE) {
				if (catByValue != null) {
					for (int i = 1; i < tag.length; i++) {
						String val = tag[i];
						String c = catByValue.get(val);
	
						if (cat.equals(c)) return val;
					}
				}
			}
			else if (type == CATEGORY_BY_POSITION) {
				String pos = tag[0];
				HashMap<String, Integer> index = null;
				
				if (catByPosition != null && catByPosition.containsKey(pos))
					index = catByPosition.get(pos);
				if (index == null) index = defaultCategories;
				if (index != null) {
					if (index.containsKey(cat)) {
						int i = index.get(cat);
						
						if (i > 0 && i < tag.length) return tag[i];
					}
				}
			}
		}
		return null;
	}
	
}
