package termopl;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyVetoException;

import javax.swing.*;
import javax.swing.event.*;

@SuppressWarnings("serial")
public class TermoPLDefaultWindow extends JInternalFrame implements TermoPLWindow
{

	private int ID;
	private TermoPLDocument doc;
	private InternalFrameListener internalFrameListener;
	
	public TermoPLDefaultWindow(TermoPLDocument doc, int ID, Container view)
	{
		super("",    // empty title,
			  true,  // resizable,
			  true,  // closable
			  true,  // maximizable
			  true); // iconifiable
		this.doc = doc;
		this.ID = ID;
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setContentPane(view);
		pack();
		((DefaultMasterFrame)(TermoPL.mainWindow)).getDesktopPane().add(this);
		internalFrameListener = new InternalFrameAdapter()
		{
			public void internalFrameClosing(InternalFrameEvent event)
			{
				close();
			}
			
			public void internalFrameActivated(InternalFrameEvent event)
			{
				activate();
			}
			
			public void internalFrameDeactivated(InternalFrameEvent event)
			{
				deactivate();
			}
		};
		addInternalFrameListener(internalFrameListener);
		addComponentListener(new ComponentAdapter() {
			public void componentMoved(ComponentEvent event)
			{
				saveBounds();
			}
			
			public void componentResized(ComponentEvent event)
			{
				saveBounds();
			}
		});
	}
	
	public void select()
	{
		try {
			if (isIcon()) setIcon(false);
			setVisible(true);
			toFront();
			setSelected(true);
			activate();
		}
		catch (PropertyVetoException e) {
		}
	}
	
	public int getID()
	{
		return ID;
	}
	
	public TermoPLDocument getDocument()
	{
		return doc;
	}
	
	public void close()
	{
		doc.close(this);
	}
	
	public void destroySelf()
	{
		removeInternalFrameListener(internalFrameListener);
		setVisible(false);
		deactivate();
		try {
			setClosed(true);
		} 
		catch (PropertyVetoException e) {
			e.printStackTrace();
		}
		dispose();
	}
	
	public void activate()
	{
		if (Commander.getCommander() != doc) Commander.setCommander(doc);
		TermoPL.changeZOrder(this);
		MenuFactory.resetWindowMenu(doc);
		MenuFactory.resetSelection(doc, this);
	}
	
	public void deactivate()
	{
		MenuFactory.resetWindowMenu(doc);
		MenuFactory.resetSelection(doc, this);
	}
	
	public void saveBounds()
	{
		Rectangle bounds = getBounds();
		Rectangle r = TermoPL.preferences.getBounds(ID);
		
		if (!bounds.equals(r)) {
			TermoPL.preferences.setBounds(ID, bounds);
			TermoPL.preferences.setModified(true);
		}
	}
	
}
