package termopl;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class TermoPLMacWindow extends JFrame implements TermoPLWindow
{
	
	private int ID;
	private TermoPLDocument doc;
	
	public TermoPLMacWindow(TermoPLDocument doc, int ID, Container view)
	{
		super();
		this.doc = doc;
		this.ID = ID;
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setContentPane(view);
		pack();
		addWindowListener(new WindowAdapter()
		{
			public void windowClosing(WindowEvent event)
			{
				close();
			}
			
			public void windowActivated(WindowEvent event)
			{
				activate();
			}
			
			public void windowDeactivated(WindowEvent event)
			{
				deactivate();
			}
		});
		addComponentListener(new ComponentAdapter() {
			public void componentMoved(ComponentEvent event)
			{
				saveBounds();
			}
			
			public void componentResized(ComponentEvent event)
			{
				saveBounds();
			}
		});
		
		JMenuBar mbar = MenuFactory.createMenuBar(true);
		
		setJMenuBar(mbar);
		for (TermoPLDocument document : TermoPL.documents) {
			MenuFactory.addToDocumentSwitchMenu(MenuFactory.getDocumentSwitchMenu(mbar), document);
		}
	}
	
	public void select()
	{
		setVisible(true);
		toFront();
		requestFocus();
		activate();
	}
	
	public int getID()
	{
		return ID;
	}
	
	public TermoPLDocument getDocument()
	{
		return doc;
	}
	
	public void close()
	{
		doc.close(this);
	}
	
	public void destroySelf()
	{
		setVisible(false);
		deactivate();
		dispose();
	}
	
	public void activate()
	{
		if (Commander.getCommander() != doc) Commander.setCommander(doc);
		TermoPL.changeZOrder(this);
		MenuFactory.resetWindowMenu(doc, this);
		MenuFactory.resetSelection(doc, this);
	}
	
	public void deactivate()
	{
		MenuFactory.resetWindowMenu(doc, this);
		MenuFactory.resetSelection(doc, this);
	}
	
	public void saveBounds()
	{
		Rectangle bounds = getBounds();
		Rectangle r = TermoPL.preferences.getBounds(ID);
		
		if (!bounds.equals(r)) {
			TermoPL.preferences.setBounds(ID, bounds);
			TermoPL.preferences.setModified(true);
		}
	}
	
}
