package termopl;

import java.util.LinkedList;

public class Tester 
{

	private LinkedList<Test> testList;
	
	public Tester()
	{
		testList = null;
	}
	
	public void add(Test test)
	{
		if (testList == null) testList = new LinkedList<Test>();
		testList.add(test);
	}
	
	public void add(Tester tester)
	{
		testList.addAll(tester.getTestList());
	}
	
	public boolean test(Token token, Tagset tagset)
	{
		if (testList == null) return true;
		for (Test test : testList) {
			if (!test.test(token, tagset)) return false;
		}
		return true;
	}
	
	public boolean test(MatchedFragment me, Tagset tagset)
	{
		if (testList == null) return true;
		for (Test test : testList) {
			if (!test.test(me, tagset)) return false;
		}
		return true;
	}
	
	public LinkedList<Test> getTestList()
	{
		return testList;
	}
	
	public boolean hasAnythingToDo()
	{
		return testList != null;
	}
	
	public String toString()
	{
		String str = "[";
		boolean append = false;
		
		if (testList != null) {
			for (Test t : testList) {
				if (append) str += "; ";
				else append = true;
				str += t.toString();
			}
		}
		str += "]";
		return str;
	}
	
}
