package termopl;

import java.io.Serializable;

@SuppressWarnings("serial")
public class Token implements Serializable
{

	public static final Token nullToken = new Token();
	
	public String form;
	public String lemma;
	public String ctag;
	public String[] tag;
	public char ner;
	public boolean spaceAfter;
	
	public Token()
	{
		this.form = null;
		this.lemma = null;
		this.ctag = null;
		tag = null;
		ner = 'O';
		spaceAfter = true;
	}
	
	public Token(String form, String lemma, String ctag)
	{
		this.form = form.trim();
		this.lemma = lemma.trim();
		this.ctag = ctag;
		tag = null;
		ner = 'O';
		spaceAfter = true;
	}
	
	public Token(String form, String lemma, String ctag, boolean spaceAfter)
	{
		this.form = form.trim();
		this.lemma = lemma.trim();
		this.ctag = ctag;
		tag = null;
		ner = 'O';
		this.spaceAfter = spaceAfter;
	}
	
	public String getPOS(Tagset tagset)
	{
		// for POS_TAG tagsets getTag is used
		
		if (ctag == null) return null;
		if (tag == null) tag = ctag.split(tagset.getDelimiter());
		return tag[0];
	}
	
	public String[] getTag(Tagset tagset)
	{
		if (ctag == null) return null;
		if (tag == null) tag = ctag.split(tagset.getDelimiter());
		return tag;
	}
	
	public boolean stop()
	{
		return (form == null && lemma == null && ctag == null);
	}
	
	public boolean skip()
	{
		return ctag == null;
	}

	public void markAsSkipToken()
	{
		ctag = null;
		tag = null;
	}
	
	public String toString()
	{
		return(form + " " + lemma + " " + ctag);
	}
	
}
