package termopl;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.*;
import java.net.URL;

import javax.swing.*;

@SuppressWarnings("serial")
public class About extends JPanel
{
	
	private static final String DESCRIPTION = 
			"<html><p>" +
			"TermoPL is a tool for extracting terminology from domain corpora.<br><br>" +
			"The program extracts phrases, candidates for terms, using Universal<br>" +
			"Dependency (UD) structures obtained from UD parsers or through a <br>" + 
			"simple grammar that can be customized. It applies the C-value method<br>" + 
			"to rank term candidates being either the longest identified acceptable<br>" + 
			"phrases or their nested subphrases.<br><br>" + 
			"The extraction method operates on simplified base forms in order to<br>" +
			"unify morhological variants of terms and to recognize their contexts.<br>" +
			"For Polish, the program has an option to convert simplified forms of<br>" +
			"phrases into correct phrases in the nominal case.<br><br>" +
			"TermoPL can be used to compare two lists of candidate terms using<br>" +
			"different coefficients to show the asymmetry in the occurrence of terms<br>" +
			"in the data. For Polish texts, TermoPL can group semantically related<br>" +
			"terms using plWordNet." +
			"</html></p>";
	
	private JDialog dialog;

	public About()
	{
		super();
		setBackground(new Color(255, 255, 225));
		setBorder(BorderFactory.createEmptyBorder(8, 16, 8, 16));
		arrangeComponents();
	}
	
	public void arrangeComponents()
	{
		Box vbox, hbox;
		JLabel label;
		JButton ok;
		URL url = ClassLoader.getSystemClassLoader().getResource("java.png");
		ImageIcon icon = new ImageIcon(url);
		Font font = new Font(Font.SANS_SERIF, Font.PLAIN, 11);
		
		vbox = Box.createVerticalBox();
		hbox = Box.createHorizontalBox();
		hbox.add(Box.createHorizontalGlue());
		label = new JLabel("TermoPL");
		label.setForeground(Color.red);
		label.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 16));
		hbox.add(label);
		hbox.add(Box.createHorizontalGlue());
		vbox.add(hbox);
		vbox.add(Box.createVerticalStrut(16));
		hbox = Box.createHorizontalBox();
		hbox.add(Box.createHorizontalGlue());
		label = new JLabel("Version 8.1.1");
		label.setFont(new Font(Font.SANS_SERIF, Font.BOLD, 12));
		hbox.add(label);
		hbox.add(Box.createHorizontalGlue());
		vbox.add(hbox);
		vbox.add(Box.createVerticalStrut(8));
		hbox = Box.createHorizontalBox();
		hbox.add(Box.createHorizontalGlue());
		label = new JLabel("Institute of Computer Science, Polish Academy of Sciences");
		label.setFont(font);
		hbox.add(label);
		hbox.add(Box.createHorizontalGlue());
		vbox.add(hbox);
		vbox.add(Box.createVerticalStrut(8));
		hbox = Box.createHorizontalBox();
		hbox.add(Box.createHorizontalGlue());
		label = new JLabel("Software co-funded by CLARIN-PL");
		label.setFont(font);
		hbox.add(label);
		hbox.add(Box.createHorizontalGlue());
		vbox.add(hbox);
		vbox.add(Box.createVerticalStrut(16));
		hbox = Box.createHorizontalBox();
		label = new JLabel(DESCRIPTION);
		label.setFont(new Font(Font.SERIF, Font.PLAIN, 14));
		hbox.add(label);
		vbox.add(hbox);
		vbox.add(Box.createVerticalStrut(16));
		hbox = Box.createHorizontalBox();
		label = new JLabel("Java version: " + System.getProperty("java.version"));
		label.setFont(font);
		label.setIcon(icon);
		hbox.add(label);
		hbox.add(Box.createHorizontalGlue());
		ok = new JButton("OK");
		ok.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) 
			{
				dialog.dispose();
			}
		});
		hbox.add(ok);
		vbox.add(hbox);
		add(vbox);
		
	}
	
	public void doDialog()
	{
		dialog = new JDialog(TermoPL.dialogOwner, true);
		dialog.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		dialog.setResizable(false);
		dialog.getContentPane().add(this);
		dialog.pack();
		dialog.setLocationRelativeTo(TermoPL.dialogOwner);
		dialog.setTitle("About TermoPL");
		dialog.setVisible(true);
	}
	
}
