package termopl;

import java.util.Collection;

public class Chain<E> 
{
	
	private E head;
	private Chain<E> tail;
	
	public Chain(E element)
	{
		head = element;
		tail = null;
	}
	
	public Chain(E element, Chain<E> tail)
	{
		head = element;
		this.tail = tail;
	}
	
	public Chain(Collection<E> collection)
	{
		boolean assignHead = true;
		Chain<E> ch = null;
		
		for (E elem : collection) {
			if (assignHead) {
				head = elem;
				assignHead = false;
			}
			else {
				if (ch == null) {
					tail = ch = new Chain<E>(elem);
				}
				else {
					ch.tail = new Chain<E>(elem);
					ch = ch.tail;
				}
			}
		}
	}

	public E head()
	{
		return head;
	}
	
	public Chain<E> tail()
	{
		return tail;
	}
	
	public void setHead(E element)
	{
		head = element;
	}
	
	public void setTail(Chain<E> tail)
	{
		this.tail = tail;
	}
	
	public int length()
	{
		int len = 0;
		Chain<E> t = this;
		
		while (t != null) {
			len++;
			t = t.tail();
		}
		return len;
	}
	
	public Chain<E> skip(int n)
	{
		Chain<E> t = this;
		
		while (n > 0 && t != null) {
			n--;
			t = t.tail();
		}
		return t;
	}
	
}
