package termopl;

import java.awt.*;
import java.util.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class FormsView extends JPanel
{

	private TermoPLDocument doc;
	private JScrollPane sp;
	private Content content;
	private InfoPanel infoPanel;
	private Term term;
	
	public FormsView(TermoPLDocument document)
	{
		doc = document;
		setLayout(new BorderLayout());
		arrangeComponents();
		
		EventQueue.invokeLater(new Runnable() {
			public void run()
			{
				TermsView tv = doc.getTermsView();
				
				if (tv != null) setData(tv.getSelectedTerm());
			}
		});
	}
	
	public void arrangeComponents()
	{
		content = new Content();
		infoPanel = new InfoPanel();
		sp = new JScrollPane(content);
		sp.getViewport().setBackground(CommonResources.LIGHT_GRAY);
		sp.setBorder(BorderFactory.createCompoundBorder(
			BorderFactory.createEmptyBorder(-1, -1, 0, -1),
			BorderFactory.createLineBorder(Color.lightGray)));
		add(sp, BorderLayout.CENTER);
		add(infoPanel, BorderLayout.SOUTH);
	}
	
	public void setData(Term term)
	{
		this.term = term;
		content.calcSize();
		content.invalidate();
		scrollRectToVisible(CommonResources.nullRect);
		repaint();
		if (term != null) {
			infoPanel.setInfo("Forms found: " + term.getForms().size());
		}
		else {
			infoPanel.setWarning("Term is not selected.");
		}
	}
	
	public void reset()
	{
		setData(null);
	}
	
	public void changeFontSize()
	{
		content.calcSize();
		invalidate();
		repaint();
	}
	
	private class Content extends JPanel
	{

		private int height;
		
		public Content()
		{
			super();
			setBackground(CommonResources.LIGHT_GRAY);
		}
		
		public void calcSize()
		{
			if (term == null) height = 0;
			else height = calcHeight(term.getForms());
			setPreferredSize(new Dimension(0, height));
		}
		
		public int calcHeight(LinkedList<Form> elements)
		{
			Graphics graphics = getGraphics();
			FontMetrics fm;
			int x = 4, w = getWidth() - 4, height = 0;
			
			graphics.setFont(TermoPL.preferences.plainFont);
			fm = graphics.getFontMetrics();
			if (elements == null) height += fm.getHeight();
			else {
				String c = ",";
				int sp = fm.stringWidth(" ");
				Form last = elements.getLast();
				
				for (Form form : elements) {
					String str = form.toString();
					
					String[] strings = str.split(" ");
					
					if (form == last) c = "";
					for (String s : strings) {
						int sw;
						
						if (s == strings[strings.length - 1]) s += c;
						sw = fm.stringWidth(s);
						if (x + sw > w) {
							x = 4;
							height += fm.getHeight();
						}
						x += sw;
						if (x + sp > w) {
							x = 4;
							height += fm.getHeight();
						}
						else x += sp;
					}
				}
				height += fm.getHeight() + 2;
			}
			return height;
		}
		
		public void paintComponent(Graphics graphics)
		{
			super.paintComponent(graphics);
			
			Graphics2D g = (Graphics2D)graphics;
			
			g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
			if (term != null) {
				paintElements(graphics, term.getForms(), "Forms:");
			}
		}
		
		public void paintElements(Graphics graphics, LinkedList<Form> elements, String header)
		{
			FontMetrics fm;
			int x = 4, y = 0, w = getWidth() - 4;
			
			graphics.setColor(Color.black);
			graphics.setFont(TermoPL.preferences.plainFont);
			fm = graphics.getFontMetrics();
			if (elements == null) {
				graphics.drawString("none", x, y + fm.getAscent());
			}
			else {
				String c = ",";
				int sp = fm.stringWidth(" ");
				Form last = elements.getLast();
				
				for (Form form : elements) {
					String str = form.toString();
					String o = form.occurences();
					
					String[] strings = str.split(" ");
					
					if (form == last) c = "";
					for (String s : strings) {
						int sw;
						
						if (s == strings[strings.length - 1]) s += o + c;
						sw = fm.stringWidth(s);
						if (x + sw > w) {
							x = 4;
							y += fm.getHeight();
						}
						graphics.drawString(s, x, y + fm.getAscent());
						x += sw;
						if (x + sp > w) {
							x = 4;
							y += fm.getHeight();
						}
						else x += sp;
					}
				}
			}
		}
		
	}
	
}
