package termopl;

import java.io.Serializable;

@SuppressWarnings("serial")
public class MatchedToken implements MatchedElement, Cloneable, Serializable
{
	
	public transient MatchedFragment parent;
	public boolean computeBaseForm;
	public boolean head;
	public Token token;
	
	public MatchedToken(Token token)
	{
		this.computeBaseForm = false;
		this.head = false;
		this.token = token;
	}
	
	public MatchedToken(boolean computeBaseForm, boolean head, Token token)
	{
		this.computeBaseForm = computeBaseForm;
		this.head = head;
		this.token = token;
	}
	
	public void setComputeBaseForm(boolean f)
	{
		computeBaseForm = f;
	}
	
	public void setHead(boolean f)
	{
		head = f;
	}
	
	public boolean computeBaseForm()
	{
		return computeBaseForm;
	}
	
	public boolean head()
	{
		return head;
	}
	
	public void setParent(MatchedFragment parent)
	{
		this.parent = parent;
	}
	
	public int length()
	{
		return 1;
	}

}
