package termopl;

import java.util.LinkedList;

@SuppressWarnings("serial")
public class MultiWordToken extends Token
{
	
	private LinkedList<UDToken> tokens;
	private int stoken;
	private int etoken;
	
	public MultiWordToken(String form, boolean spaceAfter, int s, int e)
	{
		super(form, form, null, spaceAfter);
		tokens = new LinkedList<UDToken>();
		stoken = s;
		etoken = e;
	}
	
	public void addToken(UDToken t)
	{
		tokens.add(t);
	}
	
	public LinkedList<UDToken> getTokens()
	{
		return tokens;
	}
	
	public int startToken()
	{
		return stoken;
	}
	
	public int endToken()
	{
		return etoken;
	}
	
	public void setStartAndEnd(int s, int e)
	{
		stoken = s;
		etoken = e;
	}
	
}
