package termopl;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

@SuppressWarnings("serial")
public class SaveFileChooser extends JFileChooser 
{

	public SaveFileChooser()
	{
		super();
	}
	
    @Override
    public void approveSelection()
    {
        File f = getSelectedFile();
        
        if (f.exists() && getDialogType() == SAVE_DIALOG) {
    		String msg = "File " + f.getName() + " already exists.\n" +
					 	 "Do you want to overwrite it?";
            int result = JOptionPane.showConfirmDialog(this,
            		                                   msg,
            		                                   "File exists",
            		                                   JOptionPane.YES_NO_CANCEL_OPTION,
            		                                   JOptionPane.WARNING_MESSAGE);
            
            switch (result) {
                case JOptionPane.YES_OPTION:
                    super.approveSelection();
                    return;
                case JOptionPane.NO_OPTION:
                    return;
                case JOptionPane.CLOSED_OPTION:
                    return;
                case JOptionPane.CANCEL_OPTION:
                    cancelSelection();
                    return;
            }
        }
        super.approveSelection();
    }        

}
