package termopl;

import java.util.*;

public class TermMatcher 
{

	private LinkedList<Token> tokens;
	private Chain<Token> tokPtr;
	private Template template;
	private Tagset tagset;
	private MatchedFragment matched;
	
	public TermMatcher(Template template, Tagset tagset)
	{
		tokens = null;
		tokPtr = null;
		if (template instanceof SimpleTemplate) this.template = new AndTemplate(template);
		else this.template = template;
		this.tagset = tagset;
	}
	
	public void setTokens(LinkedList<Token> tokens)
	{
		this.tokens = tokens;
		tokPtr = new Chain<Token>(tokens);
	}
	
	public void setMatchedTokens(LinkedList<MatchedToken> mtokens)
	{
		tokens = new LinkedList<Token>();
		for (MatchedToken mt : mtokens) tokens.add(mt.token);
		tokPtr = new Chain<Token>(tokens);
	}
	
	public void setTemplate(Template template)
	{
		if (template instanceof SimpleTemplate) this.template = new AndTemplate(template);
		else this.template = template;
		tokPtr = new Chain<Token>(tokens);
	}
	
	public boolean find()
	{
		while (tokPtr != null) {
			TestedFragment tf = new TestedFragment();
			Chain<TestedFragment> fragments = new Chain<TestedFragment>(tf);
			
			matched = new MatchedFragment(template.computeBaseForm, template);
			tf.template = template;
			tf.handle = matched.getHandle();
			if (lookingAt(fragments, tokPtr, new SetOfMarkedTemplates())) {
				if (matched.length() > 0) {
					tokPtr = tokPtr.skip(matched.length());
					return true;
				}
			}
			tokPtr = tokPtr.tail();
		}
		matched = null;
		return false;
	}
	
	public boolean match()
	{
		TestedFragment tf = new TestedFragment();
		Chain<TestedFragment> fragments = new Chain<TestedFragment>(tf);
		int len = tokPtr.length();
		
		matched = new MatchedFragment(template.computeBaseForm, template);
		tf.template = template;
		tf.handle = matched.getHandle();
		if (lookingAt(fragments, tokPtr, new SetOfMarkedTemplates())) {
			if (matched.length() == len) return true;
		}
		matched = null;
		return false;
	}
	
/*	public void printTemplate(Template t)
	{
		System.out.print("(");
		if (t instanceof SimpleTemplate) {
			String s = (String)t.tester.getTestList().getFirst().args[0];
			System.out.print(s.toUpperCase());
		}
		else if (t instanceof OrTemplate) System.out.print("OR");
		else System.out.print("AND");
		if (t.quantifier == Template.ZERO_OR_ONE) System.out.print("?");
		else if (t.quantifier == Template.ZERO_OR_MORE) System.out.print("*");
		else if (t.quantifier == Template.ONE_OR_MORE) System.out.print("+");
		
		if (t instanceof CompoundTemplate) {
			boolean appendSpace = false;
			for (Template tmp : t.getElements()) {
				if (appendSpace) System.out.print(" ");
				else appendSpace = true;
				printTemplate(tmp);
			}
		}
		System.out.print(")");
	}
	
	public void trace1(Chain<TestedFragment> fragments)
	{
		Chain<TestedFragment> list = fragments;
		System.out.print("FRAGMENTS:");
		
		while (list != null) {
			TestedFragment f = list.head();
			Template t = f.getTemplate();
			
			list = list.tail();
			System.out.println();
			System.out.print("[");
			printTemplate(t);
			System.out.print("   ---   " + f.getMatchedFragment().toString());
			System.out.print("]");
		}
		System.out.println();
	}
	
	public void trace2(Chain<Token> tokens)
	{
		Chain<Token> list = tokens;
		System.out.print("TOKENS:");
		while (list != null) {
			Token h = list.head();
			
			list = list.tail();
			System.out.print(" ");
			System.out.print(h.form);
		}
		System.out.println();
	}
	
	public void trace3(SetOfMarkedTemplates smt)
	{
		System.out.print("MARKED TEMPLATES: ");
		if (smt.markedTemplates.isEmpty()) System.out.print("Empty");
		else {
			for (MarkedTemplate mt : smt.markedTemplates) {
				System.out.println();
				System.out.print("[");
				System.out.print("TOK: ");
				if (mt.token == null) System.out.print("-");
				else System.out.print(mt.token.form);
				System.out.print(" TMP: ");
				if (mt.template == null) System.out.print("-");
				else printTemplate(mt.template);
				System.out.print("]");
			}
		}
		System.out.println();
	}*/
	
	public boolean lookingAt(Chain<TestedFragment> fragments, Chain<Token> tokens, SetOfMarkedTemplates smt)
	{
		if (fragments == null) return true;
		
		TestedFragment tf = fragments.head();
		Template temp = tf.getTemplate();
		Token t = (tokens == null ? null : tokens.head());
		
		if (smt.contains(temp,  t)) return lookingAt(fragments.tail(), tokens, smt);
		if (temp.quantifier == Template.NO_QUANTIFIER) {
			if (temp instanceof SimpleTemplate) {
				SimpleTemplate st = (SimpleTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				
				if (t != null && !t.skip() && st.test(t, tagset)) {
					MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
					matched.add(mt);
					if (matched.testSelf(tagset)) {
						if (lookingAt(fragments.tail(), tokens.tail(), smt)) return true;
					}
					matched.remove();
				}
				return false;
			}
			else if (temp instanceof OrTemplate) {
				OrTemplate ot = (OrTemplate)temp;
				LinkedList<LinkedList<MatchedElement>> mfList = null;
				for (Template tp : ot.getElements()) {
					MatchedFragment matched = tf.getMatchedFragment();
					MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
					TestedFragment newTF = new TestedFragment();
					Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments.tail());
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					matched.add(newMF);
					if (lookingAt(newFragments, tokens, smt)) {
						LinkedList<MatchedElement> lst = matched.remove(newMF);
						
						if (mfList == null) mfList = new LinkedList<LinkedList<MatchedElement>>();
						mfList.add(lst);
					}
					else matched.remove();
				}
				if (mfList == null)	return false;
				else {
					LinkedList<MatchedElement> lst = null;
					int maxLen = 0;
					for (LinkedList<MatchedElement> e : mfList) {
						int len = length(e);
						
						if (lst == null) {
							lst = e;
							maxLen = len;
						}
						else if (maxLen < len) {
							lst = e;
							maxLen = len;
						}
					}
					tf.getMatchedFragment().append(lst);
					return true;
				}
			}
			else {
				AndTemplate at = (AndTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
				Chain<TestedFragment> newFragments = null;
				Chain<TestedFragment> ptr = null;
				
				for (Template tp : at.getElements()) {
					TestedFragment newTF = new TestedFragment();
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					if (newFragments == null) {
						newFragments = ptr = new Chain<TestedFragment>(newTF);
					}
					else {
						ptr.setTail(new Chain<TestedFragment>(newTF));
						ptr = ptr.tail();
					}
				}
				ptr.setTail(fragments.tail());
				matched.add(newMF);
				if (lookingAt(newFragments, tokens, smt)) return true;
				matched.remove();
				return false;
			}
		}
		else if (temp.quantifier == Template.ZERO_OR_ONE) { // ?
			if (temp instanceof SimpleTemplate) {
				SimpleTemplate st = (SimpleTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				
				if (t != null && !t.skip() && st.test(t, tagset)) {
					MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
					matched.add(mt);
					if (matched.testSelf(tagset)) {
						if (lookingAt(fragments.tail(), tokens.tail(), smt)) return true;
					}
					matched.remove();
				}
				if (lookingAt(fragments.tail(), tokens, smt)) return true;
				return false;
			}
			else if (temp instanceof OrTemplate) {
				OrTemplate ot = (OrTemplate)temp;
				LinkedList<LinkedList<MatchedElement>> mfList = null;
				
				for (Template tp : ot.getElements()) {
					MatchedFragment matched = tf.getMatchedFragment();
					MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
					TestedFragment newTF = new TestedFragment();
					Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments.tail());
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					matched.add(newMF);
					if (lookingAt(newFragments, tokens, smt)) {
						LinkedList<MatchedElement> lst = matched.remove(newMF);
						
						if (mfList == null) mfList = new LinkedList<LinkedList<MatchedElement>>();
						mfList.add(lst);
					}
					else matched.remove();
				}
				if (mfList == null)	{
					if (lookingAt(fragments.tail(), tokens, smt)) return true;
					return false;
				}
				else {
					LinkedList<MatchedElement> lst = null;
					int maxLen = 0;
					for (LinkedList<MatchedElement> e : mfList) {
						int len = length(e);
						
						if (lst == null) {
							lst = e;
							maxLen = len;
						}
						else if (maxLen < len) {
							lst = e;
							maxLen = len;
						}
					}
					tf.getMatchedFragment().append(lst);
					return true;
				}
			}
			else {
				AndTemplate at = (AndTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
				Chain<TestedFragment> newFragments = null;
				Chain<TestedFragment> ptr = null;
				
				for (Template tp : at.getElements()) {
					TestedFragment newTF = new TestedFragment();
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					if (newFragments == null) {
						newFragments = ptr = new Chain<TestedFragment>(newTF);
					}
					else {
						ptr.setTail(new Chain<TestedFragment>(newTF));
						ptr = ptr.tail();
					}
				}
				ptr.setTail(fragments.tail());
				matched.add(newMF);
				if (lookingAt(newFragments, tokens, smt)) return true;
				matched.remove();
				if (lookingAt(fragments.tail(), tokens, smt)) return true;
				return false;
			}
		}
		else if (temp.quantifier == Template.ZERO_OR_MORE) { // *
			if (temp instanceof SimpleTemplate) {
				SimpleTemplate st = (SimpleTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				
				if (t != null && !t.skip() && st.test(t, tagset)) {
					MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
					
					matched.add(mt);
					if (matched.testSelf(tagset)) {
						if (lookingAt(fragments, tokens.tail(), smt)) return true;
					}
					matched.remove();
				}
				if (lookingAt(fragments.tail(), tokens, smt)) return true;
				return false;
			}
			else if (temp instanceof OrTemplate) {
				OrTemplate ot = (OrTemplate)temp;
				LinkedList<LinkedList<MatchedElement>> mfList = null;
				
				for (Template tp : ot.getElements()) {
					MatchedFragment matched = tf.getMatchedFragment();
					MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
					TestedFragment newTF = new TestedFragment();
					Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments);
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					matched.add(newMF);
					if (lookingAt(newFragments, tokens, new SetOfMarkedTemplates(smt, temp, t))) {
						LinkedList<MatchedElement> lst = matched.remove(newMF);
						
						if (mfList == null) mfList = new LinkedList<LinkedList<MatchedElement>>();
						mfList.add(lst);
					}
					else matched.remove();
				}
				if (mfList == null)	{
					if (lookingAt(fragments.tail(), tokens, smt)) return true;
					return false;
				}
				else {
					LinkedList<MatchedElement> lst = null;
					int maxLen = 0;
					for (LinkedList<MatchedElement> e : mfList) {
						int len = length(e);
						
						if (lst == null) {
							lst = e;
							maxLen = len;
						}
						else if (maxLen < len) {
							lst = e;
							maxLen = len;
						}
					}
					tf.getMatchedFragment().append(lst);
					return true;
				}
			}
			else {
				AndTemplate at = (AndTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
				Chain<TestedFragment> newFragments = null;
				Chain<TestedFragment> ptr = null;
				
				for (Template tp : at.getElements()) {
					TestedFragment newTF = new TestedFragment();
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					if (newFragments == null) {
						newFragments = ptr = new Chain<TestedFragment>(newTF);
					}
					else {
						ptr.setTail(new Chain<TestedFragment>(newTF));
						ptr = ptr.tail();
					}
				}
				ptr.setTail(fragments);
				matched.add(newMF);
				if (lookingAt(newFragments, tokens, new SetOfMarkedTemplates(smt, temp, t))) return true;
				matched.remove();
				if (lookingAt(fragments.tail(), tokens, smt)) return true;
				return false;
			}
		}
		else { // +
			if (temp instanceof SimpleTemplate) {
				SimpleTemplate st = (SimpleTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				
				if (t != null && !t.skip() && st.test(t, tagset)) {
					MatchedToken mt = new MatchedToken(temp.computeBaseForm || matched.getTemplate().computeBaseForm, temp.head, t);
					
					matched.add(mt);
					if (matched.testSelf(tagset)) {
						temp.quantifier = Template.ZERO_OR_MORE;
						if (lookingAt(fragments, tokens.tail(), smt)) {
							temp.quantifier = Template.ONE_OR_MORE;
							return true;
						}
						temp.quantifier = Template.ONE_OR_MORE;
					}
					matched.remove();
				}
				return false;
			}
			else if (temp instanceof OrTemplate) {
				OrTemplate ot = (OrTemplate)temp;
				LinkedList<LinkedList<MatchedElement>> mfList = null;
				
				for (Template tp : ot.getElements()) {
					MatchedFragment matched = tf.getMatchedFragment();
					MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
					TestedFragment newTF = new TestedFragment();
					Chain<TestedFragment> newFragments = new Chain<TestedFragment>(newTF, fragments);
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					matched.add(newMF);
					temp.quantifier = Template.ZERO_OR_MORE;
					if (lookingAt(newFragments, tokens, smt)) {
						LinkedList<MatchedElement> lst = matched.remove(newMF);
						
						if (mfList == null) mfList = new LinkedList<LinkedList<MatchedElement>>();
						mfList.add(lst);
					}
					else matched.remove();
					temp.quantifier = Template.ONE_OR_MORE;
				}
				if (mfList == null)	return false;
				else {
					LinkedList<MatchedElement> lst = null;
					int maxLen = 0;
					for (LinkedList<MatchedElement> e : mfList) {
						int len = length(e);
						
						if (lst == null) {
							lst = e;
							maxLen = len;
						}
						else if (maxLen < len) {
							lst = e;
							maxLen = len;
						}
					}
					tf.getMatchedFragment().append(lst);
					return true;
				}
			}
			else {
				AndTemplate at = (AndTemplate)temp;
				MatchedFragment matched = tf.getMatchedFragment();
				MatchedFragment newMF = new MatchedFragment(temp.computeBaseForm || matched.computeBaseForm(), temp);
				Chain<TestedFragment> newFragments = null;
				Chain<TestedFragment> ptr = null;
				
				for (Template tp : at.getElements()) {
					TestedFragment newTF = new TestedFragment();
					
					newTF.template = tp;
					newTF.handle = newMF.getHandle();
					if (newFragments == null) {
						newFragments = ptr = new Chain<TestedFragment>(newTF);
					}
					else {
						ptr.setTail(new Chain<TestedFragment>(newTF));
						ptr = ptr.tail();
					}
				}
				ptr.setTail(fragments);
				matched.add(newMF);
				temp.quantifier = Template.ZERO_OR_MORE;
				if (lookingAt(newFragments, tokens, smt)) {
					temp.quantifier = Template.ONE_OR_MORE;
					return true;
				}
				temp.quantifier = Template.ONE_OR_MORE;
				matched.remove();
				return false;
			}
		}
	}
	
	public int length(LinkedList<MatchedElement> list)
	{
		int len = 0;
		
		for (MatchedElement e : list) {
			len += e.length();
		}
		return len;
	}
	
	public MatchedFragment getMatchedFragment()
	{
		return matched;
	}
	
	private class TestedFragment
	{
		
		private Template template;
		private MatchedFragment.Handle handle;
		
		public Template getTemplate()
		{
			return template;
		}
		
		public MatchedFragment getMatchedFragment()
		{
			return handle.getMatchedFragment();
		}
		
	}
	
	private class MarkedTemplate
	{
		
		public Template template;
		public Token token;
		
		public MarkedTemplate(Template template, Token token)
		{
			this.template = template;
			this.token = token;
		}
		
	}
	
	private class SetOfMarkedTemplates
	{
		
		public LinkedList<MarkedTemplate> markedTemplates;
		
		public SetOfMarkedTemplates()
		{
			markedTemplates = new LinkedList<MarkedTemplate>();
		}
		
		@SuppressWarnings("unchecked")
		public SetOfMarkedTemplates(SetOfMarkedTemplates smt, Template template, Token token)
		{
			markedTemplates = (LinkedList<MarkedTemplate>) smt.markedTemplates.clone();
			add(new MarkedTemplate(template, token));
		}
		
		public boolean contains(Template template, Token token)
		{
			for (MarkedTemplate mt : markedTemplates) {
				if (mt.template == template && mt.token == token) return true;
			}
			return false;
		}
		
		public void add(MarkedTemplate template)
		{
			markedTemplates.add(template);
		}
		
	}
	
}
