package termopl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;

public class Test 
{

	public static final int NOOP   = -1;
	public static final int EQ     =  1;
	public static final int NEQ    =  2;
	public static final int MATCH  =  3;
	public static final int NMATCH =  4;
	
	public Method method;
	public int op;
	public String[] args;
	
	public Object[] params;
	
	public Test()
	{
		op = NOOP;
		method = null;
		args = null;
		params = null;
	}
	
	public void setParams(Object[] params)
	{
		this.params = params;
	}
	
	public boolean test(Token token, Tagset tagset)
	{
		params[0] = token;
		try {
			if (op == NOOP) return (Boolean)method.invoke(null,  params);
			else return testToken(token, tagset, false);
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		return false;
	}
	
	public boolean test(MatchedElement me, Tagset tagset)
	{
		params[0] = me;
		try {
			if (op == NOOP) return (Boolean)method.invoke(null,  params);
			else {
				if (me instanceof Token) return testToken((Token)me, tagset, false);
				return testMatchedFragment((MatchedFragment)me, tagset);
			}
		}
		catch (Exception exception) {
			exception.printStackTrace();
		}
		return false;
	}
	
	public boolean testToken(Token token, Tagset tagset, boolean defaultValue) 
		throws IllegalAccessException, IllegalArgumentException, InvocationTargetException
	{
		String str;
		
		params[0] = token;
		str = (String)method.invoke(null, params);
		if (str == null) return defaultValue;
		switch (op) {
			case EQ :
				for (String s : args) {
					if (str.equals(s)) return true;
				}
				return false;
			case NEQ :
				for (String s : args) {
					if (str.equals(s)) return false;
				}
				return true;
			case MATCH :
				for (String s : args) {
					if (str.matches(s)) return true;
				}
				return false;
			case NMATCH :
				for (String s : args) {
					if (str.matches(s)) return false;
				}
				return true;
		}
		return false;
	}
	
	public boolean testMatchedFragment(MatchedFragment mf, Tagset tagset)
		throws IllegalAccessException, IllegalArgumentException, InvocationTargetException
	{
		LinkedList<MatchedToken> tokens = mf.getMatchedTokens();
		String arg = null;
		
		for (MatchedToken t : tokens) {
			String str;
			
			params[0] = t.token;
			str = (String)method.invoke(null, params);
			if (str != null) {
				switch (op) {
					case EQ :
						if (arg == null) {
							boolean found = false;
							
							for (String s : args) {
								if (str.equals(s)) {
									arg = s;
									found = true;
									break;
								};
							}
							if (found) break;
							return false;
						}
						else {
							if (!str.equals(arg)) return false;
						}
						break;
					case NEQ :
						for (String s : args) {
							if (str.equals(s)) return false;
						}
						break;
					case MATCH :
						if (arg == null) {
							boolean found = false;
							
							for (String s : args) {
								if (str.matches(s)) {
									arg = s;
									found = true;
									break;
								}
							}
							if (found) break;
							return false;
						}
						else {
							if (!str.matches(arg)) return false;
						}
						break;
					case NMATCH :
						for (String s : args) {
							if (str.matches(s)) return false;
						}
				}
			}
		}
		return true;
	}
	
	public String toString()
	{
		String str = "";
		boolean append = false;
		
		str += method.getName();
		switch (op) {
			case EQ : str += "="; break;
			case NEQ : str += "!="; break;
			case MATCH : str += "~"; break;
			case NMATCH : str += "!~";
		}
		if (args != null) {
			for (String s : args) {
				if (append) str += ",";
				else append = true;
				str += s;
			}
		}
		return str;
	}
}
