package termopl;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class Workspace extends JPanel 
{

	public static final int OK = 1;
	
	private String currentWorkspace;
	private JDialog dialog;
	private int answer;
	private JButton okButton;
	private JButton cancelButton;
	private JButton changeButton;
	private JTextArea workspace;
	
	public Workspace(String currentWorkspace)
	{
		super(new BorderLayout());
		this.currentWorkspace = currentWorkspace;
		setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
		arrangeComponents();
	}
	
	public void arrangeComponents()
	{
		Dimension dim;
		Box hbox = Box.createHorizontalBox();
		
		hbox.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
		hbox.add(new JLabel("Selected Workspace:"));
		hbox.add(Box.createHorizontalGlue());
		add(hbox, BorderLayout.NORTH);
		workspace = new JTextArea();
		workspace.setFont(CommonResources.ttFont);
		workspace.setEditable(false);  
		workspace.setCursor(null);  
		workspace.setOpaque(false);  
		workspace.setFocusable(false);
		workspace.setLineWrap(true);
		workspace.setWrapStyleWord(true);
		workspace.setPreferredSize(new Dimension(400, 120));
		workspace.setText(currentWorkspace);
		add(workspace, BorderLayout.CENTER);
		okButton = new JButton("OK");
		cancelButton = new JButton("Cancel");
		changeButton = new JButton("Change");
		dim = changeButton.getPreferredSize();
		okButton.setPreferredSize(dim);
		cancelButton.setPreferredSize(dim);
		hbox = Box.createHorizontalBox();
		hbox.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
		hbox.add(Box.createHorizontalGlue());
		hbox.add(changeButton);
		hbox.add(Box.createHorizontalStrut(8));
		hbox.add(cancelButton);
		hbox.add(Box.createHorizontalStrut(8));
		hbox.add(okButton);
		add(hbox, BorderLayout.SOUTH);
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) 
			{
				answer = OK;
				dialog.setVisible(false);
			}
		});
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) 
			{
				dialog.setVisible(false);
			}
		});
		changeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) 
			{
				JFileChooser chooser = new JFileChooser();
				File dir = new File(currentWorkspace);
				
				chooser.setDialogTitle("Select New Workspace");
				chooser.setMultiSelectionEnabled(false);
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setApproveButtonText("Select");
				chooser.setApproveButtonMnemonic('S');
				chooser.setCurrentDirectory(dir);
				if (chooser.showOpenDialog(TermoPL.dialogOwner) == JFileChooser.APPROVE_OPTION) {
					currentWorkspace = chooser.getSelectedFile().getPath();
					workspace.setText(currentWorkspace);
				}
			}
		});
	}
	
	public void dispose()
	{
		if (dialog != null) dialog.dispose();
	}
	
	public int doDialog()
	{
		answer = -1;
		dialog = new JDialog(TermoPL.dialogOwner);
		dialog.setModal(true);
		dialog.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		dialog.setTitle("Workspace");
		dialog.setResizable(true);
		dialog.getContentPane().add(this);
		dialog.getRootPane().setDefaultButton(okButton);
		dialog.pack();
		dialog.setLocationRelativeTo(TermoPL.dialogOwner);
		dialog.setVisible(true);
		return answer;
	}
	
	public String getCurrentWorkspace()
	{
		return currentWorkspace;
	}
	
}
