package termopl;

import java.io.*;
import java.util.LinkedList;
import java.util.regex.*;

public class BatchParameters 
{

	public static final String BADOPTION = "Bad option: ";
	public static final String[] SOPTIONS = {
		"#", "rank", "sf", "bf", "cvalue", "comp", "length", "freq_s", "freq_in", "context"
	};
	
	public String error;
	public String output;
	public String wrk;
	public String wdn;
	public String export;
	public String exportForms;
	public String exportSentences;
	public String exportGroups;
	public String config;
	public String comp;
	public String language;
	public String method;
	public String ignoreCase;
	public String tagset;
	public String grammar;
	public String python;
	public String det;
	public String sw;
	public String cp;
	public String ct;
	public String[] inputFiles;
	public String[] saveOptions;
	public byte mw;
	public byte sf;
	public byte nf;
	public byte indx;
	public byte frq;
	public byte srch;
	public byte cntx;
	public byte group;
	public byte cc;
	public int sort;
	public int tr;
	public int pf;
	public int freq;
	public int detRatio;
	public double cval;
	public boolean ok;
	
	public BatchParameters(String[] args)
	{
		ok = true;
		mw = -1;
		sf = -1;
		nf = -1;
		indx = -1;
		frq = -1;
		srch = -1;
		cntx = -1;
		group = -1;
		cc = -1;
		sort = -1;
		tr = -1;
		pf = -1;
		freq = -1;
		detRatio = -1; 
		cval = -1;
		error = null;
		output = null;
		wrk = null;
		wdn = null;
		export = null;
		exportForms = null;
		exportSentences = null;
		exportGroups = null;
		config = null;
		comp = null;
		language = null;
		method = null;
		ignoreCase = null;
		det = null;
		tagset = null;
		grammar = null;
		python = null;
		sw = null;
		cp = null;
		ct = null;
		inputFiles = null;
		saveOptions = null;
		init(args);
	}
	
	private void init(String[] args)
	{
		int i = 0, j = 0;
		boolean readFiles = false;
		File file;
		
		while (ok && i < args.length) {
			String str = args[i];
			
			if (readFiles) {
				inputFiles[j++] = str; i++;
			}
			else if (str.startsWith("-")) {
				if (str.equals("-out")) {
					output = args[++i]; i++;
				}
				else if (str.equals("-wrk")) {
					wrk = args[++i]; i++;
				}
				else if (str.equals("-wdn")) {
					wdn = args[++i]; i++;
				}
				else if (str.equals("-exp")) {
					export = args[++i]; i++;
				}
				else if (str.equals("-expf")) {
					exportForms = args[++i]; i++;
				}
				else if (str.equals("-exps")) {
					exportSentences = args[++i]; i++;
				}
				else if (str.equals("-expg")) {
					exportGroups = args[++i]; i++;
				}
				else if (str.equals("-conf")) {
					config = args[++i]; i++;
				}
				else if (str.equals("-comp")) {
					comp = args[++i]; i++;
				}
				else if (str.equals("-sw")) {
					sw = args[++i]; i++;
				}
				else if (str.equals("-SW")) {
					sw = TermoPL.appLocation + File.separator + "termopl_sw.txt";
					i++;
				}
				else if (str.equals("-cp")) {
					cp = args[++i]; i++;
				}
				else if (str.equals("-CP")) {
					cp = TermoPL.appLocation + File.separator + "termopl_cp.txt";
					i++;
				}
				else if (str.equals("-ct")) {
					ct = args[++i]; i++;
				}
				else if (str.equals("-CT")) {
					ct = TermoPL.appLocation + File.separator + "termopl_ct.txt";
					i++;
				}
				else if (str.equals("-lang")) {
					language = args[++i]; i++;
				}
				else if (str.equals("-method")) {
					method = args[++i]; i++;
				}
				else if (str.equals("-ignc")) {
					ignoreCase = args[++i]; i++;
				}
				else if (str.equals("-det")) {
					det = args[++i]; i++;
				}
				else if (str.equals("-tagset")) {
					tagset = args[++i]; i++;
				}
				else if (str.equals("-grammar")) {
					grammar = args[++i]; i++;
				}
				else if (str.equals("-python")) {
					python = args[++i]; i++;
				}
				else if (str.equals("-mw")) {
					i++;
					mw = 1;
				}
				else if (str.equals("-sf")) {
					i++;
					sf = 1;
				}
				else if (str.equals("-nf")) {
					i++;
					nf = 1;
				}
				else if (str.equals("-indx")) {
					i++;
					indx = 1;
				}
				else if (str.equals("-group")) {
					i++;
					group = 1;
				}
				else if (str.equals("-srch")) {
					str = args[++i].toLowerCase(); i++;
					if (str.equals("npmi1")) srch = 1;
					else if (str.equals("npmi2")) srch = 2;
					else if (str.equals("npmi3")) srch = 3;
					else if (str.equals("nonpmi1")) srch = 4;
					else if (str.equals("nonpmi2")) srch = 5;
					else {
						error = BADOPTION + "-srch " + str;
						ok = false;
					}
				}
				else if (str.equals("-cntx")) {
					str = args[++i]; i++;
					if (str.equals("1")) cntx = 1;
					else if (str.equals("2")) cntx = 2;
					else if (str.equals("3")) cntx = 3;
					else {
						error = BADOPTION + "-cntx " + str;
						ok = false;
					}
				}
				else if (str.equals("-SORT") || str.equals("-sort")) {
					String cmd = str;
					boolean asc = (str.equals("-sort") ? true : false);
					
					str = args[++i].toLowerCase(); i++;
					if (str.equals("rank")) sort = TermoPLConsts.RANK;
					else if (str.equals("term")) sort = TermoPLConsts.TERM;
					else if (str.equals("cvalue")) sort = TermoPLConsts.CVALUE;
					else if (str.equals("comp")) sort = TermoPLConsts.CSVALUE;
					else if (str.equals("length")) sort = TermoPLConsts.LENGTH;
					else if (str.equals("freq_s")) sort = TermoPLConsts.FREQS;
					else if (str.equals("freq_in")) sort = TermoPLConsts.FREQIN;
					else if (str.equals("context")) sort = TermoPLConsts.CONTEXT;
					else {
						error = BADOPTION + cmd + " " + str;
						ok = false;
					}
					if (ok) {
						if (asc) sort += 8;
					}
				}
				else if (str.equals("-tr")) {
					str = args[++i]; i++;
					try {
						tr = Integer.parseInt(str);
					}
					catch (NumberFormatException e) {
						error = BADOPTION + "-tr " + str;
						ok = false;
					}
				}
				else if (str.equals("-pf")) {
					str = args[++i]; i++;
					try {
						pf = Integer.parseInt(str);
					}
					catch (NumberFormatException e) {
						error = BADOPTION + "-pf " + str;
						ok = false;
					}
				}
				else if (str.equals("-cc")) {
					str = args[++i].toLowerCase(); i++;
					if (str.equals("no")) cc = 0;
					else if (str.equals("ll")) cc = 1;
					else if (str.equals("tfitf")) cc = 2;
					else if (str.equals("csmw")) cc = 3;
					else if (str.equals("tw")) cc = 4;
					else {
						error = BADOPTION + "-cc " + str;
						ok = false;
					}
				}
				else if (str.equals("-frq")) {
					i++;
					frq = 1;
				}
				else if (str.equals("-freq")) {
					str = args[++i].toLowerCase(); i++;
					try {
						freq = Integer.parseInt(str);
					}
					catch (NumberFormatException e) {
						error = BADOPTION + "-freq " + str;
						ok = false;
					}
				}
				else if (str.equals("-detr")) {
					str = args[++i].toLowerCase(); i++;
					try {
						detRatio = Integer.parseInt(str);
					}
					catch (NumberFormatException e) {
						error = BADOPTION + "-freq " + str;
						ok = false;
					}
				}
				else if (str.equals("-cval")) {
					str = args[++i].toLowerCase(); i++;
					try {
						cval = Double.parseDouble(str);
					}
					catch (NumberFormatException e) {
						error = BADOPTION + "-cval " + str;
						ok = false;
					}
				}
				else if (str.equals("-save")) {
					str = args[++i].toLowerCase().trim(); i++;
					saveOptions = str.split(" ");
					checkSaveOptions();
				}
				else {
					error = BADOPTION + str;
					ok = false;
				}
			}
			else {
				readFiles = true;
				inputFiles = new String[args.length - i];
				inputFiles[j++] = str;
				i++;
			}
		}
		if (ok) {
			if (config == null) {
				config = TermoPL.appLocation + File.separator + "termopl_conf.txt";
				file = new File(config);
				if (!file.exists()) config = null;
			}
			else {
				config = Preferences.resolveFilePath(wrk, config);
				file = new File(config);
				if (!file.exists()) {
					error = "Configuration file \'" + config + "\' does not exist";
					ok = false;
					config = null;
				}
			}
			if (config != null) readConfig(config);
		}
		if (ok) {
			if (output == null && export == null && exportForms == null && exportSentences == null && exportGroups == null) {
				error = "No output is specified";
				ok = false;
			}
		}
		if (ok) {
			if (inputFiles != null) {
				for (i = 0; i < inputFiles.length; i++) {
					inputFiles[i] = Preferences.resolveFilePath(wrk, inputFiles[i]);
				}
			}
			if (output != null) {
				output = Preferences.resolveFilePath(wrk, output);
			}
			if (export != null) {
				export = Preferences.resolveFilePath(wrk, export);
			}
			if (exportForms != null) {
				exportForms = Preferences.resolveFilePath(wrk, exportForms);
			}
			if (exportSentences != null) {
				exportSentences = Preferences.resolveFilePath(wrk, exportSentences);
			}
			if (exportGroups != null) {
				exportGroups = Preferences.resolveFilePath(wrk, exportGroups);
			}
			if (comp != null) {
				comp = Preferences.resolveFilePath(wrk, comp);
			}
			if (sw != null) {
				sw = Preferences.resolveFilePath(wrk, sw);
			}
			if (cp != null) {
				cp = Preferences.resolveFilePath(wrk, cp);
			}
			if (ct != null) {
				ct = Preferences.resolveFilePath(wrk, ct);
			}
			if (tagset != null) {
				tagset = Preferences.resolveFilePath(wrk, tagset);
			}
			if (grammar != null) {
				grammar = Preferences.resolveFilePath(wrk, grammar);
			}
		}
	}
	
	public void readConfig(String config)
	{
		File file = new File(config);
		Pattern pat = Pattern.compile("(-[A-Za-z]+)\\s+(.*)");
		Matcher matcher;
		BufferedReader reader;
		LinkedList<String> batchInput = null;
		String line;
		byte xb;
		int xi;
		double xd;
		boolean initInputFiles = false, initOutput = false, initExport = false, 
				initExportForms = false, initExportSentences = false, initExportGroups = false, 
				initComp = false, initSW = false, initCP = false, initCT = false, 
				initTagset = false, initGrammar = false;
		
		
		try {
			reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF8"));
			do {
				line = reader.readLine();
				if (line != null) {
					line = line.trim();
					if (line.equals("-SW")) {
						if (sw == null) {
							initSW = true;
							sw = TermoPL.appLocation + File.separator + "termopl_sw.txt";
						}
					}
					else if (line.equals("-CP")) {
						if (cp == null) {
							initCP = true;
							cp = TermoPL.appLocation + File.separator + "termopl_cp.txt";
						}
					}
					else if (line.equals("-CT")) {
						if (ct == null) {
							initCT = true;
							ct = TermoPL.appLocation + File.separator + "termopl_ct.txt";
						}
					}
					else if (line.equals("-mw")) {
						mw = 1;
					}
					else if (line.equals("-sf")) {
						sf = 1;
					}
					else if (line.equals("-nf")) {
						nf = 1;
					}
					else if (line.equals("-frq")) {
						frq = 1;
					}
					else if (line.equals("-indx")) {
						indx = 1;
					}
					else if (line.equals("-group")) {
						group = 1;
					}
					else {
						matcher = pat.matcher(line);
						if (matcher.matches()) {
							String name = matcher.group(1);
							String arg = matcher.group(2);
							
							if (name.equals("-in")) {
								if (inputFiles == null) {
									if (!initInputFiles) {
										initInputFiles = true;
										batchInput = new LinkedList<String>();
									}
									batchInput.add(arg);
								}
							}
							else if (name.equals("-out")) {
								if (output == null) {
									initOutput = true;
									output = arg;
								}
							}
							else if (name.equals("-wrk")) {
								if (wrk == null) wrk = arg;
							}
							else if (name.equals("-wdn")) {
								if (wdn == null) wdn = arg;
							}
							else if (name.equals("-exp")) {
								if (export == null) {
									initExport = true;
									export = arg;
								}
							}
							else if (name.equals("-expf")) {
								if (exportForms == null) {
									initExportForms = true;
									exportForms = arg;
								}
							}
							else if (name.equals("-exps")) {
								if (exportSentences == null) {
									initExportSentences = true;
									exportSentences = arg;
								}
							}
							else if (name.equals("-expg")) {
								if (exportGroups == null) {
									initExportGroups = true;
									exportGroups = arg;
								}
							}
							else if (name.equals("-comp")) {
								if (comp == null) {
									initComp = true;
									comp = arg;
								}
							}
							else if (name.equals("-sw")) {
								if (sw == null) {
									initSW = true;
									sw = arg;
								}
							}
							else if (name.equals("-cp")) {
								if (cp == null) {
									initCP = true;
									cp = arg;
								}
							}
							else if (name.equals("-ct")) {
								if (ct == null) {
									initCT = true;
									ct = arg;
								}
							}
							else if (name.equals("-tagset")) {
								if (tagset == null) {
									initTagset = true;
									tagset = arg;
								}
							}
							else if (name.equals("-grammar")) {
								if (grammar == null) {
									initGrammar = true;
									grammar = arg;
								}
							}
							else if (name.equals("-python")) {
								if (python == null) python = arg;
							}
							else if (name.equals("-lang")) {
								language = arg.toLowerCase();
							}
							else if (name.equals("-method")) {
								method = arg.toLowerCase();
							}
							else if (name.equals("-ignc")) {
								ignoreCase = arg.toLowerCase();
							}
							else if (name.equals("-det")) {
								det = arg.toLowerCase();
							}
							else if (name.equals("-srch")) {
								arg = arg.toLowerCase();
								xb = -1;
								if (arg.equals("npmi1")) xb = 1;
								else if (arg.equals("npmi2")) xb = 2;
								else if (arg.equals("npmi3")) xb = 3;
								else if (arg.equals("nonpmi1")) xb = 4;
								else if (arg.equals("nonpmi2")) xb = 5;
								else {
									error = BADOPTION + line;
									ok = false;
								}
								if (srch == -1) srch = xb;
							}
							else if (name.equals("-cntx")) {
								arg = arg.toLowerCase();
								xb = -1;
								if (arg.equals("1")) xb = 1;
								else if (arg.equals("2")) xb = 2;
								else if (arg.equals("3")) xb = 3;
								else {
									error = BADOPTION + line;
									ok = false;
								}
								if (cntx == -1) cntx = xb;
							}
							else if (name.equals("-SORT") || name.equals("-sort")) {
								boolean asc = (name.equals("-sort") ? true : false);
								
								xi = -1;
								if (arg.equals("rank")) xi = TermoPLConsts.RANK;
								else if (arg.equals("term")) xi = TermoPLConsts.TERM;
								else if (arg.equals("cvalue")) xi = TermoPLConsts.CVALUE;
								else if (arg.equals("comp")) xi = TermoPLConsts.CSVALUE;
								else if (arg.equals("length")) xi = TermoPLConsts.LENGTH;
								else if (arg.equals("freq_s")) xi = TermoPLConsts.FREQS;
								else if (arg.equals("freq_in")) xi = TermoPLConsts.FREQIN;
								else if (arg.equals("context")) xi = TermoPLConsts.CONTEXT;
								else {
									error = BADOPTION + line;
									ok = false;
								}
								if (ok) {
									if (asc) xi += 8;
									if (sort == -1) sort = xi;
								}
							}
							else if (name.equals("-tr")) {
								xi = -1;
								try {
									xi = Integer.parseInt(arg);
								}
								catch (NumberFormatException e) {
									error = BADOPTION + line;
									ok = false;
								}
								if (tr == -1) tr = xi;
							}
							else if (name.equals("-pf")) {
								xi = -1;
								try {
									xi = Integer.parseInt(arg);
								}
								catch (NumberFormatException e) {
									error = BADOPTION + line;
									ok = false;
								}
								if (pf == -1) pf = xi;
							}
							else if (name.equals("-cc")) {
								xb = -1;
								arg = arg.toLowerCase();
								if (arg.equals("no")) cc = 0;
								else if (arg.equals("ll")) cc = 1;
								else if (arg.equals("tfitf")) cc = 2;
								else if (arg.equals("csmw")) cc = 3;
								else if (arg.equals("tw")) cc = 4;
								else {
									error = BADOPTION + line;
									ok = false;
								}
								if (cc == -1) cc = xb;
							}
							else if (name.equals("-freq")) {
								xi = -1;
								try {
									xi = Integer.parseInt(arg);
								}
								catch (NumberFormatException e) {
									error = BADOPTION + line;
									ok = false;
								}
								if (freq == -1) freq = xi;
							}
							else if (name.equals("-detr")) {
								xi = -1;
								try {
									xi = Integer.parseInt(arg);
								}
								catch (NumberFormatException e) {
									error = BADOPTION + line;
									ok = false;
								}
								if (detRatio == -1) detRatio = xi;
							}
							else if (name.equals("-cval")) {
								xd = -1;
								try {
									xd = Double.parseDouble(arg);
								}
								catch (NumberFormatException e) {
									error = BADOPTION + line;
									ok = false;
								}
								if (cval == -1) cval = xd;
							}
							else if (name.equals("-save")) {
								arg = arg.trim();
								saveOptions = arg.split(" ");
								checkSaveOptions();
							}
							else {
								error = "Unknown option: " + name;
								ok = false;
							}
						}
						else {
							error = "Bad configuration file: '" + line + "'";
							ok = false;
						}
					}
				}
			} while (ok && line != null);
			reader.close();
			if (ok) {
				if (initInputFiles) {
					inputFiles = batchInput.toArray(new String[0]);
					for (int i = 0; i < inputFiles.length; i++) {
						inputFiles[i] = Preferences.resolveFilePath(wrk, inputFiles[i]);
					}
				}
				if (initOutput) {
					output = Preferences.resolveFilePath(wrk, output);
				}
				if (initExport) {
					export = Preferences.resolveFilePath(wrk, export);
				}
				if (initExportForms) {
					exportForms = Preferences.resolveFilePath(wrk, exportForms);
				}
				if (initExportSentences) {
					exportSentences = Preferences.resolveFilePath(wrk, exportSentences);
				}
				if (initExportGroups) {
					exportGroups = Preferences.resolveFilePath(wrk, exportGroups);
				}
				if (initComp) {
					comp = Preferences.resolveFilePath(wrk, comp);
				}
				if (initSW) {
					sw = Preferences.resolveFilePath(wrk, sw);
				}
				if (initCP) {
					cp = Preferences.resolveFilePath(wrk, cp);
				}
				if (initCT) {
					ct = Preferences.resolveFilePath(wrk, ct);
				}
				if (initTagset) {
					tagset = Preferences.resolveFilePath(wrk, tagset);
				}
				if (initGrammar) {
					grammar = Preferences.resolveFilePath(wrk, grammar);
				}
			}
		} 
		catch (Exception e) {
			e.printStackTrace();
			ok = false;
		}
	}
	
	public void checkSaveOptions()
	{
		if (saveOptions == null || saveOptions.length == 0) {
			error = "Save options not specified";
			ok = false;
		}
		else {
			for (String so : saveOptions) {
				boolean found = false;
				
				for (String s : SOPTIONS) {
					if (s.equals(so)) {
						found = true;
						break;
					}
				}
				if (!found) {
					error = "Unknown save option: " + so;
					ok = false;
				}
			}
		}
	}
	
}
