package termopl;

import java.awt.event.*;
import java.net.*;
import javax.swing.*;

@SuppressWarnings("serial")
public class Command extends AbstractAction
{
	
	// Command IDs
	public static final int NEW_COMMAND 					= 1;
	public static final int OPEN_COMMAND 					= 2;
	public static final int MERGE_COMMAND					= 3;
	public static final int CLOSE_COMMAND 					= 4;
	public static final int SAVE_COMMAND 					= 5;
	public static final int SAVE_AS_COMMAND 				= 6;
	public static final int WORKSPACE_COMMAND				= 7;
	public static final int EXPORT_COMMAND					= 8;
	public static final int EXPORT_FORMS_COMMAND			= 9;
	public static final int EXPORT_SENTENCES_COMMAND		= 10;
	public static final int EXPORT_GROUPS_COMMAND			= 11;
	public static final int EXTRACT_COMMAND 				= 12;
	public static final int COMPARE_COMMAND 				= 13;
	public static final int SELECT_FILES_COMMAND 			= 14;
	public static final int SELECT_CONTRASTIVE_TERMS_COMMAD = 15;
	public static final int BASE_FORMS_COMMAND				= 16;
	public static final int COLLECT_COMMAND					= 17;
	public static final int INDEX_COMMAND					= 18;
	public static final int PREFERENCES_COMMAND				= 19;
	public static final int FORMS_COMMAND					= 20;
	public static final int SENTENCES_COMMAND				= 21;
	public static final int GROUPS_COMMAND					= 22;
	public static final int INCREASE_COMMAND				= 23;
	public static final int DECREASE_COMMAND				= 24;
	public static final int SHOW_ONE_ALL   					= 25;
	public static final int TILE_COMMAND					= 26;
	public static final int CASCADE_COMMAND					= 27;
	public static final int EXIT_COMMAND 					= 28;
	public static final int ABOUT_COMMAND   				= 29;
	public static final int HELP_COMMAND					= 30;
	
	public static Command newCommand;
	public static Command openCommand;
	public static Command mergeCommand;
	public static Command closeCommand;
	public static Command saveCommand;
	public static Command saveAsCommand;
	public static Command workspaceCommand;
	public static Command exportCommand;
	public static Command exportFormsCommand;
	public static Command exportSentencesCommand;
	public static Command exportGroupsCommand;
	public static Command extractCommand;
	public static Command compareCommand;
	public static Command selectFilesCommand;
	public static Command selectContrastiveTermsCommand;
	public static Command baseFormsCommand;
	public static Command collectCommand;
	public static Command indexCommand;
	public static Command preferencesCommand;
	public static Command formsCommand;
	public static Command sentencesCommand;
	public static Command groupsCommand;
	public static Command increaseCommand;
	public static Command decreaseCommand;
	public static Command showOneAll;
	public static Command tileCommand;
	public static Command cascadeCommand;
	public static Command exitCommand;
	public static Command aboutCommand;
	public static Command helpCommand;
	
	static {
		newCommand = new Command(NEW_COMMAND, "New");
		openCommand = new Command(OPEN_COMMAND, "Open...");
		mergeCommand = new Command(MERGE_COMMAND, "Merge...");
		closeCommand = new Command(CLOSE_COMMAND, "Close");
		saveCommand = new Command(SAVE_COMMAND, "Save");
		workspaceCommand = new Command(WORKSPACE_COMMAND, "Workspace...");
		saveAsCommand = new Command(SAVE_AS_COMMAND, "Save As...");
		exportCommand = new Command(EXPORT_COMMAND, "Export...");
		exportFormsCommand = new Command(EXPORT_FORMS_COMMAND, "Export Forms...");
		exportSentencesCommand = new Command(EXPORT_SENTENCES_COMMAND, "Export Sentences...");
		exportGroupsCommand = new Command(EXPORT_GROUPS_COMMAND, "Export Term Groups...");
		extractCommand = new Command(EXTRACT_COMMAND, "Extract");
		compareCommand = new Command(COMPARE_COMMAND, "Compare");
		selectFilesCommand = new Command(SELECT_FILES_COMMAND, "Select File(s)...");
		selectContrastiveTermsCommand = new Command(SELECT_CONTRASTIVE_TERMS_COMMAD, "Select Contrastive Set of Terms...");
		baseFormsCommand = new Command(BASE_FORMS_COMMAND, "Calculate Base Forms");
		collectCommand = new Command(COLLECT_COMMAND, "Collect All Analysed Forms of Terms");
		indexCommand = new Command(INDEX_COMMAND, "Index Sentences with Extracted Terms");
		preferencesCommand = new Command(PREFERENCES_COMMAND, "Preferences...");
		formsCommand = new Command(FORMS_COMMAND, "Forms of Selected Term");
		sentencesCommand = new Command(SENTENCES_COMMAND, "Sentences with Selected Term");
		groupsCommand = new Command(GROUPS_COMMAND, "Related Term Groups");
		increaseCommand = new Command(INCREASE_COMMAND, "Increase Font");
		decreaseCommand = new Command(DECREASE_COMMAND, "Decrease Font");
		showOneAll = new Command(SHOW_ONE_ALL, "");
		tileCommand = new Command(TILE_COMMAND, "Tile");
		cascadeCommand = new Command(CASCADE_COMMAND, "Cascade");
		exitCommand = new Command(EXIT_COMMAND, "Exit");	
		aboutCommand = new Command(ABOUT_COMMAND, "About TermoPL");
		helpCommand = new Command(HELP_COMMAND, "User Manual");
	}
	
	private int commandID;
	
	public Command(int commandID, String commandName)
	{
		super(commandName);
		this.commandID = commandID;
	}
	
	public Command(int commandID, String commandName, String iconFile)
	{
		super(commandName);
		setIcon(iconFile);
		this.commandID = commandID;
	}
	
	public Command(String commandName, String iconFile)
	{
		this(0, commandName, iconFile);
	}
	
	public void actionPerformed(ActionEvent event)
	{
		if (commandID != 0) {
			Commander commander = Commander.getCommander();
			
			if (commander != null) commander.executeCommand(commandID, event.getModifiers());
		}
	}
	
	public void setIcon(String iconFile)
	{
		URL url = Command.class.getResource("Images/" + iconFile); 
		putValue(SMALL_ICON, new ImageIcon(url));
	}
	
	public void setIcon(Icon icon)
	{
		putValue(SMALL_ICON, icon);
	}
	
	public int getCommandID()
	{
		return commandID;
	}
	
}
