package termopl;

import javax.swing.*;

public class Commander 
{
	
	private static Commander currentCommander = null;
	private Commander superCommander;
	
	public Commander()
	{
		superCommander = null;
	}
	
	public Commander(Commander superCommander)
	{
		setSuperCommander(superCommander);
	}
	
	public static void setCommander(Commander commander)
	{
		currentCommander = commander;
	}
	
	public static Commander getCommander()
	{
		return currentCommander;
	}
	
	public void setSuperCommander(Commander commander)
	{
		superCommander = commander;
	}
	
	public Commander getSuperCommander()
	{
		return superCommander;
	}
	
	public void executeCommand(int commandID, int modifiers)
	{
		if (superCommander != null) 
			superCommander.executeCommand(commandID, modifiers);
	}
	
	public void findMenuStatus(JMenu menu)
	{
		if (superCommander != null)
			superCommander.findMenuStatus(menu);
	}
	
	public void findCommandStatus(JMenuItem item)
	{
		if (superCommander != null)
			superCommander.findCommandStatus(item);
	}
	
	public void examineMenu(JMenu menu)
	{
		if (currentCommander != null) {
			int i, count = menu.getItemCount();
	  	
			currentCommander.findMenuStatus(menu);
		  	for (i = 0; i < count; i++) {
		  		JMenuItem item = menu.getItem(i);
		  		
		  		if (item != null) {
			  		if (item.getClass() == JMenu.class) {
						JMenu m = (JMenu)item;
						
			  			if (m.getItemCount() == 0) item.setEnabled(false);
			  			else {
							item.setEnabled(true);
							examineMenu(m);
						}
			  		}
			  		else {
			  			Action action = item.getAction();
			  			if (action != null && action.getClass() == Command.class) {
			  				currentCommander.findCommandStatus(item);
			  			}
			  		}
			  	}
		  	}
		}
	}

	 
}
