package termopl;

import java.io.*;
import java.util.*;
import pl.sgjp.morfeusz.*;

public class CommonTerm implements Serializable
{

	private static final long serialVersionUID = -3160688595209534380L;

	private static Morfeusz morfeusz = null;
	
	public String bf;
	public String sf;
	
	public CommonTerm()
	{
		bf = sf = "";
	}
	
	public CommonTerm(String bf, String sf)
	{
		this.bf = bf;
		this.sf = sf;
		if (sf.isEmpty()) this.sf = createSimplifiedForm(bf);
	}
	
	public int hashCode()
	{
		return bf.hashCode() + sf.hashCode();
	}
	
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (obj instanceof Term) {
			String s1 = ((CommonTerm)obj).bf;
			String s2 = ((CommonTerm)obj).sf;
			
			return s1.equals(bf) && s2.equals(sf);
		}
		return false;
	}

	public String createSimplifiedForm(String bf)
	{
		if (morfeusz == null) morfeusz = Morfeusz.createInstance(MorfeuszUsage.ANALYSE_ONLY);
		
		List<MorphInterpretation> interps = morfeusz.analyseAsList(bf);
		int n = -1;
		String sf = "";
		
		for (MorphInterpretation mi : interps) {
			if (mi.getStartNode() != n) {
				String lemma;
				int index;
				
				n = mi.getStartNode();
				if (!sf.isEmpty()) sf += " ";
				lemma = mi.getLemma();
				index = lemma.indexOf(":");
				if (index > 0) lemma = lemma.substring(0, index);
				sf += lemma;
			}
		}
		return sf;
	}
	
}
