package termopl;

import java.util.*;

public class CompoundTemplate extends Template 
{
	
	public LinkedList<Template> elements;
	
	public CompoundTemplate()
	{
		super();
		this.elements = new LinkedList<Template>();
	}
	
	public CompoundTemplate(boolean computeBaseForm)
	{
		super(computeBaseForm);
		this.elements = new LinkedList<Template>();
	}
	
	public CompoundTemplate(Template... elements) 
	{
		super();
		this.elements = new LinkedList<Template>();
		add(elements);
	}
	
	public CompoundTemplate(boolean computeBaseForm, Template... elements) 
	{
		super(computeBaseForm);
		this.elements = new LinkedList<Template>();
		add(elements);
	}
	
	public CompoundTemplate(int quantifier, Template... elements)
	{
		super(quantifier);
		this.elements = new LinkedList<Template>();
		add(elements);
	}
	
	public CompoundTemplate(int quantifier, boolean computeBaseForm, Template... elements)
	{
		super(quantifier, computeBaseForm);
		this.elements = new LinkedList<Template>();
		add(elements);
	}
	
	public void add(Template temp)
	{
		elements.add(temp);
	}
	
	public void add(Template[] elements)
	{
		for (Template t : elements) add(t);
	}
	
	public int size()
	{
		return elements.size();
	}
	
	public Template getFirst()
	{
		if (elements.size() > 0) return elements.getFirst();
		return null;
	}
	
	public LinkedList<Template> getElements()
	{
		return elements;
	}
	
}
