package termopl;

import java.awt.*;
import javax.swing.*;

public class ErrorViewer
{

	private JTextArea textArea;
	private JDialog dialog;
	
	public ErrorViewer(Object owner) 
	{
		if (owner instanceof Frame) dialog = new JDialog((Frame)owner, "Error", true);
		else dialog = new JDialog((Dialog)owner, "Error", true);
		dialog.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
		dialog.setResizable(true);
		dialog.setLayout(new BorderLayout());
		arrangeComponents();
		dialog.pack();
		if (owner instanceof Frame)	dialog.setLocationRelativeTo((Frame)owner);
		else dialog.setLocationRelativeTo((Dialog)owner);
	}
	
	public void arrangeComponents()
	{
		JScrollPane sp;
		
		textArea = new JTextArea();
		textArea.setFont(CommonResources.ttFont);
		textArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
		textArea.setEditable(false);
		sp = new JScrollPane(textArea);
		sp.setBorder(null);
		sp.setPreferredSize(new Dimension(600, 300));
		dialog.add(sp, BorderLayout.CENTER);
	}
	
	public void setVisible(boolean f)
	{
		dialog.setVisible(f);
	}
	
	public void showError(String str) 
	{
		textArea.append(str);
		textArea.append("\n");
	}
	
}
