package termopl;

import java.util.LinkedList;

public class Evaluator 
{
	
	public static boolean agreement(MatchedElement me, String category, Tagset tagset)
	{
		if (me instanceof MatchedToken) return true;
		
		MatchedFragment mf = (MatchedFragment)me;
		LinkedList<MatchedToken> tokens = mf.getMatchedTokens();
		String cat = null;
		
		for (MatchedToken mt : tokens) {
			Token t = mt.token;
			String catValue = tagset.getCategory(t, category);
			
			if (catValue != null) {
				if (cat == null) cat = catValue;
				else if (!cat.equals(catValue)) return false;
			}
		}
		return true;
	}
	
	public static String categoryValue(Token token, String category, Tagset tagset)
	{
		return tagset.getCategory(token, category);
	}
	
	public static String form_(Token token, Tagset tagset)
	{
		return token.form;
	}
	
	public static String lemma_(Token token, Tagset tagset)
	{
		return token.lemma;
	}
	
	public static String tag_(Token token, Tagset tagset)
	{
		return token.ctag;
	}
	
	public static String pos_(Token token, Tagset tagset)
	{
		return token.getPOS(tagset);
	}

}
