package termopl;

import java.net.URL;
import javax.swing.*;

@SuppressWarnings("serial")
public class InfoPanel extends JPanel
{
	
	ImageIcon infoIcon;
	ImageIcon warningIcon;
	JLabel message;
	JButton button;
	
	public InfoPanel()
	{
		super();
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
		
		URL url = ClassLoader.getSystemClassLoader().getResource("info.png");
		
		infoIcon = new ImageIcon(url);
		url = ClassLoader.getSystemClassLoader().getResource("warning.png");
		warningIcon = new ImageIcon(url);
		message = new JLabel();
		button = new JButton();
		button.setVisible(false);
		add(message);
		add(Box.createHorizontalStrut(16));
		add(Box.createHorizontalGlue());
		add(button);
		button.setActionCommand(null);
	}
	
	public void setInfo(String info)
	{
		setBackground(CommonResources.GRAY);
		message.setText(info);
		message.setIcon(infoIcon);
		setAccessory(null);
	}
	
	public void setWarning(String warning)
	{
		setBackground(CommonResources.PINK);
		message.setText(warning);
		message.setIcon(warningIcon);
	}
	
	public void setAccessory(AbstractAction action)
	{
		if (action != null) {
			button.setAction(action);
			button.setVisible(true);
		}
		else {
			button.setAction(null);
			button.setVisible(false);
		}
	}
	
}
