package termopl;

import java.util.LinkedList;

public class MatchedFragment implements MatchedElement, Cloneable
{

	private Handle handle;
	private MatchedFragment parent;
	private LinkedList<MatchedElement> matchedElements;
	private Template template;
	private SentenceRef sentenceRef;
	private int docID;
	public boolean computeBaseForm;
	
	public MatchedFragment(boolean computeBaseForm, Template template)
	{
		handle = new Handle(this);
		parent = null;
		matchedElements = new LinkedList<MatchedElement>();
		sentenceRef = null;
		docID = 0;
		this.computeBaseForm = computeBaseForm;
		this.template = template;
	}
	
	public Object clone()
	{
		try {
			MatchedFragment cloned = (MatchedFragment)super.clone();
			LinkedList<MatchedElement> list = new LinkedList<MatchedElement>();
			
			for (MatchedElement me : matchedElements) {
				if (me instanceof MatchedToken) {
					MatchedToken mt = (MatchedToken)me;
					
					mt.setParent(cloned);
					list.add(me);
				}
				else {
					MatchedFragment mf = (MatchedFragment)((MatchedFragment)me).clone();
					
					mf.setParent(cloned);
					list.add(mf);
				}
			}
			handle.setMatchedFragment(cloned);
			cloned.matchedElements = list;
			cloned.handle = handle;
			return cloned;
		}
		catch (CloneNotSupportedException exception) {
			return null;
		}
	}
	
	public Handle getHandle()
	{
		return handle;
	}
	
	public void setParent(MatchedFragment parent)
	{
		this.parent = parent;
	}
	
	public boolean testSelf(Tagset tagset) 
	{
		if (template.test(this, tagset)) {
			if (parent == null) return true;
			return parent.testSelf(tagset);
		}
		return false;
	}
	
	public Template getTemplate()
	{
		return template;
	}
	
	public boolean computeBaseForm()
	{
		return computeBaseForm;
	}
	
	public void setDocID(int docID)
	{
		this.docID = docID;
	}
	
	public int getDocID()
	{
		return docID;
	}
	
	public void setRef(SentenceRef sentenceRef)
	{
		this.sentenceRef = sentenceRef;
	}
	
	public SentenceRef getRef()
	{
		return sentenceRef;
	}
	
	public LinkedList<MatchedElement> getMatchedElements()
	{
		return matchedElements;
	}
	
	public void add(MatchedToken element)
	{
		element.setParent(this);
		matchedElements.add(element);
	}
	
	public void add(MatchedFragment element)
	{
		element.setParent(this);
		matchedElements.add(element);
	}
	
	public void append(LinkedList<MatchedElement> list)
	{
		for (MatchedElement element : list)	{
			element.setParent(this);
			matchedElements.add(element);
		}
	}
	
	public MatchedElement remove()
	{
		return matchedElements.removeLast();
	}
	
	public LinkedList<MatchedElement> remove(MatchedElement me)
	{
		LinkedList<MatchedElement> list = new LinkedList<MatchedElement>();
		MatchedElement element = null;
		
		while (element != me && !matchedElements.isEmpty()) {
			element = remove();
			list.addFirst(element);
		}
		return list;
	}
	
	public LinkedList<MatchedToken> getMatchedTokens()
	{
		LinkedList<MatchedToken> tokens = new LinkedList<MatchedToken>();
		
		for (MatchedElement e : matchedElements) {
			if (e instanceof MatchedToken) tokens.add((MatchedToken)e);
			else {
				MatchedFragment mf = (MatchedFragment)e;
				LinkedList<MatchedToken> list = mf.getMatchedTokens();
				
				if (mf.computeBaseForm) {
					for (MatchedToken t : list) t.computeBaseForm = true;
				}
				tokens.addAll(list);
			}
		}
		return tokens;
	}
	
	public LinkedList<Token> getTokens()
	{
		LinkedList<Token> tokens = new LinkedList<Token>();
		
		for (MatchedElement e : matchedElements) {
			if (e instanceof MatchedToken) tokens.add(((MatchedToken)e).token);
			else {
				MatchedFragment mf = (MatchedFragment)e;
				
				tokens.addAll(mf.getTokens());
			}
		}
		return tokens;
	}
	
	public int length()
	{
		return getTokens().size();
	}
	
	public String toString()
	{
		String str = "";
		LinkedList<MatchedToken> tokens = getMatchedTokens();
		boolean appendSpace = false;
		
		for (MatchedToken t : tokens) {
			if (appendSpace) str += " ";
			else appendSpace = true;
			str += t.token.form;
		}
		return str;
	}
	
	public class Handle
	{
		
		private MatchedFragment fragment;
		
		public Handle(MatchedFragment fragment)
		{
			this.fragment = fragment;
		}
		
		public void setMatchedFragment(MatchedFragment fragment)
		{
			this.fragment = fragment;
		}
		
		public MatchedFragment getMatchedFragment()
		{
			return fragment;
		}
		
	}
	
}
