package termopl;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.DecimalFormat;
import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;

@SuppressWarnings("serial")
public class Options extends JPanel 
{
	
	public static final int OK = 1;
	
	private static final String BUILT_IN = "built-in";
	private static final String INFO1 = "<html>Find all places where the phrase can be divided according to the grammar rules.</html>";
	private static final String INFO2 = "<html>Always divide the phrase at the weakest connection point indicated by the lowest NPMI value. " +
										"Continue this process for the resulting subphrases even if they do not conform to the grammar rules.</html>";
	private static final String INFO3 = "<html>Try to divide the phrase into subphrases so as to at least one of them safisfies the grammar rules. " +
										"Choose the weakest possible connection point according to NPMI value to do the split. Continue this process for " +
										"the resulting subphrases. If the phrase cannot be split in such a way, use Method 1.</html>";
	private static final String INFO4 = "<html>Try to divide the phrase into subphrases so as to at least one of them safisfies the grammar rules. " +
										"Prefer cases where both phrases obtained after splitting are accepted by the given grammar. " +
										"This preference is expressed by the 'Preference factor'. " +
										"Choose the weakest possible connection point according to NPMI value to do the split. Continue this process for " +
										"the resulting subphrases. If the phrase cannot be split in such a way, use Method 2.</html>";
	private static final String INFO5 = "<html>Take the maximum from the number of different left and right contexts of a term.</html>";
	private static final String INFO6 = "<html>Take the number of different contexts of a term. Do not discriminate between left and right contexts. </html>";
	private static final String INFO7 = "<html>Take the number of different pairs of left and right contexts of a term.</html>";
	private static final String INFO8 = "<html>Take the number of different left contexts.</html>";
	private static final String INFO9 = "<html>Generate subsequent phrases by trimming out the leftmost word.</html>";
	private static final String INF10 = "<html>det/noun is the ratio of the number of 'det' relations to the number of nouns in the analyzed texts, " +
										"expressed as a percentage.</html>";
	
	private Preferences prefs;
	private LinkedList<String> sw;
	private LinkedList<String> cp;
	private LinkedList<CommonTerm> ct;
	private String tagsetPath;
	private String grammarPath;
	private String pythonPath;
	private String wordNetPath;
	private String contrastiveDataPath;
	private String language;
	private File tagsetFile;
	private File grammarFile;
	private Tagset tagset;
	private Template template;
	private JDialog dialog;
	private JTabbedPane tabbedPane;
	private JTabbedPane innerTabbedPane;
	private StopWordsPanel stopWordsPanel;
	private CompPrepPanel compPrepPanel;
	private CommonTermsPanel commonTermsPanel;
	private GrammarPanel grammarPanel;
	private SearchPanel searchPanel;
	private ComparePanel comparePanel;
	private ExportPanel exportPanel;
	private JTable swTable;
	private JTable cpTable;
	private JTable ctTable;
	private JPanel gPanel;
	private JPanel tPanel;
	private LangCombo languageCombo;
	private JCheckBox applyContrastiveRanking;
	private JCheckBox topRankedOnly;
	private JCheckBox frequentOnly;
	private JCheckBox useCValues;
	private JCheckBox ignoreCase;
	private JCheckBox NPMI;
	private JCheckBox leftToRight;
	private JCheckBox makeGroups;
	private JCheckBox useWordNet;
	private JCheckBox checkSW;
	private JCheckBox removeCP;
	private JCheckBox removeCT;
	private JCheckBox mergeSW;
	private JCheckBox mergeCP;
	private JCheckBox mergeCT;
	private JCheckBox showSimplifiedForms;
	private JCheckBox countBox;
	private JCheckBox rankBox;
	private JCheckBox sfBox;
	private JCheckBox bfBox;
	private JCheckBox cvalueBox;
	private JCheckBox compBox;
	private JCheckBox lenBox;
	private JCheckBox freqsBox;
	private JCheckBox freqinBox;
	private JCheckBox contextBox;
	private JCheckBox detectDeterminers;
	private JRadioButton UDButton;
	private JRadioButton shallowGButton;
	private JRadioButton standardTagsetButton;
	private JRadioButton customTagsetButton;
	private JRadioButton standardGrammarButton;
	private JRadioButton customGrammarButton;
	private JRadioButton LLButton;
	private JRadioButton TFITFButton;
	private JRadioButton CSmwButton;
	private JRadioButton TWButton;
	private JRadioButton method1Button;
	private JRadioButton method2Button;
	private JRadioButton method3Button;
	private JRadioButton cntxMethod1Button;
	private JRadioButton cntxMethod2Button;
	private JRadioButton cntxMethod3Button;
	private JRadioButton includeDeterminers;
	private JRadioButton includeArticles;
	private JRadioButton excludeDeterminers;
	private JButton okButton;
	private JButton cancelButton;
	private JButton loadSWButton;
	private JButton saveSWButton;
	private JButton clearSWButton;
	private JButton loadCPButton;
	private JButton saveCPButton;
	private JButton clearCPButton;
	private JButton loadCTButton;
	private JButton saveCTButton;
	private JButton clearCTButton;
	private JButton changeTagset;
	private JButton changeGrammar;
	private JButton changePython;
	private JButton selectContrastiveData;
	private JButton selectAllButton;
	private JButton selectCCButton;
	private JButton changeWordNetButton;
	private JButton clearButton;
	private PictButton addSWButton;
	private PictButton removeSWButton;
	private PictButton addCPButton;
	private PictButton removeCPButton;
	private PictButton addCTButton;
	private PictButton removeCTButton;
	private JTextField mincvalue;
	private JTextField minfrq;
	private JTextField alpha;
	private JTextField beta;
	private JTextField factor;
	private JTextField detRatio;
	private JLabel tagsetNameLabel;
	private JLabel tagsetName;
	private JLabel grammarNameLabel;
	private JLabel grammarName;
	private JLabel python;
	private JLabel label1;
	private JLabel label2;
	private JLabel label3;
	private JLabel label4;
	private JLabel label5;
	private JLabel info1;
	private JLabel info2;
	private JLabel info3;
	private JLabel wordNetFile;
	private JLabel contrastiveDataLabel;
	private JLabel contrastiveDataName;
	private JLabel TWLabel;
	private JLabel DRLabel;
	private JLabel DCLabel;
	private Component sepBox;
	private int answer;
	
	@SuppressWarnings("unchecked")
	public Options(Preferences prefs)
	{
		super(new BorderLayout());
		setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
		this.prefs = prefs;
		sw = prefs.stopWords;
		if (sw != null) sw = (LinkedList<String>)sw.clone();
		cp = prefs.compPreps;
		if (cp != null) cp = (LinkedList<String>)cp.clone();
		ct = prefs.commonTerms;
		if (ct != null) ct = (LinkedList<CommonTerm>)ct.clone();
		contrastiveDataPath = prefs.contrastiveDataPath;
		tagsetPath = prefs.tagsetPath;
		grammarPath = prefs.grammarPath;
		wordNetPath = prefs.wordNetPath;
		tagset = prefs.tagset;
		template = prefs.template;
		if (tagsetPath == null) tagsetFile = null;
		else tagsetFile = new File(tagsetPath);
		if (grammarPath == null) grammarFile = null;
		else grammarFile = new File(grammarPath);
		language = prefs.language;
		arrangeComponents();
	}

	public void arrangeComponents()
	{
		Box hbox = Box.createHorizontalBox();
		Dimension dim;
		
		hbox.setBorder(BorderFactory.createEmptyBorder(8,0,0,0));
		tabbedPane = new JTabbedPane();
		innerTabbedPane = new JTabbedPane();
		tabbedPane.setFocusable(false);
		innerTabbedPane.setFocusable(false);
		
		stopWordsPanel = new StopWordsPanel();
		innerTabbedPane.addTab("Stop Words", stopWordsPanel);
		compPrepPanel = new CompPrepPanel();
		innerTabbedPane.addTab("Compound Prepositions", compPrepPanel);
		commonTermsPanel = new CommonTermsPanel();
		innerTabbedPane.addTab("Common Terms", commonTermsPanel);
		tabbedPane.addTab("Filters", innerTabbedPane);
		grammarPanel = new GrammarPanel();
		tabbedPane.addTab("Method", grammarPanel);
		searchPanel = new SearchPanel();
		tabbedPane.addTab("Search Parameters", searchPanel);
		comparePanel = new ComparePanel();
		tabbedPane.addTab("Compare", comparePanel);
		exportPanel = new ExportPanel();
		tabbedPane.addTab("Export", exportPanel);
		add(tabbedPane, BorderLayout.CENTER);
		hbox.add(Box.createHorizontalGlue());
		cancelButton = new JButton("Cancel");
		hbox.add(cancelButton);
		hbox.add(Box.createHorizontalStrut(16));
		okButton = new JButton("OK");
		hbox.add(okButton);
		dim = cancelButton.getPreferredSize();
		okButton.setPreferredSize(dim);
		add(hbox, BorderLayout.SOUTH);
		okButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) 
			{
				boolean ok;
				
				if (swTable.isEditing()) ok = swTable.getCellEditor().stopCellEditing();
				else if (cpTable.isEditing()) ok = cpTable.getCellEditor().stopCellEditing();
				else if (ctTable.isEditing()) ok = ctTable.getCellEditor().stopCellEditing();
				else ok = true;
				if (ok) {
					
					answer = OK;
					savePreferences();
					dialog.setVisible(false);
				}
			}
		});
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) 
			{
				dialog.setVisible(false);
			}
		});
	}
	
	public void savePreferences()
	{
		Preferences tprefs = TermoPL.preferences;
		boolean f;
		int m;
		double x;
		String str;
		
		prefs.extract = prefs.compare = prefs.repaint = prefs.reloadContrastiveTerms = false;
		
		f = applyContrastiveRanking.isSelected();
		if (f != prefs.applyContrastiveRanking) {
			tprefs.applyContrastiveRanking = prefs.applyContrastiveRanking = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (f) prefs.compare = true;
		}
		f = topRankedOnly.isSelected();
		if (f != prefs.applyContrastiveRankingForTopRankedTerms) {
			tprefs.applyContrastiveRankingForTopRankedTerms = prefs.applyContrastiveRankingForTopRankedTerms = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.repaint = true;
		}
		f = frequentOnly.isSelected();
		if (f != prefs.applyContrastiveRankingForFrequentTerms) {
			tprefs.applyContrastiveRankingForFrequentTerms = prefs.applyContrastiveRankingForFrequentTerms = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.repaint = true;
		}
		f = useCValues.isSelected();
		if (f != prefs.useCValues) {
			tprefs.useCValues = prefs.useCValues = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.applyContrastiveRanking) prefs.compare = true;
		}
		f = ignoreCase.isSelected();
		if (f != prefs.ignoreCase) {
			tprefs.ignoreCase = prefs.ignoreCase = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = NPMI.isSelected();
		if (f != prefs.useNPMIMethod) {
			tprefs.useNPMIMethod = prefs.useNPMIMethod = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = leftToRight.isSelected();
		if (f != prefs.trimFromLeftToRight) {
			tprefs.trimFromLeftToRight = prefs.trimFromLeftToRight = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (!prefs.useNPMIMethod) prefs.extract = true;
		}
		if (includeDeterminers.isSelected()) m = 1;
		else if (includeArticles.isSelected()) m = 2;
		else m = 3;
		if (m != prefs.detHandling) {
			tprefs.detHandling = prefs.detHandling = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = detectDeterminers.isSelected();
		if (f != prefs.detectDeterminers) {
			tprefs.detectDeterminers = prefs.detectDeterminers = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.detHandling == 1) prefs.extract = true;
		}
		f = checkSW.isSelected();
		if (f != prefs.checkStopWords) {
			tprefs.checkStopWords = prefs.checkStopWords = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = mergeSW.isSelected();
		if (f != prefs.mergeSW) {
			tprefs.mergeSW = prefs.mergeSW = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = removeCP.isSelected();
		if (f != prefs.removeCompoundPreps) {
			tprefs.removeCompoundPreps = prefs.removeCompoundPreps = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = mergeCP.isSelected();
		if (f != prefs.mergeCP) {
			tprefs.mergeCP = prefs.mergeCP = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = removeCT.isSelected();
		if (f != prefs.removeCommonTerms) {
			tprefs.removeCommonTerms = prefs.removeCommonTerms = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = mergeCT.isSelected();
		if (f != prefs.mergeCT) {
			tprefs.mergeCT = prefs.mergeCT = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = showSimplifiedForms.isSelected();
		if (f != prefs.showSimplifiedForms) {
			tprefs.showSimplifiedForms = prefs.showSimplifiedForms = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		str = ((LanguageInfo)languageCombo.getSelectedItem()).getLanguageCode();
		if ((str == null && prefs.language != null) || (str != null && !str.equals(prefs.language))) {
			tprefs.language = prefs.language = str;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = UDButton.isSelected();
		if (f != prefs.useUD) {
			tprefs.useUD = prefs.useUD = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = customTagsetButton.isSelected();
		if (f != prefs.useCustomTagset) {
			tprefs.tagset = prefs.tagset = tagset;
			tprefs.template = prefs.template = template;
			tprefs.useCustomTagset = prefs.useCustomTagset = f;
			if (f) tprefs.calculateBaseForms = prefs.calculateBaseForms = false;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = customGrammarButton.isSelected();
		if (f != prefs.useCustomGrammar) {
			tprefs.tagset = prefs.tagset = tagset;
			tprefs.template = prefs.template = template;
			tprefs.useCustomGrammar = prefs.useCustomGrammar = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = makeGroups.isSelected();
		if (f != prefs.makeGroups) {
			tprefs.makeGroups = prefs.makeGroups = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (f) prefs.extract = true;
		}
		f = useWordNet.isSelected();
		if (f != prefs.useWordNet) {
			tprefs.useWordNet = prefs.useWordNet = f;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.makeGroups) prefs.extract = true;
		}
		if (LLButton.isSelected()) m = 1;
		else if (TFITFButton.isSelected()) m = 2;
		else if (CSmwButton.isSelected()) m = 3;
		else m = 4;
		if (m != prefs.contrastiveRankingMethod) {
			tprefs.contrastiveRankingMethod = prefs.contrastiveRankingMethod = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.compare = true;
		}
		if (method1Button.isSelected()) m = 1;
		else if (method2Button.isSelected()) m = 2;
		else m = 3;
		if (m != prefs.NPMIMethod) {
			tprefs.NPMIMethod = prefs.NPMIMethod = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.useNPMIMethod) prefs.extract = true;
		}
		if (cntxMethod1Button.isSelected()) m = 1;
		else if (cntxMethod2Button.isSelected()) m = 2;
		else m = 3;
		if (m != prefs.cntxMethod) {
			tprefs.cntxMethod = prefs.cntxMethod = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.recalculate = true;
		}
		f = compareLists(prefs.stopWords, sw);
		if (!f) {
			tprefs.stopWords = prefs.stopWords = sw;
			tprefs.stopWordSet = prefs.stopWordSet = null;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		f = compareLists(prefs.compPreps, cp);
		if (!f) {
			tprefs.compPreps = prefs.compPreps = cp;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (cp != null) {
				PParser parser = new PParser(cp, dialog);
				
				parser.parse();
				tprefs.compoundPrepositions = prefs.compoundPrepositions = parser.getTemplate();
			}
			else tprefs.compoundPrepositions = prefs.compoundPrepositions = null;
		}
		f = compareLists(prefs.commonTerms, ct);
		if (!f) {
			tprefs.commonTerms = prefs.commonTerms = ct;
			tprefs.commonTermSet = prefs.commonTermSet = null;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.extract = true;
		}
		if (tagsetPath != null && !tagsetPath.equals(prefs.tagsetPath)) {
			tprefs.tagsetPath = prefs.tagsetPath = tagsetPath;
			tprefs.tagset = prefs.tagset = tagset;
			tprefs.template = prefs.template = template;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.useCustomTagset) prefs.extract = true;
		}
		if (grammarPath != null && !grammarPath.equals(prefs.grammarPath)) {
			tprefs.grammarPath = prefs.grammarPath = grammarPath;
			tprefs.tagset = prefs.tagset = tagset;
			tprefs.template = prefs.template = template;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.useCustomGrammar) prefs.extract = true;
		}
		if (pythonPath != null && !pythonPath.equals(prefs.pythonPath)) {
			tprefs.pythonPath = prefs.pythonPath = pythonPath;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		if (contrastiveDataPath != null && !contrastiveDataPath.equals(prefs.contrastiveDataPath)) {
			tprefs.contrastiveDataPath = prefs.contrastiveDataPath = contrastiveDataPath;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.applyContrastiveRanking) prefs.compare = true;
		}
		if (wordNetPath != null && !wordNetPath.equals(prefs.wordNetPath)) {
			tprefs.wordNetPath = prefs.wordNetPath = wordNetPath;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.makeGroups && prefs.useWordNet) prefs.extract = true;
		}
		prefs.tagset = tagset;
		prefs.template = template;
		x = Double.parseDouble(mincvalue.getText());
		if (x != prefs.mincvalue) {
			tprefs.mincvalue = prefs.mincvalue = x;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.repaint = true;
		}
		x = Double.parseDouble(alpha.getText());
		if (x != prefs.alpha){
			tprefs.alpha = prefs.alpha = x;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.compare = true;
		}
		x = Double.parseDouble(beta.getText());
		if (x != prefs.beta){
			tprefs.beta = prefs.beta = x;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.compare = true;
		}
		m = Integer.parseInt(minfrq.getText());
		if (m != prefs.minfrq) {
			tprefs.minfrq = prefs.minfrq = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			prefs.repaint = true;
		}
		m = Integer.parseInt(factor.getText());
		if (m != prefs.NPMIfactor) {
			tprefs.NPMIfactor = prefs.NPMIfactor = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.useNPMIMethod && prefs.NPMIMethod == 3) prefs.extract = true;
		}
		m = Integer.parseInt(detRatio.getText());
		if (m != prefs.detRatio) {
			tprefs.detRatio = prefs.detRatio = m;
			tprefs.setModified(true);
			prefs.setModified(true);
			if (prefs.detHandling == 1 && prefs.detectDeterminers) prefs.extract = true;
		}
		f = countBox.isSelected();
		if (f != prefs.saveCount) {
			tprefs.saveCount = prefs.saveCount = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = rankBox.isSelected();
		if (f != prefs.saveRank) {
			tprefs.saveRank = prefs.saveRank = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = sfBox.isSelected();
		if (f != prefs.saveSF) {
			tprefs.saveSF = prefs.saveSF = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = bfBox.isSelected();
		if (f != prefs.saveBF) {
			tprefs.saveBF = prefs.saveBF = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = cvalueBox.isSelected();
		if (f != prefs.saveCV) {
			tprefs.saveCV = prefs.saveCV = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = compBox.isSelected();
		if (f != prefs.saveComp) {
			tprefs.saveComp = prefs.saveComp = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = lenBox.isSelected();
		if (f != prefs.saveLen) {
			tprefs.saveLen = prefs.saveLen = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = freqsBox.isSelected();
		if (f != prefs.saveFreqs) {
			tprefs.saveFreqs = prefs.saveFreqs = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = freqinBox.isSelected();
		if (f != prefs.saveFreqin) {
			tprefs.saveFreqin = prefs.saveFreqin = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
		f = contextBox.isSelected();
		if (f != prefs.saveContext) {
			tprefs.saveContext = prefs.saveContext = f;
			tprefs.setModified(true);
			prefs.setModified(true);
		}
	}
	
	public boolean compareLists(LinkedList<?> list1, LinkedList<?> list2)
	{
		if (list1 == list2) return true;
		if (list1 != null && list2 != null) {
			if (list1.size() == list2.size()) {
				if (list1.containsAll(list2)) return true;
				return false;
			}
			return false;
		}
		return false;
	}
	
	public void dispose()
	{
		if (dialog != null) dialog.dispose();
	}
	
	public int doDialog()
	{
		answer = -1;
		dialog = new JDialog(TermoPL.dialogOwner);
		dialog.setModal(true);
		dialog.setResizable(false);
		dialog.setDefaultCloseOperation(JDialog.HIDE_ON_CLOSE);
		dialog.setTitle("Options");
		dialog.getContentPane().add(this);
		dialog.getRootPane().setDefaultButton(okButton);
		dialog.pack();
		dialog.setLocationRelativeTo(TermoPL.dialogOwner);
		dialog.setVisible(true);
		return answer;
	}
	
	private class StopWordsPanel extends JPanel
	{
		
		public StopWordsPanel()
		{
			super(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
		}
		
		public void arrangeComponents()
		{
			JScrollPane sp;
			Box hbox, vbox;
			TableColumnModel columnModel;
			TableColumn column;
			JLabel label;

			hbox = Box.createHorizontalBox();
			checkSW = new JCheckBox("Check for stop words:");
			hbox.add(checkSW);
			hbox.add(Box.createHorizontalGlue());
			add(hbox, BorderLayout.NORTH);
			swTable = new JTable();
			swTable.setModel(new SWCPCTTableModel(swTable));
			swTable.setShowHorizontalLines(false);
			swTable.setShowVerticalLines(false);
			swTable.setCellSelectionEnabled(true);
			swTable.setTableHeader(null);
			swTable.setPreferredScrollableViewportSize(new Dimension(500, 28 * swTable.getRowHeight()));
			columnModel = swTable.getColumnModel();
			column = columnModel.getColumn(0);
			column.setCellRenderer(new RowRenderer());
			column.setCellEditor(new SWCPCTTableEditor(swTable));
			sp = new JScrollPane(swTable);
			sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			add(sp, BorderLayout.CENTER);
			vbox = Box.createVerticalBox();
			vbox.add(Box.createVerticalStrut(2));
			hbox = Box.createHorizontalBox();
			addSWButton = new PictButton("plus.png", true);
			addSWButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(addSWButton);
			removeSWButton = new PictButton("minus.png", true);
			removeSWButton.setEnabled(false);
			removeSWButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(removeSWButton);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			label = new JLabel(" and merge ");
			loadSWButton = new JButton("Load...");
			mergeSW = new JCheckBox();
			mergeSW.setSelected(prefs.mergeSW);
			saveSWButton = new JButton("Save...");
			clearSWButton = new JButton("Clear");
			hbox.add(loadSWButton);
			hbox.add(label);
			hbox.add(mergeSW);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(saveSWButton);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(Box.createHorizontalGlue());
			hbox.add(clearSWButton);
			vbox.add(hbox);
			add(vbox, BorderLayout.SOUTH);
			swTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent event) 
				{
					int row = swTable.getSelectedRow();
					
					removeSWButton.setEnabled(row >= 0);
				}
			});
			addSWButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (swTable.isEditing()) ok = swTable.getCellEditor().stopCellEditing();
					else ok = true;
					if (ok) {
						SWCPCTTableModel model = (SWCPCTTableModel)swTable.getModel();
						int row;
						
						if (sw == null) sw = new LinkedList<String>();
						row = sw.size();
						sw.add("");
						model.fireTableRowsInserted(row, row);
						swTable.scrollRectToVisible(swTable.getCellRect(row,  0,  true));
						swTable.editCellAt(row, 0);
						clearSWButton.setEnabled(sw != null);
						saveSWButton.setEnabled(sw != null);
					}
				}
			});
			removeSWButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)swTable.getModel();
					int rows[] = swTable.getSelectedRows();
					
					if (rows != null) {
						for (int i = 0; i < rows.length; i++) {
							sw.remove(rows[i] - i);
							if (sw.size() == 0) sw = null;
						}
						model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
					}
					clearSWButton.setEnabled(sw != null);
					saveSWButton.setEnabled(sw != null);
				}
			});
			loadSWButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (swTable.isEditing()) {
						if (mergeSW.isSelected()) ok = swTable.getCellEditor().stopCellEditing();
						else {
							swTable.getCellEditor().cancelCellEditing();
							ok = true;
						}
					}
					else ok = true;
					
					if (ok) {
						JFileChooser chooser = new JFileChooser();
						
						chooser.setDialogTitle("Load Stop Words");
						chooser.setMultiSelectionEnabled(false);
						if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							try {
								BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF8"));
								String line;
								
								if (!mergeSW.isSelected()) sw = null;
								do {
									line = reader.readLine();
									if (line != null) {
										line = line.trim();
										if (!line.isEmpty()) {
											if (sw == null) sw = new LinkedList<String>();
											if (!sw.contains(line)) sw.add(line);
										}
									}
								} while (line != null);
								reader.close();
							}
							catch (IOException exception) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(exception.toString());
							}
							
							SWCPCTTableModel model = (SWCPCTTableModel)swTable.getModel();
							
							model.fireTableDataChanged();
						}
					}
					clearSWButton.setEnabled(sw != null);
					saveSWButton.setEnabled(sw != null);
				}
			});
			saveSWButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (swTable.isEditing()) ok = swTable.getCellEditor().stopCellEditing();
					else ok = true;
					
					if (ok) {
						SaveFileChooser chooser = new SaveFileChooser();
						
						chooser.setDialogTitle("Save Stop Words");
						chooser.setSelectedFile(new File("StopWords.txt"));
						if (chooser.showSaveDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							try {
								PrintWriter pw = new PrintWriter(file, "UTF8");
								
								if (sw != null) {
									for (String s : sw) {
										pw.println(s);
									}
								}
								pw.flush();
								pw.close();
							} 
							catch (FileNotFoundException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							}
							catch (UnsupportedEncodingException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							}
						}
					}
				}
			});
			clearSWButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)swTable.getModel();
					int s = sw.size();
					
					sw = null;
					model.fireTableRowsDeleted(0, s);
					clearSWButton.setEnabled(false);
					saveSWButton.setEnabled(false);
				}
			});
			clearSWButton.setEnabled(sw != null);
			saveSWButton.setEnabled(sw != null);
			checkSW.setSelected(prefs.checkStopWords);
		}
		
	}
	
	private class CompPrepPanel extends JPanel
	{
		
		public CompPrepPanel()
		{
			super(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
		}
		
		public void arrangeComponents()
		{
			JScrollPane sp;
			Box hbox, vbox;
			TableColumnModel columnModel;
			TableColumn column;
			JLabel label;

			hbox = Box.createHorizontalBox();
			removeCP = new JCheckBox("Remove compound prepositions:");
			hbox.add(removeCP);
			hbox.add(Box.createHorizontalGlue());
			add(hbox, BorderLayout.NORTH);
			cpTable = new JTable();
			cpTable.setModel(new SWCPCTTableModel(cpTable));
			cpTable.setShowHorizontalLines(false);
			cpTable.setShowVerticalLines(false);
			cpTable.setCellSelectionEnabled(true);
			cpTable.setTableHeader(null);
			cpTable.setTableHeader(null);
			cpTable.setPreferredScrollableViewportSize(new Dimension(500, 28 * cpTable.getRowHeight()));
			columnModel = cpTable.getColumnModel();
			column = columnModel.getColumn(0);
			column.setCellRenderer(new RowRenderer());
			column.setCellEditor(new SWCPCTTableEditor(cpTable));
			sp = new JScrollPane(cpTable);
			sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			add(sp, BorderLayout.CENTER);
			vbox = Box.createVerticalBox();
			vbox.add(Box.createVerticalStrut(2));
			hbox = Box.createHorizontalBox();
			addCPButton = new PictButton("plus.png", true);
			addCPButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(addCPButton);
			removeCPButton = new PictButton("minus.png", true);
			removeCPButton.setEnabled(false);
			removeCPButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(removeCPButton);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			label = new JLabel(" and merge ");
			loadCPButton = new JButton("Load...");
			mergeCP = new JCheckBox();
			mergeCP.setSelected(prefs.mergeCP);
			saveCPButton = new JButton("Save...");
			clearCPButton = new JButton("Clear");
			hbox.add(loadCPButton);
			hbox.add(label);
			hbox.add(mergeCP);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(saveCPButton);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(Box.createHorizontalGlue());
			hbox.add(clearCPButton);
			vbox.add(hbox);
			add(vbox, BorderLayout.SOUTH);
			cpTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent event) 
				{
					int row = cpTable.getSelectedRow();
					
					removeCPButton.setEnabled(row >= 0);
				}
			});
			addCPButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (cpTable.isEditing()) ok = cpTable.getCellEditor().stopCellEditing();
					else ok = true;
					if (ok) {
						SWCPCTTableModel model = (SWCPCTTableModel)cpTable.getModel();
						int row;
						
						if (cp == null) cp = new LinkedList<String>();
						row = cp.size();
						cp.add("");
						model.fireTableRowsInserted(row, row);
						cpTable.scrollRectToVisible(cpTable.getCellRect(row,  0,  true));
						cpTable.editCellAt(row, 0);
						clearCPButton.setEnabled(cp != null);
						saveCPButton.setEnabled(cp != null);
					}
				}
			});
			removeCPButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)cpTable.getModel();
					int rows[] = cpTable.getSelectedRows();
					
					if (rows != null) {
						for (int i = 0; i < rows.length; i++) {
							cp.remove(rows[i] - i);
							if (cp.size() == 0) cp = null;
						}
						model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
					}
					clearCPButton.setEnabled(cp != null);
					saveCPButton.setEnabled(cp != null);
				}
			});
			loadCPButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (cpTable.isEditing()) {
						if (mergeCP.isSelected()) ok = cpTable.getCellEditor().stopCellEditing();
						else {
							cpTable.getCellEditor().cancelCellEditing();
							ok = true;
						}
					}
					else ok = true;
					
					if (ok) {
						JFileChooser chooser = new JFileChooser();
						
						chooser.setDialogTitle("Load Compound Prepositions");
						chooser.setMultiSelectionEnabled(false);
						if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							if (!mergeCP.isSelected()) cp = null;
							try {
								BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF8"));
								String line;
								
								do {
									line = reader.readLine();
									if (line != null) {
										line = line.trim();
										if (!line.isEmpty()) {
											if (cp == null) cp = new LinkedList<String>();
											if (!cp.contains(line)) cp.add(line);
										}
									}
								} while (line != null);
								reader.close();
							}
							catch (IOException exception) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(exception.toString());
							}
							
							SWCPCTTableModel model = (SWCPCTTableModel)cpTable.getModel();
							
							model.fireTableDataChanged();
						}
					}
					clearCPButton.setEnabled(cp != null);
					saveCPButton.setEnabled(cp != null);

				}
			});
			saveCPButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (cpTable.isEditing()) ok = cpTable.getCellEditor().stopCellEditing();
					else ok = true;
					
					if (ok) {
						SaveFileChooser chooser = new SaveFileChooser();
						
						chooser.setDialogTitle("Save Compound Prepositions");
						chooser.setSelectedFile(new File("CompoundPrepositions.txt"));
						if (chooser.showSaveDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							try {
								PrintWriter pw = new PrintWriter(file, "UTF8");
								
								if (cp != null) {
									for (String s : cp) {
										pw.println(s);
									}
								}
								pw.flush();
								pw.close();
							} 
							catch (FileNotFoundException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							} 
							catch (UnsupportedEncodingException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							}
						}
					}
				}
			});
			clearCPButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)cpTable.getModel();
					int s = cp.size();
					
					cp = null;
					model.fireTableRowsDeleted(0, s);
					clearCPButton.setEnabled(false);
					saveCPButton.setEnabled(false);
				}
			});
			clearCPButton.setEnabled(cp != null);
			saveCPButton.setEnabled(cp != null);
			removeCP.setSelected(prefs.removeCompoundPreps);
		}
		
	}
	
	private class CommonTermsPanel extends JPanel
	{
		
		public CommonTermsPanel()
		{
			super(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
		}
		
		public void arrangeComponents()
		{
			JScrollPane sp;
			Box hbox, vbox;
			TableColumnModel columnModel;
			TableColumn column;
			JLabel label;

			hbox = Box.createHorizontalBox();
			removeCT = new JCheckBox("Remove common terms:");
			hbox.add(removeCT);
			hbox.add(Box.createHorizontalGlue());
			add(hbox, BorderLayout.NORTH);
			ctTable = new JTable();
			ctTable.setModel(new SWCPCTTableModel(ctTable));
			ctTable.setShowHorizontalLines(false);
			ctTable.setShowVerticalLines(false);
			ctTable.setCellSelectionEnabled(true);
			ctTable.setTableHeader(null);
			ctTable.setTableHeader(null);
			ctTable.setPreferredScrollableViewportSize(new Dimension(500, 28 * ctTable.getRowHeight()));
			columnModel = ctTable.getColumnModel();
			column = columnModel.getColumn(0);
			column.setCellRenderer(new RowRenderer());
			column.setCellEditor(new SWCPCTTableEditor(ctTable));
			sp = new JScrollPane(ctTable);
			sp.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			add(sp, BorderLayout.CENTER);
			vbox = Box.createVerticalBox();
			vbox.add(Box.createVerticalStrut(2));
			hbox = Box.createHorizontalBox();
			addCTButton = new PictButton("plus.png", true);
			addCTButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(addCTButton);
			removeCTButton = new PictButton("minus.png", true);
			removeCTButton.setEnabled(false);
			removeCTButton.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			hbox.add(removeCTButton);
			hbox.add(Box.createHorizontalGlue());
			showSimplifiedForms = new JCheckBox("Show simplified forms");
			showSimplifiedForms.setSelected(prefs.showSimplifiedForms);
			hbox.add(showSimplifiedForms);
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			label = new JLabel(" and merge ");
			loadCTButton = new JButton("Load...");
			mergeCT = new JCheckBox();
			mergeCT.setSelected(prefs.mergeCT);
			saveCTButton = new JButton("Save...");
			clearCTButton = new JButton("Clear");
			hbox.add(loadCTButton);
			hbox.add(label);
			hbox.add(mergeCT);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(saveCTButton);
			hbox.add(Box.createHorizontalStrut(8));
			hbox.add(Box.createHorizontalGlue());
			hbox.add(clearCTButton);
			vbox.add(hbox);
			add(vbox, BorderLayout.SOUTH);
			ctTable.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent event) 
				{
					int row = ctTable.getSelectedRow();
					
					removeCTButton.setEnabled(row >= 0);
				}
			});
			addCTButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (ctTable.isEditing()) ok = ctTable.getCellEditor().stopCellEditing();
					else ok = true;
					if (ok) {
						SWCPCTTableModel model = (SWCPCTTableModel)ctTable.getModel();
						int row;
						
						if (ct == null) ct = new LinkedList<CommonTerm>();
						row = ct.size();
						ct.add(new CommonTerm());
						model.fireTableRowsInserted(row, row);
						ctTable.scrollRectToVisible(ctTable.getCellRect(row,  0,  true));
						ctTable.editCellAt(row, 0);
						clearCTButton.setEnabled(ct != null);
						saveCTButton.setEnabled(ct != null);
					}
				}
			});
			removeCTButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)ctTable.getModel();
					int rows[] = ctTable.getSelectedRows();
					
					if (rows != null) {
						for (int i = 0; i < rows.length; i++) {
							ct.remove(rows[i] - i);
							if (ct.size() == 0) ct = null;
						}
						model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
					}
					clearSWButton.setEnabled(ct != null);
					saveSWButton.setEnabled(ct != null);
				}
			});
			loadCTButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (ctTable.isEditing()) {
						if (mergeCT.isSelected()) ok = ctTable.getCellEditor().stopCellEditing();
						else {
							ctTable.getCellEditor().cancelCellEditing();
							ok = true;
						}
					}
					else ok = true;
					
					if (ok) {
						JFileChooser chooser = new JFileChooser();
						
						chooser.setDialogTitle("Load Common Terms");
						chooser.setMultiSelectionEnabled(false);
						if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							try {
								BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF8"));
								String line;
								
								if (!mergeSW.isSelected()) ct = null;
								do {
									line = reader.readLine();
									if (line != null) {
										line = line.trim();
										if (!line.isEmpty()) {
											String bf = null, sf = null;
											
											if (ct == null) ct = new LinkedList<CommonTerm>();
											
											int index = line.indexOf("[");
											
											if (index < 0) {
												sf = line;
												bf = line;
											}
											else {
												sf = line.substring(0, index).trim();
												bf = line.substring(index + 1).replace("]", "").trim();
											}
											ct.add(new CommonTerm(bf, sf));
										}
									}
								} while (line != null);
								reader.close();
							}
							catch (IOException exception) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(exception.toString());
							}
							
							SWCPCTTableModel model = (SWCPCTTableModel)ctTable.getModel();
							
							model.fireTableDataChanged();
						}
					}
					clearCTButton.setEnabled(ct != null);
					saveCTButton.setEnabled(ct != null);
				}
			});
			saveCTButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok;
					
					if (ctTable.isEditing()) ok = ctTable.getCellEditor().stopCellEditing();
					else ok = true;
					
					if (ok) {
						SaveFileChooser chooser = new SaveFileChooser();
						
						chooser.setDialogTitle("Save Common Terms");
						chooser.setSelectedFile(new File("CommonTerms.txt"));
						if (chooser.showSaveDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
							File file = chooser.getSelectedFile();
							
							try {
								PrintWriter pw = new PrintWriter(file, "UTF8");
								
								if (ct != null) {
									for (CommonTerm t : ct) {
										pw.print(t.sf);
										pw.print("\t");
										pw.println("[" + t.bf + "]");
									}
								}
								pw.flush();
								pw.close();
							} 
							catch (FileNotFoundException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							} 
							catch (UnsupportedEncodingException e) {
								ErrorViewer viewer = new ErrorViewer(dialog);
								viewer.showError(e.toString());
							}
						}
					}
				}
			});
			clearCTButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					SWCPCTTableModel model = (SWCPCTTableModel)ctTable.getModel();
					int s = ct.size();
					
					ct = null;
					model.fireTableRowsDeleted(0, s);
					clearCTButton.setEnabled(false);
					saveCTButton.setEnabled(false);
				}
			});
			showSimplifiedForms.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					boolean ok = true;
					
					if (ctTable.isEditing()) {
						SWCPCTTableEditor editor = (SWCPCTTableEditor) ctTable.getCellEditor();
						
						ok = editor.stopCellEditing(false);
					}
					if (ok) {
						SWCPCTTableModel model = (SWCPCTTableModel)ctTable.getModel();
						
						model.fireTableDataChanged();
					}
				}
			});
			clearCTButton.setEnabled(ct != null);
			saveCTButton.setEnabled(ct != null);
			removeCT.setSelected(prefs.removeCommonTerms);
		}
		
	}
	
	private class GrammarPanel extends JPanel
	{
		
		public GrammarPanel()
		{
			super();
			setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
		}
		
		public void arrangeComponents()
		{
			ButtonGroup group = new ButtonGroup();
			Box hbox, vbox;
			JLabel label;
			JPanel panel = new JPanel(new BorderLayout());
			
			hbox = Box.createHorizontalBox();
			label = new JLabel("Language: ");
			hbox.add(label);
			languageCombo = new LangCombo();
			hbox.add(languageCombo);
			add(hbox);
			add(Box.createVerticalStrut(16));
			panel.setBorder(BorderFactory.createCompoundBorder(
					BorderFactory.createTitledBorder("Extraction Method"),
					BorderFactory.createEmptyBorder(8, 16, 8, 16)));
			vbox = Box.createVerticalBox();
			hbox = Box.createHorizontalBox();
			UDButton = new JRadioButton("Universal Dependencies");
			UDButton.setSelected(prefs.useUD);
			shallowGButton = new JRadioButton("Grammar Templates");
			shallowGButton.setSelected(!prefs.useUD);
			group.add(UDButton);
			group.add(shallowGButton);
			hbox.add(UDButton);
			hbox.add(Box.createHorizontalStrut(32));
			hbox.add(shallowGButton);
			vbox.add(hbox);
			panel.add(vbox, BorderLayout.CENTER);
			add(panel);
			add(Box.createVerticalStrut(16));
			tPanel = new JPanel(new BorderLayout());
			tPanel.setBorder(BorderFactory.createCompoundBorder(
					BorderFactory.createTitledBorder("Tagset"),
					BorderFactory.createEmptyBorder(8, 16, 8, 16)));
			vbox = Box.createVerticalBox();
			hbox = Box.createHorizontalBox();
			standardTagsetButton = new JRadioButton("Use built-in tagset");
			standardTagsetButton.setSelected(!prefs.useCustomTagset);
			group = new ButtonGroup();
			group.add(standardTagsetButton);
			hbox.add(standardTagsetButton);
			hbox.add(Box.createHorizontalGlue());
			add(hbox);
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			customTagsetButton = new JRadioButton("Use custom tagset");
			customTagsetButton.setSelected(prefs.useCustomTagset);
			group.add(customTagsetButton);
			hbox.add(customTagsetButton);
			hbox.add(Box.createHorizontalGlue());
			add(hbox);
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			tagsetNameLabel = new JLabel("Tagset: ");
			hbox.add(tagsetNameLabel);
			tagsetName = new JLabel();
			hbox.add(tagsetName);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			vbox.add(Box.createVerticalGlue());
			hbox = Box.createHorizontalBox();
			changeTagset = new JButton("Change tagset...");
			hbox.add(Box.createHorizontalGlue());
			hbox.add(changeTagset);
			vbox.add(hbox);
			tPanel.add(vbox, BorderLayout.CENTER);
			add(tPanel);
			add(Box.createVerticalStrut(16));
			gPanel = new JPanel(new BorderLayout());
			gPanel.setBorder(BorderFactory.createCompoundBorder(
					BorderFactory.createTitledBorder("Grammar"),
					BorderFactory.createEmptyBorder(8, 16, 8, 16)));
			group = new ButtonGroup();
			vbox = Box.createVerticalBox();
			hbox = Box.createHorizontalBox();
			standardGrammarButton = new JRadioButton("Use built-in grammar");
			standardGrammarButton.setSelected(!prefs.useCustomGrammar);
			group.add(standardGrammarButton);
			hbox.add(standardGrammarButton);
			hbox.add(Box.createHorizontalGlue());
			add(hbox);
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			customGrammarButton = new JRadioButton("Use custom grammar");
			customGrammarButton.setSelected(prefs.useCustomGrammar);
			group.add(customGrammarButton);
			hbox.add(customGrammarButton);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			grammarNameLabel = new JLabel("Grammar: ");
			hbox.add(grammarNameLabel);
			grammarName = new JLabel();
			hbox.add(grammarName);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			vbox.add(Box.createVerticalGlue());
			hbox = Box.createHorizontalBox();
			changeGrammar = new JButton("Change grammar...");
			hbox.add(Box.createHorizontalGlue());
			hbox.add(changeGrammar);
			vbox.add(hbox);
			gPanel.add(vbox, BorderLayout.CENTER);
			add(gPanel);
			add(Box.createVerticalStrut(8));
			panel = new JPanel(new BorderLayout());
			panel.setBorder(BorderFactory.createCompoundBorder(
					BorderFactory.createTitledBorder("Tagging/Parsing"),
					BorderFactory.createEmptyBorder(8, 16, 8, 16)));
			vbox = Box.createVerticalBox();
			panel.add(vbox, BorderLayout.CENTER);
			hbox = Box.createHorizontalBox();
			label = new JLabel("Use the following Python interpreter to tag/parse text files:");
			hbox.add(label);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			hbox = Box.createHorizontalBox();
			python = new JLabel();
			python.setFont(CommonResources.plainFont);
			hbox.add(python);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(8));
			vbox.add(Box.createVerticalGlue());
			hbox = Box.createHorizontalBox();
			changePython = new JButton("Change interpreter...");
			hbox.add(Box.createHorizontalGlue());
			hbox.add(changePython);
			vbox.add(hbox);
			add(panel);
			
			languageCombo.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeLanguage();
				}
			});
			
			UDButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					adjustControls();
					searchPanel.adjustControls();
				}
			});
			
			shallowGButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					adjustControls();
					searchPanel.adjustControls();
				}
			});
			
			changeTagset.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeTagset();
				}
			});
			
			standardTagsetButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeTagset(false);
				}
			});
			
			customTagsetButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeTagset(true);
				}
			});
			
			changeGrammar.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeGrammar();
				}
			});
			
			standardGrammarButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeTagset(false);
					changeGrammar(false);
				}
			});
			
			customGrammarButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeGrammar(true);
				}
			});
			
			changePython.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changePython();
				}
			});
			
			standardGrammarButton.setSelected(!prefs.useCustomGrammar);
			customGrammarButton.setSelected(prefs.useCustomGrammar);
			standardTagsetButton.setSelected(!prefs.useCustomTagset);
			customTagsetButton.setSelected(prefs.useCustomTagset);
			if (prefs.useCustomGrammar) grammarName.setText(grammarFile.getName());
			else {
				grammarName.setText(BUILT_IN);
				standardTagsetButton.setSelected(true);
			}
			if (prefs.useCustomTagset) tagsetName.setText(tagsetFile.getName());
			else tagsetName.setText(BUILT_IN);
			if (prefs.pythonPath == null) python.setText("<not selected>");
			else python.setText(prefs.pythonPath);
			initLanguageCombo();
			adjustControls();
		}
		
		public void adjustControls()
		{
			boolean f = shallowGButton.isSelected();
			boolean ff = f && customGrammarButton.isSelected();

			tPanel.setEnabled(ff);
			gPanel.setEnabled(f);
			changeTagset.setEnabled(ff);
			changeGrammar.setEnabled(f);
			standardTagsetButton.setEnabled(ff);
			customTagsetButton.setEnabled(ff);
			standardGrammarButton.setEnabled(f);
			customGrammarButton.setEnabled(f);
			tagsetNameLabel.setEnabled(f);
			grammarNameLabel.setEnabled(f);
			tagsetName.setEnabled(f);
			grammarName.setEnabled(f);
		}
		
		public void initLanguageCombo()
		{
			Dimension dim;
			
			languageCombo.addItem(new LanguageInfo(null, null));
			if (!TermoPL.languages.isEmpty()) {
				for (LanguageInfo langInfo : TermoPL.languages.values()) {
					languageCombo.addItem(langInfo);
				}
			}
			dim = languageCombo.getPreferredSize();
			languageCombo.setMaximumSize(dim);
			if (prefs.language == null) languageCombo.setSelectedIndex(0);
			else languageCombo.setSelectedItem(TermoPL.languages.get(prefs.language));
		}
		
		public void changeLanguage()
		{
			String str = ((LanguageInfo)languageCombo.getSelectedItem()).getLanguageCode();
			
			if ((str == null && language != null) || (str != null && !str.equals(language))) {
				EventQueue.invokeLater(new Runnable(){
					public void run() 
					{
						searchPanel.adjustControls();
						language = str;
					}
				});
			}
		}
		
		public void changeTagset()
		{
			JFileChooser chooser = new JFileChooser();
			
			chooser.setDialogTitle("Choose Tagset");
			chooser.setMultiSelectionEnabled(false);
			if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
				changeTagset(chooser.getSelectedFile());
			}
		}
		
		public void changeTagset(boolean custom)
		{
			if (custom) {
				if (changeTagset(tagsetPath)) {
					customTagsetButton.setSelected(true);
					standardTagsetButton.setSelected(false);
				}
			}
			else {
				languageCombo.setSelectedItem(TermoPL.languages.get("pl"));				
				tagsetName.setText(BUILT_IN);
				tagset = Tagset.createDefaultTagset();
				standardTagsetButton.setSelected(true);
				reloadGrammar();
			}
		}
		
		public boolean changeTagset(File file) 
		{
			TParser parser = new TParser(file, dialog);
			Tagset ts;

			parser.parse();
			ts = parser.getTagset();
			if (ts != null) {
				if (reloadGrammar()) {
					tagsetPath = file.getPath();
					tagset = ts;
					tagsetName.setText(file.getName());
					customTagsetButton.setSelected(true);
					standardTagsetButton.setSelected(false);
					return true;
				}
			}
			return false;
		}
		
		public boolean changeTagset(String path)
		{
			if (path == null) {
				changeTagset();
				if (tagsetPath != null) return true;
				return false;
			}
			return changeTagset(new File(path));
		}
		
		public void changeGrammar()
		{
			JFileChooser chooser = new JFileChooser();
			
			chooser.setDialogTitle("Choose Grammar");
			chooser.setMultiSelectionEnabled(false);
			if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
				changeGrammar(chooser.getSelectedFile());
			}
		}
		
		public void changeGrammar(boolean custom)
		{
			if (custom) {
				if (changeGrammar(grammarPath)) {
					customGrammarButton.setSelected(true);
					standardGrammarButton.setSelected(false);
				}
				else changeGrammar(false);
			}
			else {
				languageCombo.setSelectedItem(TermoPL.languages.get("pl"));				
				tagsetName.setText(BUILT_IN);
				tagset = Tagset.createDefaultTagset();
				standardTagsetButton.setSelected(true);
				grammarName.setText(BUILT_IN);
				template = Template.NPP();
				standardGrammarButton.setSelected(true);
			}
			adjustControls();
		}
		
		public boolean changeGrammar(File file) 
		{
			GParser parser = new GParser(file, tagset, dialog);
			Template tmp;

			parser.parse();
			tmp = parser.getTemplate();
			if (tmp != null) {
				grammarPath = file.getPath();
				template = tmp;
				grammarName.setText(file.getName());
				customGrammarButton.setSelected(true);
				standardGrammarButton.setSelected(false);
				return true;
			}
			return false;
		}
		
		public boolean changeGrammar(String path)
		{
			if (path == null) {
				changeGrammar();
				if (grammarPath != null) return true;
				return false;
			}
			return changeGrammar(new File(path));
		}
		
		public boolean reloadGrammar()
		{
			if (customGrammarButton.isSelected()) {
				if (changeGrammar(grammarPath)) return true;
				return false;
			}
			return true;
		}
		
		public void changePython()
		{
			JFileChooser chooser = new JFileChooser();
			
			chooser.setDialogTitle("Choose Python Interpreter");
			chooser.setMultiSelectionEnabled(false);
			if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
				File interp = chooser.getSelectedFile();
				pythonPath = interp.getPath();
				python.setText(pythonPath);
			}
		}
		
	}
	
	private class SearchPanel extends JPanel
	{
		
		public SearchPanel()
		{
			setLayout(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
			EventQueue.invokeLater(new Runnable() {
				public void run() 
				{
					adjustControls();
				}
			});
		}
		
		public void arrangeComponents()
		{
			Box vbox;
			Box hbox;
			ButtonGroup group;
	        Dimension dim;
			
	        // Ignore case
			vbox = Box.createVerticalBox();
			hbox = Box.createHorizontalBox();
	        ignoreCase = new JCheckBox("Ignore case");
	        hbox.add(ignoreCase);
	        hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			ignoreCase.setSelected(prefs.ignoreCase);
			
			// NPMI
			group = new ButtonGroup();
			hbox = Box.createHorizontalBox();
			NPMI = new JCheckBox("Use NPMI method to search for nested terms");
			hbox.add(NPMI);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			method1Button = new JRadioButton("Method 1");
			group.add(method1Button);
			hbox.add(method1Button);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			method2Button = new JRadioButton("Method 2");
			group.add(method2Button);
			hbox.add(method2Button);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			method3Button = new JRadioButton("Method 3");
			group.add(method3Button);
			hbox.add(method3Button);
			hbox.add(Box.createHorizontalStrut(32));
			label1 = new JLabel("Preference factor: ");
			hbox.add(label1);
			factor = new JTextField(3);
			dim = factor.getPreferredSize();
			factor.setMaximumSize(dim);
			hbox.add(factor);
			label2 = new JLabel("%");
			hbox.add(label2);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			leftToRight = new JCheckBox("Trim phrases from left to right");
			hbox.add(leftToRight);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(6));
			hbox = Box.createHorizontalBox();
			info1 = new JLabel();
			info1.setFont(CommonResources.plainFont);
			hbox.add(info1);
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(12));
			NPMI.setSelected(prefs.useNPMIMethod);
			method1Button.setSelected(prefs.NPMIMethod == 1);
			method2Button.setSelected(prefs.NPMIMethod == 2);
			method3Button.setSelected(prefs.NPMIMethod == 3);
			leftToRight.setSelected(prefs.trimFromLeftToRight);
			factor.setText(Integer.toString(prefs.NPMIfactor));
			
			// Context counting
			group = new ButtonGroup();
			hbox = Box.createHorizontalBox();
			label3 = new JLabel("Context counting method:");
			hbox.add(label3);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(6));
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			cntxMethod1Button = new JRadioButton("Method 1");
			group.add(cntxMethod1Button);
			hbox.add(cntxMethod1Button);
			hbox.add(Box.createHorizontalStrut(32));
			cntxMethod2Button = new JRadioButton("Method 2");
			group.add(cntxMethod2Button);
			hbox.add(cntxMethod2Button);
			hbox.add(Box.createHorizontalStrut(32));
			cntxMethod3Button = new JRadioButton("Method 3");
			group.add(cntxMethod3Button);
			hbox.add(cntxMethod3Button);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(6));
			hbox = Box.createHorizontalBox();
			info2 = new JLabel();
			info2.setFont(CommonResources.plainFont);
			hbox.add(info2);
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(12));
			cntxMethod1Button.setSelected(prefs.cntxMethod == 1);
			cntxMethod2Button.setSelected(prefs.cntxMethod == 2);
			cntxMethod3Button.setSelected(prefs.cntxMethod == 3);
			
			// Handling determiners
			group = new ButtonGroup();
			hbox = Box.createHorizontalBox();
			label4 = new JLabel("Handling determiners:");
			hbox.add(label4);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(6));
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			includeDeterminers = new JRadioButton("Include");
			group.add(includeDeterminers);
			hbox.add(includeDeterminers);
			hbox.add(Box.createHorizontalStrut(32));
			detectDeterminers = new JCheckBox("only if det/noun ratio exeeds ");
			hbox.add(detectDeterminers);
			detRatio = new JTextField(2);
			dim = detRatio.getPreferredSize();
			detRatio.setMaximumSize(dim);
			hbox.add(detRatio);
			label5 = new JLabel("%");
			hbox.add(label5);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			includeArticles = new JRadioButton("Include only articles");
			group.add(includeArticles);
			hbox.add(includeArticles);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			hbox.add(Box.createHorizontalStrut(32));
			excludeDeterminers = new JRadioButton("Exclude");
			group.add(excludeDeterminers);
			hbox.add(excludeDeterminers);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			sepBox = Box.createVerticalStrut(6);
			vbox.add(sepBox);
			hbox = Box.createHorizontalBox();
			info3 = new JLabel();
			info3.setFont(CommonResources.plainFont);
			hbox.add(info3);
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(12));
			includeDeterminers.setSelected(prefs.detHandling == 1);
			includeArticles.setSelected(prefs.detHandling == 2);
			excludeDeterminers.setSelected(prefs.detHandling == 3);
			detectDeterminers.setSelected(prefs.detectDeterminers);
			detRatio.setText(Integer.toString(prefs.detRatio));
			
			// Grouping
			hbox = Box.createHorizontalBox();
			makeGroups = new JCheckBox("Group terms");
			hbox.add(makeGroups);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			useWordNet = new JCheckBox("Use plWordNet for term grouping");
			hbox.add(useWordNet);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalStrut(6));
			hbox = Box.createHorizontalBox();
			label5 = new JLabel("plWordNet file: ");
			label5.setFont(CommonResources.plainFont);
			hbox.add(label5);
			wordNetFile = new JLabel();
			wordNetFile.setFont(CommonResources.plainFont);
			hbox.add(wordNetFile);
			hbox.add(Box.createHorizontalStrut(32));
			hbox.add(Box.createHorizontalGlue());
			changeWordNetButton = new JButton("Change...");
			hbox.add(changeWordNetButton);
			vbox.add(hbox);
			makeGroups.setSelected(prefs.makeGroups);
			useWordNet.setSelected(prefs.useWordNet);
			if (wordNetPath != null) {
				File f = new File(wordNetPath);
				
				if (f.exists()) wordNetFile.setText(f.getName());
				else wordNetPath = null;
			}
			if (wordNetPath == null) wordNetFile.setText("<not selected>");
			add(vbox, BorderLayout.NORTH);
			ActionListener listener = new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					adjustControls();
				}
			};
			NPMI.addActionListener(listener);
			leftToRight.addActionListener(listener);
			method1Button.addActionListener(listener);
			method2Button.addActionListener(listener);
			method3Button.addActionListener(listener);
			cntxMethod1Button.addActionListener(listener);
			cntxMethod2Button.addActionListener(listener);
			cntxMethod3Button.addActionListener(listener);
			includeDeterminers.addActionListener(listener);
			includeArticles.addActionListener(listener);
			excludeDeterminers.addActionListener(listener);
			useWordNet.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					if (useWordNet.isSelected() && wordNetPath == null) changeWordNetPath();
				}
			});
			changeWordNetButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event)
				{
					changeWordNetPath();
				}
			});
		}
		
		public void adjustControls()
		{
			boolean f1 = NPMI.isSelected();
			boolean f2 = shallowGButton.isSelected();
			String lang = ((LanguageInfo)languageCombo.getSelectedItem()).getLanguageCode();

			NPMI.setEnabled(f2);
			leftToRight.setEnabled(!f1 && f2);
			method1Button.setEnabled(f1 && f2);				
			method2Button.setEnabled(f1 && f2);
			method3Button.setEnabled(f1 && f2);
			factor.setEnabled(f1 && f2);
			label1.setEnabled(f1 && f2);
			label2.setEnabled(f1 && f2);
			info1.setEnabled(f2);
			info2.setEnabled(f2);
			f1 = f1 || !leftToRight.isSelected();
			label3.setEnabled(f2);
			cntxMethod1Button.setEnabled(f1 && f2);
			cntxMethod2Button.setEnabled(f1 && f2);
			cntxMethod3Button.setEnabled(f1 && f2);
			label4.setEnabled(!f2);
			includeDeterminers.setEnabled(!f2);
			detectDeterminers.setEnabled(!f2);
			detRatio.setEnabled(!f2);
			includeArticles.setEnabled(!f2);
			excludeDeterminers.setEnabled(!f2);
			info3.setEnabled(!f2);
			f2 = (lang != null && lang.equals("pl"));
			useWordNet.setEnabled(f2);
			label5.setEnabled(f2);
			wordNetFile.setEnabled(f2);
			changeWordNetButton.setEnabled(f2);
			setInfo1();
			setInfo2();
			setInfo3();
		}
		
		public void setInfo1()
		{
			if (NPMI.isSelected()) {
				if (method1Button.isSelected()) info1.setText(INFO2);
				else if (method2Button.isSelected()) info1.setText(INFO3);
				else info1.setText(INFO4);
			}
			else if (leftToRight.isSelected()) info1.setText(INFO9);
			else info1.setText(INFO1);
		}
		
		public void setInfo2()
		{
			if (leftToRight.isSelected() && leftToRight.isEnabled()) info2.setText(INFO8);
			else {
				if (cntxMethod1Button.isSelected()) info2.setText(INFO5);
				else if (cntxMethod2Button.isSelected()) info2.setText(INFO6);
				else info2.setText(INFO7);
			}
		}
		
		public void setInfo3()
		{
			if (includeDeterminers.isSelected()) {
				info3.setText(INF10);
				info3.setVisible(true);
				sepBox.setVisible(true);
			}
			else {
				info3.setText("");
				info3.setVisible(false);
				sepBox.setVisible(false);
			}
		}
		
		public void changeWordNetPath()
		{
			JFileChooser chooser = new JFileChooser();
			
			chooser.setDialogTitle("Choose plWordNet");
			chooser.setMultiSelectionEnabled(false);
			if (chooser.showOpenDialog(Options.this) == JFileChooser.APPROVE_OPTION) {
				wordNetPath = chooser.getSelectedFile().getAbsolutePath();
				wordNetFile.setText(chooser.getSelectedFile().getName());
			}
			else if (wordNetPath == null) useWordNet.setSelected(false);
		}
		
	}
	
	private class ComparePanel extends JPanel
	{
		
		public ComparePanel()
		{
			super(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
			EventQueue.invokeLater(new Runnable() {
				public void run() 
				{
					adjustControls();
				}
			});
		}
		
		public void arrangeComponents()
		{
			Box vbox = Box.createVerticalBox();
			Box hbox = Box.createHorizontalBox();
			Box hboxi = Box.createHorizontalBox();
			Box indent = Box.createHorizontalBox();
			JPanel p = new JPanel(new GridBagLayout());
			GridBagConstraints constr = new GridBagConstraints();
			ButtonGroup group = new ButtonGroup();
			DecimalFormat format = new DecimalFormat("#.##");
	        Dimension dim;
			
			constr.anchor = GridBagConstraints.WEST;
			constr.gridwidth = GridBagConstraints.REMAINDER;
			applyContrastiveRanking = new JCheckBox("Compare corpora using:");
			applyContrastiveRanking.setSelected(prefs.applyContrastiveRanking);
			hbox.add(applyContrastiveRanking);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			indent.add(Box.createHorizontalStrut(32));
			dim = indent.getPreferredSize();
			indent.setMaximumSize(dim);
			hbox.add(indent);
			LLButton = new JRadioButton("Corpora-comparing log-likelihood (LL),");
			LLButton.setSelected(prefs.contrastiveRankingMethod == 1);
			group.add(LLButton);
			p.add(LLButton, constr);
			TFITFButton = new JRadioButton("Term Frequency Inverse Term Frequency (TFITF),");
			TFITFButton.setSelected(prefs.contrastiveRankingMethod == 2);
			group.add(TFITFButton);
			p.add(TFITFButton, constr);
			CSmwButton = new JRadioButton("Contrastive Selection of multi-word terms (CSmw),");
			CSmwButton.setSelected(prefs.contrastiveRankingMethod == 3);
			group.add(CSmwButton);
			p.add(CSmwButton, constr);
			TWButton = new JRadioButton("Term Weight");
			TWButton.setSelected(prefs.contrastiveRankingMethod == 4);
			hboxi.setAlignmentY(CENTER_ALIGNMENT);
			group.add(TWButton);
			hboxi.add(TWButton);
			TWLabel = new JLabel(" (TW = ");
			hboxi.add(TWLabel);
			alpha = new JTextField(4);
			alpha.setText(format.format(prefs.alpha).replace(",", "."));
			dim = alpha.getPreferredSize();
			alpha.setMaximumSize(dim);
			hboxi.add(alpha);
			DRLabel = new JLabel(" \u00D7 DR + ");
			hboxi.add(DRLabel);
			beta = new JTextField(4);
			beta.setText(format.format(prefs.beta).replace(",", "."));
			dim = beta.getPreferredSize();
			beta.setMaximumSize(dim);
			hboxi.add(beta);
			DCLabel = new JLabel(" \u00D7 DC),");
			hboxi.add(DCLabel);
			hboxi.add(Box.createHorizontalGlue());
			p.add(hboxi, constr);
			constr.gridwidth = 1;
			topRankedOnly = new JCheckBox("for terms with C-value greater than ");
			topRankedOnly.setSelected(prefs.applyContrastiveRankingForTopRankedTerms);
			p.add(topRankedOnly, constr);
			constr.gridwidth = GridBagConstraints.REMAINDER;
			mincvalue = new JTextField(4);
			mincvalue.setText(format.format(prefs.mincvalue));
			dim = mincvalue.getPreferredSize();
			mincvalue.setMaximumSize(dim);
			p.add(mincvalue, constr);
			constr.gridwidth = 1;
			frequentOnly = new JCheckBox("for terms with frequency greater than ");
			frequentOnly.setSelected(prefs.applyContrastiveRankingForFrequentTerms);
			p.add(frequentOnly, constr);
			constr.gridwidth = GridBagConstraints.REMAINDER;
			minfrq = new JTextField(4);
			minfrq.setText(Integer.toString(prefs.minfrq));
			dim = minfrq.getPreferredSize();
			minfrq.setMaximumSize(dim);
			p.add(minfrq, constr);
			dim = p.getPreferredSize();
			p.setMaximumSize(dim);
			hbox.add(p);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			hbox = Box.createHorizontalBox();
			useCValues = new JCheckBox("Use C-values instead of frequencies");
			useCValues.setSelected(prefs.useCValues);
			useCValues.setEnabled(prefs.contrastiveRankingMethod != 4);
			hbox.add(useCValues);
			hbox.add(Box.createHorizontalGlue());
			vbox.add(hbox);
			vbox.add(Box.createVerticalGlue());
			hbox = Box.createHorizontalBox();
			contrastiveDataLabel = new JLabel("Contrastive terms: ");
			hbox.add(contrastiveDataLabel);
			contrastiveDataName = new JLabel();
			hbox.add(contrastiveDataName);
			if (prefs.contrastiveDataPath == null) {
				contrastiveDataName.setFont(getFont().deriveFont(Font.ITALIC));
				contrastiveDataName.setText("not selected ");
				contrastiveDataName.setEnabled(false);
			}
			else {
				contrastiveDataName.setFont(getFont().deriveFont(Font.PLAIN));
				contrastiveDataName.setText(TermoPL.getFileName(prefs.contrastiveDataPath));
				contrastiveDataName.setEnabled(true);
			}
			hbox.add(Box.createHorizontalGlue());
			selectContrastiveData = new JButton("Select");
			hbox.add(selectContrastiveData);
			vbox.add(hbox);
			add(vbox, BorderLayout.CENTER);
			
			ActionListener listener = new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					adjustControls();
				}
			};
			
			applyContrastiveRanking.addActionListener(listener);
			topRankedOnly.addActionListener(listener);
			
			listener = new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					adjustControls2();
				}
			};
			
			LLButton.addActionListener(listener);
			TFITFButton.addActionListener(listener);
			CSmwButton.addActionListener(listener);
			TWButton.addActionListener(listener);
			
			selectContrastiveData.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					String path = TermoPL.selectContrastiveCorpus(Options.this);
					
					if (path != null && (contrastiveDataPath == null || !contrastiveDataPath.equals(path))) {
						contrastiveDataName.setFont(getFont().deriveFont(Font.PLAIN));
						contrastiveDataName.setText(TermoPL.getFileName(path));
						contrastiveDataName.setEnabled(true);
						contrastiveDataPath = path;
					}
				}
			});
		}
		
		public void adjustControls()
		{
			boolean f = applyContrastiveRanking.isSelected();
			
			LLButton.setEnabled(f);
			TFITFButton.setEnabled(f);
			CSmwButton.setEnabled(f);
			TWButton.setEnabled(f);
			topRankedOnly.setEnabled(f);
			frequentOnly.setEnabled(f);
			useCValues.setEnabled(f && !TWButton.isSelected());
			mincvalue.setEnabled(f);
			minfrq.setEnabled(f);
			alpha.setEnabled(f);
			beta.setEnabled(f);
			TWLabel.setEnabled(f);
			DRLabel.setEnabled(f);
			DCLabel.setEnabled(f);
		}
		
		public void adjustControls2()
		{
			if (TWButton.isSelected()) {
				useCValues.setSelected(false);
				useCValues.setEnabled(false);
			}
			else useCValues.setEnabled(true);
		}
		
	}
	
	private class ExportPanel extends JPanel
	{
		
		public ExportPanel()
		{
			super(new BorderLayout());
			setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
			arrangeComponents();
		}
		
		public void arrangeComponents()
		{
			Box vbox = Box.createVerticalBox();
			Box hbox = Box.createHorizontalBox();
			JLabel label = new JLabel("Select fields to be exported:");
			
			vbox.add(label);
			vbox.add(Box.createVerticalStrut(8));
			countBox = new JCheckBox("#");
			countBox.setSelected(prefs.saveCount);
			vbox.add(countBox);
			rankBox = new JCheckBox("Rank");
			rankBox.setSelected(prefs.saveRank);
			vbox.add(rankBox);
			sfBox = new JCheckBox("Term (simplified form)");
			sfBox.setSelected(prefs.saveSF);
			vbox.add(sfBox);
			bfBox = new JCheckBox("Term (base form)");
			bfBox.setSelected(prefs.saveBF);
			vbox.add(bfBox);
			cvalueBox = new JCheckBox("C-value");
			cvalueBox.setSelected(prefs.saveCV);
			vbox.add(cvalueBox);
			compBox = new JCheckBox("LL/TFITF/CSmw/TW");
			compBox.setSelected(prefs.saveComp);
			vbox.add(compBox);
			lenBox = new JCheckBox("Length");
			lenBox.setSelected(prefs.saveLen);
			vbox.add(lenBox);
			freqsBox = new JCheckBox("Freq_s");
			freqsBox.setSelected(prefs.saveFreqs);
			vbox.add(freqsBox);
			freqinBox = new JCheckBox("Freq_in");
			freqinBox.setSelected(prefs.saveFreqin);
			vbox.add(freqinBox);
			contextBox = new JCheckBox("Context #");
			contextBox.setSelected(prefs.saveContext);
			vbox.add(contextBox);
			vbox.add(Box.createVerticalStrut(32));
			vbox.add(Box.createVerticalGlue());
			selectAllButton = new JButton("Select all fields");
			hbox.add(selectAllButton);
			hbox.add(Box.createHorizontalGlue());
			selectCCButton = new JButton("Select fields for corpora comparing");
			hbox.add(selectCCButton);
			hbox.add(Box.createHorizontalGlue());
			clearButton = new JButton("Clear");
			hbox.add(clearButton);
			add(vbox, BorderLayout.CENTER);
			add(hbox, BorderLayout.SOUTH);
			
			selectAllButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					countBox.setSelected(true);
					rankBox.setSelected(true);
					sfBox.setSelected(true);
					bfBox.setSelected(true);
					cvalueBox.setSelected(true);
					compBox.setSelected(true);
					lenBox.setSelected(true);
					freqsBox.setSelected(true);
					freqinBox.setSelected(true);
					contextBox.setSelected(true);
				}
			});
			selectCCButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					countBox.setSelected(false);
					rankBox.setSelected(false);
					sfBox.setSelected(true);
					bfBox.setSelected(false);
					cvalueBox.setSelected(true);
					compBox.setSelected(false);
					lenBox.setSelected(false);
					freqsBox.setSelected(true);
					freqinBox.setSelected(false);
					contextBox.setSelected(false);
				}
			});
			clearButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent event) 
				{
					countBox.setSelected(false);
					rankBox.setSelected(false);
					sfBox.setSelected(false);
					bfBox.setSelected(false);
					cvalueBox.setSelected(false);
					compBox.setSelected(false);
					lenBox.setSelected(false);
					freqsBox.setSelected(false);
					freqinBox.setSelected(false);
					contextBox.setSelected(false);
				}
			});
		}
		
	}
	
	private class SWCPCTTableModel extends AbstractTableModel
	{
		
		private JTable table;
		
		public SWCPCTTableModel(JTable table)
		{
			super();
			this.table = table;
		}
		
		public int getColumnCount() 
		{
			return 1;
		}

		public int getRowCount() 
		{
			if (table == swTable) {
				if (sw == null) return 0;
				return sw.size();
			}
			else if (table == cpTable) {
				if (cp == null) return 0;
				return cp.size();
			}
			else {
				if (ct == null) return 0;
				return ct.size();
			}
		}

		public boolean isCellEditable(int row, int column)
		{
			return true;
		}
		
		public Object getValueAt(int row, int column) 
		{
			if (table == swTable) {
				if (sw == null) return null;
				return sw.get(row);
			}
			else if (table == cpTable) {
				if (cp == null) return null;
				return cp.get(row);
			}
			else {
				if (ct == null) return null;
				if (showSimplifiedForms.isSelected()) return ct.get(row).sf;
				else return ct.get(row).bf;
			}
		}
		
	}
	
	private class SWCPCTTableEditor extends DefaultCellEditor
	{
		
		int row;
		String value;
		JTextField textField;
		JTable table;

		public SWCPCTTableEditor(JTable table) 
		{
			super(new JTextField());
			this.table = table;
		}
		
		public Component getTableCellEditorComponent(JTable table, Object value,
				boolean isSelected, int row, int column)
		{
			textField = (JTextField)super.getTableCellEditorComponent(table, 
				value, isSelected, row, column);
			textField.setBorder(BorderFactory.createLineBorder(Color.lightGray));
			this.row = row;
			this.value = textField.getText();
			EventQueue.invokeLater(new Runnable() {
				public void run()
				{
					textField.requestFocusInWindow();
				}
			});
			return textField;
		}
		
		public boolean stopCellEditing()
		{
			return stopCellEditing(true);
		}
		
		public boolean stopCellEditing(boolean f)
		{
			String newValue = textField.getText();
			boolean ok = stopEditing(newValue, f);
			
			if (ok) return super.stopCellEditing();
			return false;
		}
		
		public boolean stopEditing(String newValue, boolean f)
		{
			SWCPCTTableModel model = (SWCPCTTableModel)table.getModel();
			
			if (newValue.isEmpty()) {
				if (table == swTable) sw.remove(row);
				else if (table == cpTable) cp.remove(row);
				else ct.remove(row);
				model.fireTableRowsDeleted(row, row);
				if (table == swTable) {
					if (sw.size() == 0) sw = null;
					clearSWButton.setEnabled(sw != null);
					saveSWButton.setEnabled(sw != null);
				}
				else if (table == cpTable) {
					if (cp.size() == 0) cp = null;
					clearCPButton.setEnabled(cp != null);
					saveCPButton.setEnabled(cp != null);
				}
				else {
					if (ct.size() == 0) ct = null;
					clearCTButton.setEnabled(ct != null);
					saveCTButton.setEnabled(ct != null);
				}
			}
			else if (!newValue.equals(value)) {
				if (table == swTable) {
					model.setValueAt(newValue, row, 0);
					sw.set(row, newValue);
				}
				else if (table == cpTable) {
					PParser parser = new PParser(newValue, dialog);
					
					parser.parse();
					if (parser.getTemplate() == null) {
						textField.selectAll();
						textField.requestFocusInWindow();
						return false;
					}
					else {
						model.setValueAt(newValue, row, 0);
						cp.set(row, newValue);
					}
				}
				else {
					CommonTerm t = ct.get(row);
					
					model.setValueAt(newValue, row, 0);
					if (f) {
						if (showSimplifiedForms.isSelected()) {
							t.sf = newValue;
							if (t.bf.isEmpty()) t.bf = newValue;
						}
						else {
							t.bf = newValue;
							if (t.sf.isEmpty()) t.sf = t.createSimplifiedForm(t.bf);
						}
					}
					else {
						if (showSimplifiedForms.isSelected()) {
							t.bf = newValue;
							if (t.sf.isEmpty()) t.sf = t.createSimplifiedForm(t.bf);
						}
						else {
							t.sf = newValue;
							if (t.bf.isEmpty()) t.bf = newValue;
						}
					}
					ct.set(row, t);
				}
			}
			return true;
		}
		
	}
	
	private class RowRenderer extends DefaultTableCellRenderer
	{

		public Component getTableCellRendererComponent(JTable table, Object value,
			boolean isSelected, boolean hasFocus, int row, int column)
		{
			setValue(value);
			if (isSelected) {
				setForeground(UIManager.getColor("Table.selectionForeground"));
				setBackground(UIManager.getColor("Table.selectionBackground"));
			}
			else {
				setForeground(Color.black);
				if (row % 2 == 0) setBackground(CommonResources.VLIGHT_BLUE);
				else setBackground(Color.white);
			}
			return this;
		}
		
	}
	
}
