package termopl;

import java.io.*;
import java.util.*;

public class PParser extends Parser 
{
	
	private LinkedList<String> patterns;
	private Template template;
	
	public PParser(String pattern, Object owner)
	{
		super(owner);
		string = pattern;
		patterns = null;
	}
	
	public PParser(LinkedList<String> patterns, Object owner)
	{
		super(owner);
		this.patterns = patterns;
	}

	public void parse()
	{
		if (patterns != null) parsePatterns();
		else parseSinglePattern();
	}
	
	public void parsePatterns()
	{
		OrTemplate ot = new OrTemplate();
		
		try {
			for (String pat : patterns) {
				reader = new BufferedReader(new StringReader(pat));
				ot.add(parsePattern());
				reader.close();
			}
			if (noErrors()) template = ot;
			else template = null;
		}
		catch (IOException exception) {
			template = null;
		}
		catch (ParserException exception) {
			template = null;
		}
		reportErrors();
	}
	
	public void parseSinglePattern()
	{
		try {
			Template temp;
			
			reader = new BufferedReader(new StringReader(string));
			temp = parsePattern();
			reader.close();
			if (noErrors()) template = temp;
			else template = null;
		}
		catch (IOException exception) {
			template = null;
		}
		catch (ParserException exception) {
			template = null;
		}
		reportErrors();
	}
	
	public Template parsePattern() throws ParserException
	{
		return parsePatternList(Symbol.EMPTY);
	}

	public Template parsePatternList(Symbol stopSym) throws ParserException
	{
		boolean f;
		Template temp;
		CompoundTemplate temp1, temp2;
		
		getSymbol();
		temp1 = null;
		do {
			temp2 = null;
			do {
				if (symbol == Symbol.LBRCT){
					temp = parsePatternList(Symbol.RBRCT);
					temp.setQuantifier(Template.ZERO_OR_ONE);
					if (temp2 == null) temp2 = new AndTemplate(temp);
					else temp2.add(temp);
				}
				else if (symbol == Symbol.LPAR) {
					temp = parsePatternList(Symbol.RPAR);
					if (temp2 == null) temp2 = new AndTemplate(temp);
					else temp2.add(temp);
				}
				else {
					if (symbol == Symbol.HASH) {
						f = true;
						getSymbol();
					}
					else f = false;
					if (symbol == Symbol.IDENTIFIER) {
						if (f) {
							if (identifier.equals("adjp")) temp = Template.adjp;
							else {
								temp = null;
							}
						}
						else temp = new FormTemplate(identifier);
						getSymbol();
						if (temp != null) {
							if (temp2 == null) temp2 = new AndTemplate(temp);
							else temp2.add(temp);
						}
					}
					else {
						error(ParserError.SYMBOL_EXPECTED);
						skip(Symbol.IDENTIFIER);
					}
				}
			} while (!tooManyErrors() && (symbol == Symbol.IDENTIFIER || symbol == Symbol.HASH || symbol == Symbol.LPAR || symbol == Symbol.LBRCT));
			if (symbol == Symbol.OR) {
				getSymbol();
				if (temp1 == null) temp1 = new OrTemplate();
				if (temp2.size() > 1) temp1.add(temp2);
				else temp1.add(temp2.getFirst());
			}
		} while (symbol != stopSym && !tooManyErrors());
		if (stopSym != Symbol.EMPTY) getSymbol(); 
		if (temp1 != null) {
			if (temp2.size() > 1) temp1.add(temp2);
			else temp1.add(temp2.getFirst());
		}
		return (temp1 == null ? temp2 : temp1);
	}
	
	public void getSymbol() throws ParserException
	{
		int ch = SPACE;
		
		while (Character.isWhitespace(ch)) ch = getNextChar();
		scanPos = charCount - 1;
		if (Character.isLetter(ch)) {
			buffer.setLength(0);
			while (Character.isLetter(ch)) {
				buffer.append((char)ch);
				ch = getNextChar();
			}
			identifier = buffer.toString();
			symbol = Symbol.IDENTIFIER;
			if (ch != SPACE && ch != EOF && ch != EOL) charCount--;
		}
		else if (ch == HASH) symbol = Symbol.HASH;
		else if (ch == EOF) symbol = Symbol.EMPTY;
		else if (ch == LPAR) symbol = Symbol.LPAR;
		else if (ch == RPAR) symbol = Symbol.RPAR;
		else if (ch == LBRCT) symbol = Symbol.LBRCT;
		else if (ch == RBRCT) symbol = Symbol.RBRCT;
		else if (ch == VBAR) symbol = Symbol.OR;
		else symbol = Symbol.UNKNOWN;
	}
	
	public Template getTemplate()
	{
		return template;
	}

}
