package termopl;

import java.net.URL;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;


@SuppressWarnings("serial")
public class PictButton extends JButton
{

	public PictButton(String iconName, boolean paintFocus)
	{
		super();
		
		URL url = ClassLoader.getSystemClassLoader().getResource(iconName);
		ImageIcon icon = new ImageIcon(url);
		
		setIcons(icon, null, null);
		if (!paintFocus) setFocusPainted(false);
	}

	public PictButton(String iconName, String iconPressedName)
	{
		super();
		initButton(iconName, iconPressedName, null);
	}
	
	public PictButton(String iconName, String iconPressedName, String iconRolloverName)
	{
		super();
		initButton(iconName, iconPressedName, iconRolloverName);
	}
	
	public void initButton(String iconName, String iconPressedName, String iconRolloverName)
	{
		URL url = ClassLoader.getSystemClassLoader().getResource(iconName);
		ImageIcon icon1 = new ImageIcon(url);
		ImageIcon icon2, icon3;
		
		if (iconPressedName != null) {
			url = ClassLoader.getSystemClassLoader().getResource(iconPressedName);
			icon2 = new ImageIcon(url);
		}
		else icon2 = null;
		if (iconRolloverName != null) {
			url = ClassLoader.getSystemClassLoader().getResource(iconRolloverName);
			icon3 = new ImageIcon(url);
		}
		else icon3 = null;
		setIcons(icon1, icon2, icon3);
		setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
		setBorderPainted(false);
		setContentAreaFilled(false);
		setFocusPainted(false);
	}
	
	public void setIcons(ImageIcon icon1, ImageIcon icon2, ImageIcon icon3)
	{
		if (icon1 != null) setIcon(icon1);
		if (icon2 != null) setPressedIcon(icon2);
		if (icon3 != null) setRolloverIcon(icon3);
	}
	
}
