package termopl;

import java.io.*;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class SentenceParser 
{
	
	private Process process;
	private String python;
	private String parser;
	private String language;
	private String input;
	private String error;
	
	public SentenceParser(Preferences prefs, String input)
	{
		this.input = input;
		initParser(prefs);
	}

	public void initParser(Preferences prefs)
	{
		process = null;
		python = prefs.pythonPath;
		parser = TermoPL.appLocation + File.separator + "parse.py";
		language = prefs.language;
		error = null;
		
		File f = new File(parser);
		
		if (!f.exists()) {
			error = "Can't find parser.";
		}
		if (python == null) {
			if (!TermoPL.batchMode) {
				JFileChooser chooser = new JFileChooser();
				
				chooser.setDialogTitle("Choose Python Interpreter");
				chooser.setMultiSelectionEnabled(false);
				if (chooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
					File interp = chooser.getSelectedFile();
					python = interp.getPath();
					TermoPL.preferences.pythonPath = prefs.pythonPath = python;
				}
			}
			if (python == null) {
				String e = "Python interpreted not selected.";
				
				if (error == null) error = e;
				else error += " " + e;
			}
		}
	}
	
	public void run()
	{
		String cmd = python + " " + parser + " --language=" + language + " " + input;
		
		Runtime r = Runtime.getRuntime();
		
		try {
			error = null;
			process = r.exec(cmd);
			process.waitFor();
		} 
		catch (Exception e) {
			error = e.getMessage();
		}
	}
	
	public void cancel()
	{
		if (process != null) process.destroyForcibly();
	}
	
	public String getError()
	{
		return error;
	}

	public void report()
	{
		report(error);
	}
	
	public void report(String error)
	{
		if (TermoPL.batchMode) System.out.println(error);
		else {
			 Object[] options = { "Cancel" };
			
			 JOptionPane.showOptionDialog(null, error, "Error",
		             JOptionPane.DEFAULT_OPTION, JOptionPane.ERROR_MESSAGE,
		             null, options, options[0]);
		}
	}
	
	public boolean isParsed()
	{
		File file = new File(input);
		String parent = file.getAbsoluteFile().getParent();
		String name = file.getName();
		
		if (name.indexOf(".") > 0) name = name.substring(0, name.lastIndexOf("."));
		name += ".conllu";
		file = new File(parent + File.separator + name);
		return file.exists();
	}
	
}
