package termopl;

import java.awt.*;

public class WindowUtils 
{
	
	private static Point staggerPoint = null;
	private static final int OFFSET = 30;
	
	public static Rectangle getScreenRect()
	{
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Dimension dim = toolkit.getScreenSize();
		GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
		GraphicsConfiguration conf = dev.getDefaultConfiguration();
		Insets insets	= toolkit.getScreenInsets(conf);
		
		return new Rectangle(insets.left, 
							 insets.top, 
							 dim.width - insets.left - insets.right, 
							 dim.height - insets.top - insets.bottom);
	}
	
	public static Rectangle getDesktopRect()
	{
		if (TermoPL.isMacOS) return getScreenRect();
		return ((DefaultMasterFrame)(TermoPL.mainWindow)).getDesktopPane().getBounds();
	}
	
	public static void center(Component wnd, Rectangle rect)
	{	
		Rectangle crect = wnd.getBounds();
		
		wnd.setLocation(rect.x + (rect.width - crect.width) / 2,
						rect.y + (rect.height - crect.height) / 2);
	}
	
	public static void centerOnScreen(Component wnd)
	{
		center(wnd, getScreenRect());
	}
	
	public static void centerOnDesktop(Component wnd)
	{
		center(wnd, getDesktopRect());
	}
	
	public static void resetStaggerPoint()
	{
		staggerPoint = null;
	}
	
	public static void stagger(Component wnd, Rectangle rect)
	{
		Rectangle crect = wnd.getBounds();
		
		if (staggerPoint == null) staggerPoint = new Point(rect.x, rect.y);
		if (staggerPoint.x + crect.width > rect.x + rect.width || 
			staggerPoint.y + crect.height > rect.y + rect.height)
		{
			staggerPoint.setLocation(rect.x, rect.y);
		}
		wnd.setLocation(staggerPoint);
		staggerPoint.setLocation(staggerPoint.x + OFFSET, staggerPoint.y + OFFSET);
	}
	
	public static void staggerOnScreen(Component wnd)
	{
		stagger(wnd, getScreenRect());
	}
	
	public static void staggerOnDesktop(Component wnd)
	{
		stagger(wnd, getDesktopRect());
	}
	
	public static boolean isVisible(Component wnd, Rectangle rect)
	{
		Rectangle	crect = wnd.getBounds();
		
		return ((crect.x < rect.x + rect.width - OFFSET) &&
				(crect.y < rect.y + rect.height - OFFSET) &&
				(rect.x < crect.x + crect.width - OFFSET) &&
				(rect.y < crect.y + crect.height - OFFSET));
	}
	
	public static boolean isVisibleOnScreen(Component wnd)
	{
		return isVisible(wnd, getScreenRect());
	}
	
	public static boolean isVisibleOnDesktop(Component wnd)
	{
		return isVisible(wnd, getDesktopRect());
	}
	
	public static void reveal(Component wnd, Rectangle rect)
	{
		Rectangle crect = wnd.getBounds();
		
		if (crect.x + crect.width > rect.x + rect.width)
			crect.x = rect.x + rect.width - crect.width;
		if (crect.y + crect.height > rect.y + rect.height)
			crect.y = rect.y + rect.height - crect.height;
		if (crect.x < rect.x) crect.x = rect.x;
		if (crect.y < rect.y) crect.y = rect.y;
		wnd.setLocation(crect.x, crect.y);
	}
	
	public static void revealOnScreen(Component wnd)
	{
		reveal(wnd, getScreenRect());
	}
	
	public static void revealOnDesktop(Component wnd)
	{
		reveal(wnd, getDesktopRect());
	}
	
	public static void resizeToFit(Component wnd, Rectangle rect)
	{
	}
	
	public static void resizeToFitScreen(Component wnd)
	{
		resizeToFit(wnd, getScreenRect());
	}
	
	public static void resizeToFitDesktop(Component wnd)
	{
		resizeToFit(wnd, getDesktopRect());
	}
	
	public static void setCalculatedBounds(Component wnd, Rectangle bounds)
	{
		int	width, height;
		Dimension min = wnd.getMinimumSize();
		Dimension max = wnd.getMaximumSize();
		Rectangle rect = WindowUtils.getDesktopRect();
		
		width = 2 * rect.width / 3;
		height = 2 * rect.height / 3;
		if (width < 400) width = 400;
		if (height < 300) height = 300;
		
		if (min.width != 0 && width < min.width) width = min.width;
		if (max.width != 0 && width > max.width) width = max.width;
		
		if (min.height != 0 && height < min.height) height = min.height;
		if (max.height != 0 && height > max.height) height = max.height;
		
		bounds.setSize(width, height);
		wnd.setBounds(bounds);
	}
	
	public static void setBoundsRelativeToScreen(Component wnd, Rectangle bounds, boolean center)
	{
		if (!bounds.isEmpty()) {
			wnd.setBounds(bounds);
			if (!isVisibleOnScreen(wnd)) revealOnScreen(wnd);
		}
		else {
			setCalculatedBounds(wnd, bounds);
			if (center) centerOnScreen(wnd);
			else staggerOnScreen(wnd);
		}
	}
	
	public static void setBoundsRelativeToDesktop(Component wnd, Rectangle bounds, boolean center)
	{
		if (!bounds.isEmpty()) {
			wnd.setBounds(bounds);
			if (!isVisibleOnDesktop(wnd)) revealOnDesktop(wnd);
		}
		else {
			setCalculatedBounds(wnd, bounds);
			if (center) centerOnDesktop(wnd);
			else staggerOnDesktop(wnd);
		}
	}

}
