package termopl;

import java.awt.*;
import java.util.*;

public class WndLocation
{
	
	public int left, top;
	public float penalty;
	public static WndLocation bestLocation = null;

	public WndLocation(int left, int top, float penalty)
	{
		this.left = left;
		this.top = top;
		this.penalty = penalty;
	}
	
	public static boolean check(float[] f1, float[] f2)
	{
		float p1 = calcPenalty(f1),	p2 = calcPenalty(f2);
					
		if (p1 <= p2) return true;
		return false;
	}
	
	public static float calcPenalty(float[] f)
	{
		float penalty = 0.0F;
		
		for (int i = 0; i < f.length; i++) {
			if (f[i] > 0.9F) penalty += 4.0F * f[i];
			else if (f[i] > 0.8F) penalty += 3.5F * f[i];
			else if (f[i] > 0.7F) penalty += 3.0F * f[i];
			else if (f[i] > 0.6F) penalty += 2.5F * f[i];
			else if (f[i] > 0.5F) penalty += 2.0F * f[i];
			else if (f[i] > 0.4F) penalty += 1.5F * f[i];
			else penalty += f[i];
		}
		
		return penalty;
	}
	
	public static void cascade()
	{
		LinkedList<TermoPLWindow> list = TermoPL.zorder;
		
		if (list.size() > 1) {
			WindowUtils.resetStaggerPoint();
			for (TermoPLWindow wnd : list) {
				if (wnd.isVisible()) WindowUtils.staggerOnDesktop((Component)wnd);
			}
		}
	}
	
	public static void tile()
	{
		LinkedList<TermoPLWindow> list = TermoPL.zorder;
		
		if (list.size() > 1) {
			LinkedList<TermoPLWindow> moved = new LinkedList<TermoPLWindow>();
			
			for (TermoPLWindow wnd : list) {
				if (wnd.isVisible()) {
					if (moved.size() > 0) {
						for (TermoPLWindow w : moved) {
							findPosition(wnd, w);
						}
						WndLocation loc = findBestLocation();
						wnd.setLocation(loc.left, loc.top);
						bestLocation = null;
					}
					else {
						WindowUtils.resetStaggerPoint();
						WindowUtils.staggerOnDesktop((Component)wnd);
					}
					moved.add(wnd);
				}
			}
		}
	}

	public static void findPosition(TermoPLWindow frame, TermoPLWindow neighbour)
	{
		Rectangle nr = neighbour.getBounds(),
				  fr = frame.getBounds(),
				  dr = WindowUtils.getDesktopRect();
		int x, y;
		
		x = nr.x - fr.width - 1;
		if (x < dr.x) x = dr.x;
		findPosition(frame, x, nr.y);
		y = nr.y - fr.height - 1;
		if (y < dr.y) y = dr.y;
		findPosition(frame, nr.x, y);
		findPosition(frame, nr.x + nr.width + 1, nr.y);
		findPosition(frame, nr.x, nr.y + nr.height + 1);
	}
	
	public static void findPosition(TermoPLWindow frame, int x, int y)
	{
		LinkedList<TermoPLWindow> list = TermoPL.zorder;
		
		if (list.size() > 0) {
			Rectangle intersect, r, rect = frame.getBounds();
			float[] intersections;
			int i, size = 0;
			
			rect.setLocation(x, y);
			reveal(rect, WindowUtils.getDesktopRect());
			for (TermoPLWindow wnd : list) {
				if (wnd.isVisible()) {
					if (wnd == frame) break;
					size++;
				}
			}
			if (size > 0) {
				intersections = new float[size];
				i = 0;
				for (TermoPLWindow wnd : list) {
					if (wnd.isVisible()) {
						if (wnd == frame) break;
						r = wnd.getBounds();
						intersect = r.intersection(rect);
						if (intersect.isEmpty()) intersections[i++] = 0.0F;
						else intersections[i++] = (float)(intersect.width * intersect.height) / (float)(r.width * r.height);
					}
				}
				checkLocation(rect.x, rect.y, calcPenalty(intersections));
			}
		}
	}
	
	public static void checkLocation(int x, int y, float penalty)
	{
		if (bestLocation == null) bestLocation = new WndLocation(x, y, penalty);
		else if (bestLocation.left != x || bestLocation.top != y) {
			if (penalty < bestLocation.penalty) bestLocation = new WndLocation(x, y, penalty);
		}
	}
	
	public static void reveal(Rectangle rect, Rectangle desktop)
	{
		if (rect.x + rect.width > desktop.x + desktop.width)
			rect.x = desktop.x + desktop.width - rect.width;
		if (rect.y + rect.height > desktop.y + desktop.height)
			rect.y = desktop.y + desktop.height - rect.height;
		if (rect.x < desktop.x) rect.x = desktop.x;
		if (rect.y < desktop.y) rect.y = desktop.y;
	}
	
	public static WndLocation findBestLocation()
	{
		return bestLocation;
	}
	
}
