package termopl;

import java.io.Serializable;
import java.util.LinkedList;

@SuppressWarnings("serial")
public class WordReplacement implements Serializable
{
	
	public String word;
	public String expression;
	public LinkedList<Integer> relTypes;
	
	public WordReplacement(String word, String expression)
	{
		this.word = word;
		this.expression = expression;
		this.relTypes = null;
	}
	
	public WordReplacement(String word, String expression, int relType)
	{
		this.word = word;
		this.expression = expression;
		this.relTypes = null;
		add(relType);
	}
	
	public WordReplacement(String word, String expression, LinkedList<Integer> types)
	{
		this.word = word;
		this.expression = expression;
		this.relTypes = types;
	}
	
	public void add(int relType)
	{
		if (relType != WordNet.EXACT) {
			if (relTypes == null) {
				relTypes = new LinkedList<Integer>();
				relTypes.add(relType);
			}
			else if (!relTypes.contains(relType)) relTypes.add(relType);
		}
	}
	
	public void addAll(LinkedList<Integer> types)
	{
		for (Integer relType : types) add(relType);
	}
	
	public int length()
	{
		if (expression.contains(" ")) return expression.split(" ").length;
		return 1;
	}
	
	public static void addReplacement(String word, String expr, int relType, LinkedList<WordReplacement> relatedWords)
	{
		if (relType != WordNet.EXACT) {
			for (WordReplacement wr : relatedWords) {
				if (word.equals(wr.word) && expr.equals(wr.expression)) {
					wr.add(relType);
					return;
				}
			}
		}
		relatedWords.add(new WordReplacement(word, expr, relType));
	}
	
	public static void addReplacement(String word, String expr, LinkedList<Integer> types, LinkedList<WordReplacement> relatedWords)
	{
		for (WordReplacement wr : relatedWords) {
			if (word.equals(wr.word) && expr.equals(wr.expression)) {
				wr.addAll(types);
				return;
			}
		}
		relatedWords.add(new WordReplacement(word, expr, types));
	}
	
	public static LinkedList<String> words(LinkedList<WordReplacement> relatedWords)
	{
		LinkedList<String> words = new LinkedList<String>();
		
		if (relatedWords != null) {
			for (WordReplacement wr : relatedWords) {
				if (wr.expression.contains(" ")) {
					String[] str = wr.expression.split(" ");
					
					for (String s : str) words.add(s);
				}
				else words.add(wr.expression);
			}
		}
		return words;
	}

}
