package pl.waw.ipipan.zil.core.textSelector;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class Mimic {

	private static final String HEADER = "header.xml";
//	private static final Pattern p = Pattern.compile("target=\"([^\"]*)\"");
	private static final Logger logger = Logger.getLogger(Mimic.class);

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if (args.length != 2) {
			logger.error("Wrong usage! Try: java -jar " + Mimic.class.getSimpleName() + " dirWithTexts dirWithRejects");
			return;
		}

		File dirWithTexts = new File(args[0]);
		File dirWithRejects = new File(args[1]);

		if (!dirWithTexts.exists()) {
			logger.error("Directory doesn't exist!");
			return;
		}

		if (!dirWithRejects.exists()) {
			logger.error("Directory doesn't exist!");
			return;
		}

		List<File> texts = recFindTexts(dirWithTexts);
		List<File> rejects = recFindTexts(dirWithRejects);

		Set<String> rejected = new HashSet<String>();
		for (File f : rejects)
			rejected.add(f.getParentFile().getName());

		for (File header : texts) {
			try {
				if (rejected.contains(header.getParentFile().getName())) {
					logger.info("Deleting dir " + header.getParentFile());
					FileUtils.deleteDirectory(header.getParentFile());
				}
			} catch (IOException e) {
				logger.error("Error moving " + e.getLocalizedMessage());
			}
		}

	}

	// private static String getTextType(File header) {
	// try {
	// BufferedReader br = new BufferedReader(new FileReader(header));
	// String line = null;
	// while ((line = br.readLine()) != null) {
	// if (line.contains("taxonomy-CORE")) {
	// Matcher matcher = p.matcher(line);
	// if (matcher.find())
	// return matcher.group(1);
	// }
	// }
	// } catch (IOException e) {
	// logger.error("Error reading file: " + header);
	// }
	// return null;
	// }

	private static List<File> recFindTexts(File dirWithTexts) {
		List<File> result = new ArrayList<File>();

		List<File> files = new ArrayList<File>(Arrays.asList(dirWithTexts.listFiles()));
		Collections.sort(files);
		for (File f : files) {
			if (f.isDirectory())
				result.addAll(recFindTexts(f));
			else if (f.getName().matches(HEADER)) {
				result.add(f);
				break;
			}
		}
		return result;
	}

}
