package pl.waw.ipipan.zil.core.textSelector;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class TextSorter {

	private static final String HEADER = "header.xml";
	private static final Pattern p = Pattern.compile("target=\"([^\"]*)\"");
	private static final Logger logger = Logger.getLogger(TextSorter.class);

	/**
	 * @param args
	 */
	public static void main(String[] args) {

		if (args.length != 1) {
			logger.error("Wrong usage! Try: java -jar "
					+ TextSorter.class.getSimpleName() + " dirWithTexts");
			return;
		}

		File dirWithTexts = new File(args[0]);

		if (!dirWithTexts.exists()) {
			logger.error("Directory doesn't exist!");
			return;
		}

		List<File> texts = recFindTexts(dirWithTexts);

		for (File header : texts) {
			String type = getTextType(header);
			File dirForType = new File(dirWithTexts + File.separator
					+ type.replaceAll(" ", "_"));
			try {
				logger.info("Moving " + header.getParentFile() + " to "
						+ dirForType);
				FileUtils.moveDirectoryToDirectory(header.getParentFile(),
						dirForType, true);
			} catch (IOException e) {
				logger.error("Error moving " + e.getLocalizedMessage());
			}
		}

	}

	private static String getTextType(File header) {
		try {
			BufferedReader br = new BufferedReader(new FileReader(header));
			String line = null;
			while ((line = br.readLine()) != null) {
				if (line.contains("taxonomy-CORE")) {
					Matcher matcher = p.matcher(line);
					if (matcher.find()) {
						br.close();
						return matcher.group(1);
					}
				}
			}
			br.close();
		} catch (IOException e) {
			logger.error("Error reading file: " + header);
		}
		return null;
	}

	private static List<File> recFindTexts(File dirWithTexts) {
		List<File> result = new ArrayList<File>();

		List<File> files = new ArrayList<File>(Arrays.asList(dirWithTexts
				.listFiles()));
		Collections.sort(files);
		for (File f : files) {
			if (f.isDirectory())
				result.addAll(recFindTexts(f));
			else if (f.getName().matches(HEADER)) {
				result.add(f);
				break;
			}
		}
		return result;
	}

}
