package pl.waw.ipipan.zil.core.textSelector;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.log4j.Logger;
import org.codehaus.stax2.XMLInputFactory2;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlIO {

	private static final Logger logger = Logger.getLogger(XmlIO.class);

	private static final XMLInputFactory xif = XMLInputFactory2.newInstance();

	public static String loadText(File input) {
		logger.info("Loading text from file: " + input);

		StringBuffer result = new StringBuffer();

		InputStream is = null;
		XMLStreamReader sr = null;
		try {
			is = new FileInputStream(input);
			sr = xif.createXMLStreamReader(is);
			boolean inP = false;

			while (sr.hasNext()) {
				sr.next();

				if (sr.isStartElement()) {
					String name = sr.getName().getLocalPart();
					if (name.equals("p")) {
						inP = true;
					}
				} else if (sr.isEndElement()) {
					String name = sr.getName().getLocalPart();
					if (name.equals("p")) {
						inP = false;
						result.append("\n\n");
					}
				} else if (sr.isWhiteSpace()) {

				} else if (sr.isCharacters()) {
					if (inP)
						result.append(sr.getText());
				}
			}
		} catch (Exception e) {
			logger.error("Error reading file: " + input + " Details: "
					+ e.getLocalizedMessage());
		} finally {
			try {
				if (is != null)
					is.close();
				if (sr != null)
					sr.close();
			} catch (Exception e) {
				logger.error("Error closing file: " + input + " Details: "
						+ e.getLocalizedMessage());
			}
		}

		return result.toString();
	}

	public static void saveText(File file, String[] pars) {
		logger.info("Saving changes in file " + file);
		try {
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
			Document doc = dBuilder.parse(file);

			// remove all body children
			Node body = doc.getElementsByTagName("body").item(0);

			body.getParentNode().removeChild(body.getPreviousSibling());

			NodeList nl = body.getChildNodes();
			int l = nl.getLength();
			for (int i = 0; i < l; i++)
				body.removeChild(nl.item(0));

			// create new pars
			int i = 1;
			for (String par : pars) {
				Element p = doc.createElement("p");
				p.setAttribute("xml:id", "p-" + i++);
				p.setTextContent(par);
				body.appendChild(p);
			}

			// Prepare the DOM document for writing
			Source source = new DOMSource(doc);

			// Prepare the output file
			Result result = new StreamResult(file);

			// Write the DOM document to the file
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer xformer = factory.newTransformer();
			xformer.setOutputProperty(OutputKeys.INDENT, "yes");
			xformer.setOutputProperty(
					"{http://xml.apache.org/xslt}indent-amount", "2");
			xformer.transform(source, result);

		} catch (Exception e) {
			logger.error("Error saving text:" + e.getLocalizedMessage());
		}

	}
}
