/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.util.Collections;
import java.util.Vector;

public class EvaluationResult {
    int correctCounter = 0;
    int errorCounter = 0;
    boolean interrupted;
    Vector<Integer> ids;
    Vector<String> kwics = new Vector();
    Vector<String> predictions = new Vector();
    Vector<String> senses = new Vector();
    private long timeStarted;
    private long timeStopped;

    public EvaluationResult() {
        this.ids = new Vector();
    }

    public void add(int contextId, String contextRepresentation, String predictedSense, String sense) {
        this.add(predictedSense.equalsIgnoreCase(sense));
        this.kwics.add(contextRepresentation);
        this.predictions.add(predictedSense);
        this.senses.add(sense);
        this.ids.add(contextId);
    }

    public void addCVFold() {
        this.kwics.add("CVFOLD");
        this.predictions.add("");
        this.senses.add("");
        this.ids.add(0);
    }

    public void add(boolean correct) {
        if (correct) {
            ++this.correctCounter;
        } else {
            ++this.errorCounter;
        }
    }

    public double getResult() {
        if (this.interrupted) {
            return 0.0;
        }
        return 1.0 * (double)this.correctCounter / (double)(this.correctCounter + this.errorCounter);
    }

    public String detailedResults() {
        if (this.interrupted) {
            return "INTERRUPTED";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.correctCounter);
        sb.append('/');
        sb.append(this.correctCounter + this.errorCounter);
        sb.append('(');
        sb.append(1.0 * (double)this.correctCounter / (double)(this.correctCounter + this.errorCounter));
        sb.append(')');
        sb.append("\nerrors: ");
        Vector<Integer> errors = new Vector<Integer>();
        int i = 0;
        while (i < this.kwics.size()) {
            if (!this.predictions.get(i).equals(this.senses.get(i))) {
                errors.add(this.ids.get(i));
            }
            ++i;
        }
        Collections.sort(errors);
        for (Integer integer : errors) {
            sb.append(integer);
            sb.append(", ");
        }
        sb.append("\n*******************************\n");
        return sb.toString();
    }

    public void interrupted() {
        this.interrupted = true;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    public void timeStart() {
        this.timeStarted = System.nanoTime();
    }

    public void timeStop() {
        this.timeStopped = System.nanoTime();
    }

    public long getElapssedTime() {
        return (int)((this.timeStopped - this.timeStarted) / 1000000L);
    }

    public String getErrors() {
        StringBuffer sb = new StringBuffer();
        Vector<Integer> errors = new Vector<Integer>();
        int i = 0;
        while (i < this.kwics.size()) {
            if (!this.predictions.get(i).equals(this.senses.get(i))) {
                errors.add(this.ids.get(i));
            }
            ++i;
        }
        Collections.sort(errors);
        for (Integer integer : errors) {
            sb.append(integer);
            sb.append(" ");
        }
        return sb.toString().trim();
    }
}

