/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.util.Vector;
import org.w3c.dom.Element;
import weka.classifiers.Classifier;
import weka.filters.Filter;
import wsdde.EvaluationResult;
import wsdde.WEKALoader;
import wsdde.WSDExperiment;
import wsdde.WSDMethodResultRow;
import wsdde.WSDModel;
import wsdde.corpus.WSDCorpus;
import wsdde.general.Utils;
import wsdde.generator.FeatureGenerator;

public class WSDMethod
extends Vector<FeatureGenerator>
implements Runnable {
    private static final long serialVersionUID = -1455331906805868042L;
    String id;
    String ml;
    String sa;
    int maxExecutionTimeMs = 10000000;
    Classifier classifier = null;
    Filter filter = null;
    String trainingSetName;
    String testSetName;
    private int cvFold;
    private boolean isCV;
    WSDCorpus trainingSet;
    WSDCorpus testSet;
    WSDExperiment wsdexp;
    public EvaluationResult results;
    private Element wsdMethodXml;
    private boolean writeModels = false;
    private WSDMethodResultRow wsdmrr = null;

    public WSDMethod(Element wsdMethodXml, WSDExperiment wsdexp) {
        this.wsdexp = wsdexp;
        this.wsdMethodXml = wsdMethodXml;
        Element fgsEl = (Element)wsdMethodXml.getElementsByTagName("feature_generators").item(0);
        Vector<Element> v = Utils.getChildElementsVector(fgsEl);
        for (Element fg : v) {
            this.add(FeatureGenerator.getGenerator(fg));
        }
        this.id = wsdMethodXml.getAttribute("id");
        if (wsdMethodXml.hasAttribute("max_method_time")) {
            this.maxExecutionTimeMs = Integer.parseInt(wsdMethodXml.getAttribute("max_method_time"));
        }
        this.ml = ((Element)wsdMethodXml.getElementsByTagName("machine_learning").item(0)).getTextContent();
        this.sa = ((Element)wsdMethodXml.getElementsByTagName("selection").item(0)).getTextContent();
        this.ml = ((Element)wsdMethodXml.getElementsByTagName("machine_learning").item(0)).getTextContent();
        if (wsdMethodXml.getElementsByTagName("cv").getLength() > 0) {
            this.isCV = true;
            this.cvFold = Integer.parseInt(((Element)wsdMethodXml.getElementsByTagName("cv").item(0)).getAttribute("fold"));
            this.trainingSetName = ((Element)wsdMethodXml.getElementsByTagName("cv").item(0)).getTextContent();
        } else {
            this.trainingSetName = ((Element)wsdMethodXml.getElementsByTagName("training").item(0)).getTextContent();
            this.testSetName = ((Element)wsdMethodXml.getElementsByTagName("test").item(0)).getTextContent();
        }
    }

    public void initDBRow() {
        this.wsdmrr = new WSDMethodResultRow(this.wsdMethodXml, this.wsdexp.dbh);
    }

    public void setSaveModels(boolean bool) {
        this.writeModels = bool;
    }

    public void loadCorpora() {
        this.trainingSet = WSDCorpus.getCorpus(this.trainingSetName);
        if (!this.isCV) {
            this.testSet = WSDCorpus.getCorpus(this.testSetName);
        }
    }

    @Override
    public void run() {
        this.filter = WEKALoader.filter(this.sa);
        this.classifier = WEKALoader.classifier(this.ml);
        this.results = new EvaluationResult();
        this.results.timeStart();
        this.trainingSet = WSDCorpus.getCorpus(this.trainingSetName);
        if (this.isCV) {
            Vector<WSDCorpus> folds = this.trainingSet.splitInto(this.cvFold);
            int i = 0;
            while (i < folds.size()) {
                WSDCorpus cvTrainSet = new WSDCorpus(null);
                WSDCorpus cvTestSet = new WSDCorpus(null);
                int j = 0;
                while (j < folds.size()) {
                    if (i == j) {
                        cvTestSet.addCorpus(folds.get(j));
                    } else {
                        cvTrainSet.addCorpus(folds.get(j));
                    }
                    ++j;
                }
                WSDModel model = new WSDModel(cvTrainSet, this);
                model.classify(cvTestSet, this.results, false);
                this.results.addCVFold();
                if (this.writeModels) {
                    this.trainingSet = WSDCorpus.getCorpus(this.trainingSetName);
                    model = new WSDModel(cvTrainSet, this);
                    model.saveModel(String.valueOf(this.id) + ".wsdmeth");
                }
                ++i;
            }
        } else {
            this.testSet = WSDCorpus.getCorpus(this.testSetName);
            WSDModel model = new WSDModel(this.trainingSet, this);
            model.classify(this.testSet, this.results, false);
            if (this.writeModels) {
                model.saveModel(String.valueOf(this.id) + ".wsdmeth");
            }
        }
        this.results.timeStop();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (FeatureGenerator fg : this) {
            sb.append(fg.id());
            sb.append(": ");
            sb.append(fg.parameters);
            sb.append('\n');
        }
        sb.append('\n');
        sb.append(this.sa);
        sb.append('\n');
        sb.append(this.ml);
        return sb.toString();
    }

    public static void main(String[] args) {
    }

    public void cleanAfterStop() {
        if (this.trainingSet != null) {
            this.trainingSet.clear();
        }
        if (this.testSet != null) {
            this.testSet.clear();
        }
        if (this.results != null) {
            this.results.interrupted();
        }
        if (this.results != null) {
            this.results.timeStop();
        }
    }

    public void pushOKData() {
        Element score = this.wsdMethodXml.getOwnerDocument().createElement("result");
        score.setTextContent("" + this.results.getResult());
        this.wsdMethodXml.appendChild(score);
        Element time = this.wsdMethodXml.getOwnerDocument().createElement("time_elapsed_ms");
        time.setTextContent("" + this.results.getElapssedTime());
        this.wsdMethodXml.appendChild(time);
        Element errors = this.wsdMethodXml.getOwnerDocument().createElement("errors");
        errors.setTextContent(this.results.getErrors());
        this.wsdMethodXml.appendChild(errors);
        if (this.results.interrupted) {
            Element interrupted = this.wsdMethodXml.getOwnerDocument().createElement("interrupted");
            this.wsdMethodXml.appendChild(interrupted);
        }
        if (this.wsdexp.toDB) {
            this.wsdmrr.setResult(this.results.getResult());
            this.wsdmrr.insertRow();
        }
    }
}

