/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.Filter;
import wsdde.Counter;
import wsdde.EvaluationResult;
import wsdde.WSDMethod;
import wsdde.corpus.KWIC;
import wsdde.corpus.WSDCorpus;
import wsdde.generator.FeatureGenerator;

public class WSDModel
implements Serializable {
    private static final long serialVersionUID = 4329550140737387953L;
    HashMap<String, FeatureGenerator> whichGenerator;
    Counter selectedFeatures;
    FastVector senses;
    Vector<FeatureGenerator> fgs = new Vector();
    Classifier classifier;

    public void saveModel(String filename) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(filename);
            out = new ObjectOutputStream(fos);
            out.writeObject(this);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static WSDModel loadModel(String filename) {
        WSDModel wsdmodel = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(filename);
            in = new ObjectInputStream(fis);
            wsdmodel = (WSDModel)in.readObject();
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return wsdmodel;
    }

    public WSDModel(WSDCorpus trainingSet, WSDMethod settings) {
        for (FeatureGenerator featureGenerator : settings) {
            this.fgs.add(featureGenerator);
        }
        trainingSet.generateFeatures(this.fgs);
        trainingSet.computeMainCounter();
        trainingSet.sensesFromKWICS();
        Instances data = trainingSet.toWeka();
        if (settings.filter != null) {
            try {
                settings.filter.setInputFormat(data);
                data = Filter.useFilter(data, settings.filter);
            }
            catch (Exception exception) {
                // empty catch block
            }
            data.setClassIndex(data.numAttributes() - 1);
            this.selectedFeatures = new Counter();
            int i = 0;
            while (i < data.numAttributes() - 1) {
                this.selectedFeatures.put(data.attribute(i).name(), (Integer)trainingSet.counter.get(data.attribute(i).name()));
                ++i;
            }
        }
        this.whichGenerator = trainingSet.whichGenerator;
        this.senses = trainingSet.senses;
        trainingSet.clear();
        this.classifier = settings.classifier;
        try {
            this.classifier.buildClassifier(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void classify(WSDCorpus testSet, EvaluationResult results, boolean save) {
        testSet.generateFeatures(this.fgs);
        testSet.whichGenerator = this.whichGenerator;
        testSet.setSenses(this.senses);
        testSet.setMainCounter(this.selectedFeatures);
        Instances testData = testSet.toWeka();
        testData.setClassIndex(testData.numAttributes() - 1);
        boolean correct = false;
        int j = 0;
        while (j < testData.numInstances()) {
            try {
                ((KWIC)testSet.get((int)j)).predictedSense = "" + testSet.senses.elementAt((int)this.classifier.classifyInstance(testData.instance(j)));
                results.add(((KWIC)testSet.get((int)j)).kwicID, ((KWIC)testSet.get(j)).toHumanString(), ((KWIC)testSet.get((int)j)).predictedSense, ((KWIC)testSet.get((int)j)).sense);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
        if (save) {
            WSDCorpus.saveTXT(testSet, testSet.corpusName);
            System.out.println(results.getResult());
            System.out.println(results.detailedResults());
        }
        testSet.clear();
    }
}

