/*
 * Decompiled with CFR 0.152.
 */
package wsdde.corpus.knowledge;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import wsdde.corpus.WSDCorpus;
import wsdde.corpus.knowledge.KnowledgeSource;
import wsdde.corpus.knowledge.TakipiXMLParser;
import wsdde.general.Config;

public class TAKIPIManager
extends KnowledgeSource {
    public static final String takipiEncoding = "-UTF";

    @Override
    public WSDCorpus enrich(String filename) {
        TAKIPIManager.takipi(filename);
        return TAKIPIManager.read(String.valueOf(filename) + ".takipized");
    }

    public static WSDCorpus read(String filename) {
        TakipiXMLParser parser = new TakipiXMLParser();
        return parser.parse(filename);
    }

    public static void takipi(String filename) {
        String meta = "";
        try {
            meta = new File(filename).getCanonicalPath();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        ProcessBuilder pb = new ProcessBuilder(Config.Settings.TAKIPI_BIN.value(), "-i", meta, "-o", String.valueOf(meta) + ".takipized", takipiEncoding, "-TXT");
        Map<String, String> env = pb.environment();
        if (Config.Settings.TAKIPI_BIN.value().endsWith(".exe")) {
            try {
                pb.directory(new File(Config.Settings.TAKIPI_BIN.value()).getParentFile().getCanonicalFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        pb.redirectErrorStream(true);
        try {
            Process p = pb.start();
            InputStream is = p.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr, 100);
            try {
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        System.out.println(line);
                    }
                }
                catch (EOFException eOFException) {
                    // empty catch block
                }
                br.close();
            }
            catch (IOException e) {
                System.err.println("problem reading spawn output" + e.getMessage());
                System.exit(1);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        WSDCorpus w = new TAKIPIManager().enrich("powod.xml");
        WSDCorpus.saveTXT(w, "takipi.wsdc");
    }
}

