/*
 * Decompiled with CFR 0.152.
 */
package wsdde.generator;

import java.util.HashMap;
import java.util.Random;
import org.w3c.dom.Element;
import wsdde.corpus.ContextInfo;
import wsdde.corpus.KWIC;
import wsdde.corpus.WSDCorpus;
import wsdde.generator.FeatureGenerator;

public class TFG
extends FeatureGenerator {
    int windowSize;
    int lemmatisation;

    public TFG(Element featureGeneratorElement) {
        super(featureGeneratorElement);
    }

    public TFG(HashMap<String, String> parameters) {
        super(parameters);
    }

    public TFG() {
    }

    @Override
    public void prepareParams() {
        this.windowSize = Integer.parseInt(this.getParam("window_size"));
        this.lemmatisation = Integer.parseInt(this.getParam("lemmatisation"));
    }

    public static String description() {
        return "TFG = bag-of-words)";
    }

    @Override
    public void generate(WSDCorpus contexts) {
        for (KWIC kwic : contexts) {
            int i = -this.windowSize;
            while (i <= this.windowSize) {
                if (i != 0) {
                    ContextInfo info;
                    if (this.lemmatisation > 0) {
                        info = kwic.getInfo("lemmas", i);
                        if (info != null) {
                            this.feature(contexts, kwic, info.toString());
                        }
                    } else {
                        info = kwic.getInfo("words", i);
                        if (info != null) {
                            this.feature(contexts, kwic, info.toString());
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String id() {
        return "TFG";
    }

    @Override
    public HashMap<String, String> changeParam() {
        HashMap<String, String> hm = new HashMap<String, String>(this.parameters);
        if (Math.random() < 0.5) {
            hm.put("lemmatisation", String.valueOf(1 - this.lemmatisation));
        } else {
            Random r = new Random();
            hm.put("window_size", String.valueOf(Math.abs(this.windowSize + r.nextInt(10) - 2)));
        }
        return hm;
    }
}

