/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import wsdde.EvaluationResult;
import wsdde.ExperimentDescription;
import wsdde.WSDExperiment;
import wsdde.WSDModel;
import wsdde.corpus.Pseudowords;
import wsdde.corpus.WSDCorpus;
import wsdde.corpus.knowledge.KnowledgeSource;
import wsdde.corpus.knowledge.SimpleTokenizerManager;
import wsdde.corpus.knowledge.TAKIPIManager;
import wsdde.general.Utils;
import wsdde.general.XML;

public class WSDDE {
    public static LinkedHashMap<String, Options> hm = new LinkedHashMap();
    public static Options opt;

    public static String[] coe() {
        String[] args = new String[]{"-coe", "-i", "desc.xml", "-db"};
        return args;
    }

    public static String[] gmd() {
        String[] args = new String[]{"-gmd", "-i", "meta2.xml", "-o", "desc2.xml"};
        return args;
    }

    public static String[] xsd() {
        String[] args = new String[]{"-xsd", "-o", ".xsd"};
        return args;
    }

    public static void main(String[] args) {
        opt = new Options();
        OptionGroup bins = new OptionGroup();
        bins.addOption(new Option("pws", "Use the 'pws' option to generate a pseudowords corpus"));
        bins.addOption(new Option("enr", "Use the 'enr' option to enrich a wsd corpus using knowledge source(s) (in the current version only with segmentation, base forms and POSs using TAKIPI or a simple tokenizer)"));
        bins.addOption(new Option("spl", "Use the 'spl' option to random split an enriched corpus into smaller corpora"));
        bins.addOption(new Option("xsd", "Use the 'xsd' option to show XML definitions"));
        bins.addOption(new Option("gmd", "Use the 'gmd' option to generate an experiment's description from the meta-description"));
        bins.addOption(new Option("coe", "Use the 'coe' option to carry out an experiment"));
        bins.addOption(new Option("clu", "Use the 'clu' option to load built WSD method from the file and use it"));
        bins.setRequired(true);
        opt.addOptionGroup(bins);
        Options os = new Options();
        OptionBuilder.withArgName("word1=count1 [wordn=countn]");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(' ');
        Option o = OptionBuilder.create("wc");
        o.setDescription("pair(s) of a word and its number of occurences");
        o.setRequired(true);
        os.addOption(o);
        o = new Option("o", true, "output file; if not set, default file name is used (word1[-wordn].xml) ");
        o.setRequired(false);
        o.setArgName("outputfile");
        os.addOption(o);
        hm.put("pws", os);
        os = new Options();
        o = new Option("i", true, "input file");
        o.setRequired(true);
        o.setArgName("inputfile");
        os.addOption(o);
        o = new Option("o", true, "output file; if not set, default file name is used (inputfile_enr.xml)");
        o.setRequired(false);
        o.setArgName("outputfile");
        os.addOption(o);
        OptionGroup enrichers = new OptionGroup();
        enrichers.addOption(new Option("takipi", "enrich wsd corpus with segmentation, base forms and POSs, needs TAKIPI"));
        enrichers.addOption(new Option("simple", "enrich wsd corpus with the simple segmentation and stemming"));
        enrichers.setRequired(true);
        os.addOptionGroup(enrichers);
        hm.put("enr", os);
        os = new Options();
        OptionBuilder.withArgName("size1 [sizen]");
        OptionBuilder.hasArgs();
        OptionBuilder.withValueSeparator(' ');
        o = OptionBuilder.create("ss");
        o.setDescription("list of the sizes (number of examples) of corporas; the sum must be smaller than the number of contexts in the corpus; only corpora in 'enriched' (noXML) could be split");
        o.setRequired(true);
        os.addOption(o);
        o = new Option("i", true, "corpus to split");
        o.setRequired(true);
        o.setArgName("inputfile");
        os.addOption(o);
        o = new Option("p", true, "common prefix for splitted corpora filenames; if not set, inputfile is used");
        o.setRequired(false);
        o.setArgName("prefix");
        os.addOption(o);
        hm.put("spl", os);
        os = new Options();
        o = new Option("o", true, "output file postfix, it will be prefixed with 'desc_' and '_meta' for schema for an experiment's description and meta description respectively; if not set, schemas are printed on the screen.");
        o.setRequired(false);
        o.setArgName("outputfile");
        os.addOption(o);
        hm.put("xsd", os);
        os = new Options();
        o = new Option("i", true, "input file with a meta description of the experiment");
        o.setRequired(true);
        o.setArgName("inputfile");
        os.addOption(o);
        o = new Option("o", true, "output file where description of the experiment should be saved, if not set, default name is used (inputfile_desc.xml)");
        o.setRequired(false);
        o.setArgName("outputfile");
        os.addOption(o);
        hm.put("gmd", os);
        os = new Options();
        o = new Option("i", true, "input file is an xml description of the experiment");
        o.setRequired(true);
        o.setArgName("inputfile");
        os.addOption(o);
        o = new Option("o", true, "output file for xml results");
        o.setRequired(false);
        o.setArgName("outputfile");
        os.addOption(o);
        o = new Option("db", false, "save to the database");
        o.setRequired(false);
        os.addOption(o);
        o = new Option("sm", false, "save built wsd methods as well; if a method is evaluated with CV, then the saved model is the new one built on ALL examples");
        o.setRequired(false);
        os.addOption(o);
        hm.put("coe", os);
        os = new Options();
        o = new Option("m", true, "file with a WSD method to load");
        o.setRequired(true);
        o.setArgName("WSDmethod");
        os.addOption(o);
        o = new Option("c", true, "file with a corpus to be classified");
        o.setRequired(true);
        o.setArgName("corpus");
        os.addOption(o);
        o = new Option("o", true, "output file for the classified corpus; if empty, inputfile is overwritten");
        o.setRequired(false);
        o.setArgName("filename");
        os.addOption(o);
        hm.put("clu", os);
        if (args.length < 1) {
            WSDDE.usages();
            System.exit(0);
        }
        String[] command = new String[]{args[0]};
        BasicParser parser = new BasicParser();
        CommandLine cl = null;
        try {
            cl = parser.parse(opt, command);
        }
        catch (Exception e) {
            System.out.println("Parsing failed.  Reason: " + e.getMessage() + "\n");
            WSDDE.usages();
            System.exit(0);
        }
        command[0] = cl.getOptions()[0].getOpt();
        String[] comargs = new String[args.length - 1];
        int i = 1;
        while (i < args.length) {
            comargs[i - 1] = args[i];
            ++i;
        }
        try {
            String outputfile;
            String inputfile;
            CommandLine clargs = parser.parse(hm.get(command[0]), comargs);
            if (cl.hasOption("pws")) {
                Vector<String> ws = new Vector<String>();
                Vector<Integer> cs = new Vector<Integer>();
                String[] stringArray = clargs.getOptionValues("wc");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String word = string.substring(0, string.indexOf(61));
                    int count = Integer.parseInt(string.substring(string.indexOf(61) + 1));
                    ws.add(word);
                    cs.add(count);
                    ++n2;
                }
                int[] counts = new int[cs.size()];
                StringBuffer pseudoword = new StringBuffer();
                int i2 = 0;
                while (i2 < cs.size()) {
                    counts[i2] = (Integer)cs.get(i2);
                    pseudoword.append((String)ws.get(i2));
                    ++i2;
                }
                pseudoword.append(".xml");
                String filename = clargs.getOptionValue("o", pseudoword.toString());
                String pwcorp = Pseudowords.getPseudowordsCorpus(ws.toArray(new String[0]), counts);
                Utils.saveInFile(pwcorp, filename);
                System.exit(0);
            }
            if (cl.hasOption("enr")) {
                inputfile = clargs.getOptionValue("i");
                outputfile = String.valueOf(inputfile) + "_enr.xml";
                if (clargs.hasOption("o")) {
                    outputfile = clargs.getOptionValue("o");
                }
                KnowledgeSource ks = clargs.hasOption("takipi") ? new TAKIPIManager() : new SimpleTokenizerManager();
                ks.enrichAndSave(inputfile, outputfile);
                System.exit(0);
            }
            if (cl.hasOption("spl")) {
                Vector cs = new Vector();
                int[] split = new int[clargs.getOptionValues("ss").length];
                int i3 = 0;
                while (i3 < split.length) {
                    split[i3] = Integer.parseInt(clargs.getOptionValues("ss")[i3]);
                    ++i3;
                }
                String inputfile2 = clargs.getOptionValue("i");
                WSDCorpus toSplit = WSDCorpus.loadTXT(inputfile2);
                Vector<WSDCorpus> ws = toSplit.exactlySplit(split);
                if (clargs.hasOption("p")) {
                    inputfile2 = clargs.getOptionValue("p");
                }
                int i4 = 0;
                while (i4 < ws.size()) {
                    WSDCorpus.saveTXT(ws.get(i4), String.valueOf(inputfile2) + "_" + i4 + ".wsdc");
                    ++i4;
                }
                System.exit(0);
            }
            if (cl.hasOption("xsd")) {
                if (clargs.hasOption("o")) {
                    String outputfile2 = clargs.getOptionValue("o");
                    Utils.saveInFile(XML.getDescXSD(), "desc_" + outputfile2);
                    Utils.saveInFile(XML.getMetaDescXSD(), "meta_" + outputfile2);
                    Utils.saveInFile(XML.getMetaDBDescXSD(), "meta_db_" + outputfile2);
                } else {
                    System.out.println("EXPERIMENT'S DESCRIPTION\n\n" + XML.getDescXSD() + "\nMETA DESCRIPTION FROM PARAMETERS\n\n" + XML.getMetaDescXSD() + "\n\nMETA DESCRIPTION FROM DB\n" + XML.getMetaDBDescXSD());
                }
                System.exit(0);
            }
            if (cl.hasOption("gmd")) {
                String outputXml;
                inputfile = clargs.getOptionValue("i");
                outputfile = String.valueOf(inputfile) + "_desc.xml";
                if (clargs.hasOption("o")) {
                    outputfile = clargs.getOptionValue("o");
                }
                boolean wyj1 = false;
                boolean wyj2 = false;
                String error1 = "";
                String error2 = "";
                try {
                    if (XML.validateXSD(XML.getMetaDescXSD(), inputfile)) {
                        outputXml = ExperimentDescription.getXMLFromMetaDescription(inputfile);
                        Utils.saveInFile(outputXml, outputfile);
                    }
                }
                catch (Exception e) {
                    wyj1 = true;
                    error1 = e.getMessage();
                }
                try {
                    if (XML.validateXSD(XML.getMetaDBDescXSD(), inputfile)) {
                        outputXml = ExperimentDescription.getNewExperimentDBDescritpionFromXMLFile(inputfile);
                        Utils.saveInFile(outputXml, outputfile);
                    }
                }
                catch (Exception e) {
                    wyj2 = true;
                    error2 = e.getMessage();
                }
                if (wyj1 && wyj2) {
                    System.out.println(String.valueOf(error1) + "\n\nOR\n\n" + error2);
                }
                System.exit(0);
            }
            if (cl.hasOption("coe")) {
                inputfile = clargs.getOptionValue("i");
                outputfile = String.valueOf(inputfile) + "_res.xml";
                if (clargs.hasOption("o")) {
                    outputfile = clargs.getOptionValue("o");
                }
                try {
                    if (XML.validateXSD(XML.getDescXSD(), inputfile)) {
                        WSDExperiment wsde = new WSDExperiment(inputfile);
                        wsde.writeToDB(clargs.hasOption("db"));
                        wsde.saveModels = clargs.hasOption("sm");
                        String outputXml = wsde.conduct();
                        Utils.saveInFile(outputXml, outputfile);
                    }
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                System.exit(0);
            }
            if (cl.hasOption("clu")) {
                outputfile = inputfile = clargs.getOptionValue("c");
                if (clargs.hasOption("o")) {
                    outputfile = clargs.getOptionValue("o");
                }
                String model = clargs.getOptionValue("m");
                WSDModel wsdm = WSDModel.loadModel(model);
                WSDCorpus corp = WSDCorpus.loadTXT(inputfile);
                corp.corpusName = outputfile;
                wsdm.classify(corp, new EvaluationResult(), true);
                System.exit(0);
            }
            WSDDE.usages();
        }
        catch (ParseException e) {
            System.out.println("Parsing failed.  Reason: " + e.getMessage() + "\n");
            WSDDE.usages();
        }
        System.exit(0);
    }

    public static void usages() {
        HelpFormatter formatter = new HelpFormatter();
        for (String key : hm.keySet()) {
            System.out.println("\n" + opt.getOption(key).getDescription() + "\n");
            formatter.printHelp("java -jar wsdde.jar -" + key, hm.get(key), true);
            System.out.println();
        }
    }
}

