/*
 * Decompiled with CFR 0.152.
 */
package wsdde;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import wsdde.general.DatabaseHelper;
import wsdde.general.Utils;
import wsdde.generator.FeatureGenerator;

public class WSDMethodResultRow {
    public HashMap<String, String> fGParamValues;
    private HashMap<String, HashMap<String, String>> fGParametersStruct;
    public HashMap<String, String> methodPreferences;
    Element xmlElement;
    Element outputXMLElement;
    Document outputDocument;
    public static DatabaseHelper dh;
    private double result;

    public WSDMethodResultRow(Element WSDMethod2, DatabaseHelper dbh) {
        this.result = 0.0;
        this.xmlElement = WSDMethod2;
        dh = dbh;
        this.methodPreferences = new HashMap();
        this.methodPreferences.put("experiment_id", dh.getExperimentID());
        this.initFromElement();
    }

    public WSDMethodResultRow(ResultSet rs, DatabaseHelper dbh) throws SQLException {
        dh = dbh;
        this.methodPreferences = new HashMap();
        String[] colNames = dh.getColNames();
        int i = 0;
        while (i < colNames.length) {
            String colName = colNames[i];
            try {
                this.methodPreferences.put(colName, rs.getString(colName));
            }
            catch (Exception e) {
                this.methodPreferences.put(colName, "");
            }
            ++i;
        }
        LinkedHashSet<String> fgColumnNames = dh.getFGColumnNames();
        this.fGParamValues = new HashMap();
        for (String columnName : fgColumnNames) {
            String columnValue = rs.getString(columnName);
            this.fGParamValues.put(columnName, columnValue);
        }
    }

    public String getMethodParamValue(String methodParamName) {
        try {
            return this.methodPreferences.get(methodParamName);
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
            e.printStackTrace();
            System.exit(1);
            return "";
        }
    }

    public void setResult(Double res) {
        this.result = res;
        this.methodPreferences.put("result", Double.toString(this.result));
    }

    public void randomResult() {
        Random generator = new Random();
        Double res = generator.nextDouble();
        this.setResult(res);
    }

    public Element generateOutputXMLNode() {
        String CV = "cv:";
        String PATH = "path:";
        String selection = this.methodPreferences.get("selection");
        String machineLearning = this.methodPreferences.get("machine_learning");
        String corpusTraining = this.methodPreferences.get("corpus_training");
        String corpusTest = this.methodPreferences.get("corpus_test");
        this.outputDocument = Utils.createDomDocument();
        Element wsdMethodElement = this.outputDocument.createElement("wsd_method");
        Element selectionElement = this.outputDocument.createElement("selection");
        Element machineLearningElement = this.outputDocument.createElement("machine_learning");
        Element corpusElement = this.outputDocument.createElement("corpus");
        Element corpusTrainingElement = this.outputDocument.createElement("training");
        Element corpusTestElement = this.outputDocument.createElement("test");
        Element corpusCVElement = this.outputDocument.createElement("cv");
        Element featureGeneratorElement = this.outputDocument.createElement("feature_generators");
        try {
            int num = Integer.parseInt(corpusTest.substring("cv:".length()));
            corpusCVElement.setTextContent(corpusTraining);
            corpusCVElement.setAttribute("fold", Integer.toString(num));
            corpusElement.appendChild(corpusCVElement);
        }
        catch (NumberFormatException e) {
            corpusTrainingElement.setTextContent(corpusTraining);
            corpusTestElement.setTextContent(corpusTest.substring("path:".length()));
            corpusElement.appendChild(corpusTrainingElement);
            corpusElement.appendChild(corpusTestElement);
        }
        selectionElement.appendChild(this.outputDocument.createCDATASection(selection));
        machineLearningElement.appendChild(this.outputDocument.createCDATASection(machineLearning));
        this.initFGParametersStruct();
        Set<String> fGSet = this.fGParametersStruct.keySet();
        for (String fG : fGSet) {
            Element fGElement = this.outputDocument.createElement(fG);
            Set<String> paramSet = this.fGParametersStruct.get(fG).keySet();
            for (String param : paramSet) {
                Element paramElement = this.outputDocument.createElement("param");
                paramElement.setAttribute("name", param);
                paramElement.setAttribute("value", this.fGParametersStruct.get(fG).get(param));
                fGElement.appendChild(paramElement);
            }
            featureGeneratorElement.appendChild(fGElement);
        }
        wsdMethodElement.appendChild(corpusElement);
        wsdMethodElement.appendChild(selectionElement);
        wsdMethodElement.appendChild(machineLearningElement);
        wsdMethodElement.appendChild(featureGeneratorElement);
        wsdMethodElement.setAttribute("id", this.methodPreferences.get("method_id"));
        this.outputDocument.appendChild(wsdMethodElement);
        return wsdMethodElement;
    }

    private void initFGParametersStruct() {
        if (this.fGParametersStruct != null) {
            return;
        }
        this.fGParametersStruct = new HashMap();
        Set<String> s = this.fGParamValues.keySet();
        for (String fGParam : s) {
            HashMap<Object, Object> hs;
            String delimiter = "_";
            String[] temp = fGParam.split(delimiter, 3);
            String fGMethodName = temp[1];
            String fGParamName = temp[2];
            String fGParamVal = this.fGParamValues.get(fGParam);
            if (this.fGParametersStruct.containsKey(fGMethodName)) {
                hs = this.fGParametersStruct.get(fGMethodName);
            } else {
                hs = new HashMap();
                this.fGParametersStruct.put(fGMethodName, hs);
            }
            hs.put(fGParamName, fGParamVal);
        }
    }

    private void initFromElement() {
        try {
            this.methodPreferences.put("method_id", this.xmlElement.getAttribute("id"));
        }
        catch (Exception e) {
            this.methodPreferences.put("method_id", "");
        }
        this.initFGParamValues();
        this.initSelection();
        this.initCorpus();
        this.initMachineLearning();
    }

    public void setDataBaseHelper(DatabaseHelper dbh) {
        dh = dbh;
    }

    public void insertRow() {
        try {
            dh.insertWSDMethodResultRow(this);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void initMachineLearning() {
        Element ml = (Element)this.xmlElement.getElementsByTagName("machine_learning").item(0);
        String machineLearning = ml.getTextContent();
        this.methodPreferences.put("machine_learning", machineLearning);
    }

    private void initCorpus() {
        String corpusTest;
        String corpusTraining;
        Element training = (Element)this.xmlElement.getElementsByTagName("training").item(0);
        if (training == null) {
            Element cv = (Element)this.xmlElement.getElementsByTagName("cv").item(0);
            corpusTraining = cv.getTextContent();
            corpusTest = "cv:" + cv.getAttribute("fold");
        } else {
            corpusTraining = training.getTextContent();
            Element test = (Element)this.xmlElement.getElementsByTagName("test").item(0);
            corpusTest = "path:" + test.getTextContent();
        }
        this.methodPreferences.put("corpus_training", corpusTraining);
        this.methodPreferences.put("corpus_test", corpusTest);
    }

    private void initSelection() {
        Element ml = (Element)this.xmlElement.getElementsByTagName("selection").item(0);
        String selection = ml.getTextContent();
        this.methodPreferences.put("selection", selection);
    }

    private void initFGParamValues() {
        this.fGParamValues = new HashMap();
        Element fGenerators = (Element)this.xmlElement.getElementsByTagName("feature_generators").item(0);
        Vector<Element> featureGensVector = Utils.getChildElementsVector(fGenerators);
        int i = 0;
        while (i < featureGensVector.size()) {
            Element fg = featureGensVector.get(i);
            String methodName = fg.getNodeName();
            NodeList params = fg.getElementsByTagName("param");
            int j = 0;
            while (j < params.getLength()) {
                String paramName = ((Element)params.item(j)).getAttribute("name");
                String paramValue = ((Element)params.item(j)).getAttribute("value");
                this.fGParamValues.put("fg_" + methodName + "_" + paramName, paramValue);
                ++j;
            }
            ++i;
        }
    }

    public String getResult() {
        return Double.toString(this.result);
    }

    public Vector<WSDMethodResultRow> getSimilarRows(int quantity) {
        this.initFGParametersStruct();
        Element element = this.generateOutputXMLNode();
        Vector<WSDMethodResultRow> ret = new Vector<WSDMethodResultRow>();
        Set<String> fGSet = this.fGParametersStruct.keySet();
        for (String fG : fGSet) {
            HashMap<String, String> param = this.fGParametersStruct.get(fG);
            Vector<HashMap<String, String>> params = WSDMethodResultRow.getParametersOption(fG, param, quantity);
            int i = 0;
            while (i < params.size()) {
                WSDMethodResultRow wsdmrr = new WSDMethodResultRow(element, dh);
                wsdmrr.initFGParametersStruct();
                wsdmrr.fGParametersStruct.remove(fG);
                wsdmrr.fGParametersStruct.put(fG, params.get(i));
                ret.add(wsdmrr);
                ++i;
            }
        }
        return ret;
    }

    static Vector<HashMap<String, String>> getParametersOption(String fGName, HashMap<String, String> params, int quantity) {
        return FeatureGenerator.getParametersOption(fGName, params, quantity);
    }
}

