/*
 * Decompiled with CFR 0.152.
 */
package wsdde.corpus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Vector;
import wsdde.Counter;
import wsdde.corpus.ContextInfo;
import wsdde.general.Utils;

public class KWIC
implements Serializable {
    public int kwicID;
    private static final long serialVersionUID = -3365505737227452205L;
    public HashMap<String, Vector<ContextInfo>> infos = new HashMap();
    int keywordIndex;
    public String sense;
    public String predictedSense;
    public Counter counter;

    public KWIC(int id) {
        this.infos.put("words", new Vector());
        this.infos.put("lemmas", new Vector());
        this.infos.put("posinfos", new Vector());
        this.kwicID = id;
        this.counter = new Counter();
    }

    public void wstaw(Vector<String> typeOfInfo, Vector<ContextInfo> info, boolean isKeyword) {
        int i = 0;
        for (String type : typeOfInfo) {
            Vector<ContextInfo> v = this.infos.get(type);
            v.add(info.get(i++));
        }
        if (isKeyword) {
            this.keywordIndex = this.infos.get("words").size() - 1;
        }
    }

    public ContextInfo getInfo(String info, int index) {
        if ((index += this.keywordIndex) > -1 && index < this.infos.get(info).size()) {
            return this.infos.get(info).get(index);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CONTEXT ");
        sb.append(this.kwicID);
        sb.append("\n");
        sb.append("SENSE ");
        sb.append(this.sense);
        sb.append("\n");
        sb.append("PREDICTED_SENSE ");
        sb.append(this.predictedSense);
        sb.append("\n");
        sb.append("\n");
        int indeks = 0;
        int i = 0;
        while (i < this.infos.get("words").size()) {
            indeks = i - this.keywordIndex;
            sb.append(Utils.fillWithZeros("TOK " + indeks, 10));
            sb.append(Utils.fillWithZeros(String.valueOf(this.infos.get("words").get(i).toString()) + " ", 20));
            sb.append(Utils.fillWithZeros(String.valueOf(this.infos.get("lemmas").get(i).toString()) + " ", 20));
            sb.append(Utils.fillWithZeros(String.valueOf(this.infos.get("posinfos").get(i).toString()) + " ", 10));
            sb.append("\n");
            ++i;
        }
        sb.append("\n");
        sb.append("END_OF_CONTEXT ");
        sb.append(this.kwicID);
        sb.append("\n");
        sb.append("\n");
        return sb.toString();
    }

    public String toHumanString() {
        int indeks = 0;
        StringBuffer sb = new StringBuffer();
        int i = this.keywordIndex - 1;
        while (i < this.infos.get("words").size()) {
            indeks = i - this.keywordIndex;
            if (indeks == 0) {
                sb.append("****");
            }
            if (indeks == 1) {
                sb.append("****");
            }
            sb.append(this.infos.get("words").get(i).toString());
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }
}

