/*
 * Decompiled with CFR 0.152.
 */
package wsdde.corpus;

import java.util.StringTokenizer;
import java.util.Vector;
import wsdde.corpus.ContextInfo;

public class POSInfo
extends ContextInfo {
    String gram_class_string;
    Vector<String> gram_cat_strings;
    String pos_string;

    public POSInfo(String pos_string) {
        this.pos_string = pos_string;
        StringTokenizer st = new StringTokenizer(pos_string, ":");
        this.gram_class_string = st.nextToken();
        this.gram_cat_strings = new Vector();
        while (st.hasMoreTokens()) {
            this.gram_cat_strings.add(st.nextToken());
        }
    }

    public String getGramClassSimple() {
        String verb = "pact|ppas|winien|praet|bedzie|fin|impt|aglt|ger|imps|inf|pant|pcon";
        String noun = "subst|depr|xxs|ger|ppron12|ppron3";
        if (verb.contains(this.gram_class_string)) {
            return "verb";
        }
        if (noun.contains(this.gram_class_string)) {
            return "noun";
        }
        return this.gram_class_string;
    }

    public String getGrammClass() {
        return this.gram_class_string;
    }

    public String gramCat(int i) {
        return this.gram_cat_strings.get(i);
    }

    public int gramCatNumber() {
        return this.gram_cat_strings.size();
    }

    @Override
    public String toString() {
        return this.pos_string;
    }
}

