/*
 * Decompiled with CFR 0.152.
 */
package wsdde.corpus;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.QueryException;
import java.io.IOException;

public class PoliqarpContext {
    private String leftContext;
    private String leftMatch;
    private String rightMatch;
    private String rightContext;
    private String pseudoMatch;

    PoliqarpContext(PoliqarpConnection connection, int index) throws IOException, QueryException {
        connection.send("GET-CONTEXT " + index);
        if (!connection.getMessage().isOK()) {
            throw new QueryException();
        }
        this.leftContext = connection.getMessage().toString();
        this.leftMatch = connection.getMessage().toString();
        this.rightMatch = connection.getMessage().toString();
        this.rightContext = connection.getMessage().toString();
    }

    private String htmlize(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public String toXML() {
        return "<context>" + this.htmlize(this.leftContext) + " <sense label=\"" + this.htmlize(this.leftMatch).trim() + this.htmlize(this.rightMatch).trim() + "\">" + this.htmlize(this.pseudoMatch) + "</sense>" + this.htmlize(this.rightContext) + " </context>";
    }

    public void setPseudoMatch(String pseudoMatch) {
        this.pseudoMatch = pseudoMatch;
    }

    public String getPseudoMatch() {
        return this.pseudoMatch;
    }
}

