/*
 * Decompiled with CFR 0.152.
 */
package wsdde.corpus;

import ipipan.poliqarp.connection.PoliqarpConnection;
import ipipan.poliqarp.logic.Corpus;
import ipipan.poliqarp.logic.CorpusNotOpenedException;
import ipipan.poliqarp.logic.MatchList;
import ipipan.poliqarp.logic.Query;
import ipipan.poliqarp.logic.QueryException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Vector;
import wsdde.corpus.PoliqarpContext;
import wsdde.general.Config;

public class Pseudowords {
    private PoliqarpConnection connection;
    private Corpus corpus;
    private String serverName;
    private int portNumber;
    private String corpusFileName;
    private String[] parametersWords;
    private int[] parametersLength;
    private String pseudoMatch;
    private Vector<PoliqarpContext> contexts;

    private void initConfig() {
        this.serverName = Config.property(Config.Settings.POLIQARP_SERVER);
        this.portNumber = Integer.parseInt(Config.property(Config.Settings.POLIQARP_PORT));
        this.corpusFileName = Config.property(Config.Settings.POLIQARP_CORPUS);
    }

    public Pseudowords(String[] pp, int[] pl) {
        this.parametersWords = pp;
        this.parametersLength = pl;
        this.autoSetPseudoMatch();
        this.initConfig();
    }

    private void autoSetPseudoMatch() {
        this.pseudoMatch = "";
        int i = 0;
        while (i < this.parametersWords.length) {
            this.pseudoMatch = String.valueOf(this.pseudoMatch) + this.parametersWords[i];
            ++i;
        }
    }

    public void setPseudoMatch(String pM) {
        this.pseudoMatch = pM;
    }

    private void retrieveAllContexts() throws UnknownHostException, IOException, CorpusNotOpenedException, InterruptedException, QueryException {
        this.connection = new PoliqarpConnection(this.serverName, this.portNumber);
        try {
            this.corpus = new Corpus(this.connection, this.corpusFileName, null);
            while (this.corpus.getState() == Corpus.State.OPENING) {
                Thread.sleep(10L);
            }
            switch (this.corpus.getState()) {
                case OPENED: {
                    this.contexts = new Vector();
                    int i = 0;
                    while (i < this.parametersWords.length) {
                        this.retrieveWordContexts(i);
                        ++i;
                    }
                    break;
                }
                case NOT_OPENED: {
                    throw new IOException(this.corpus.getLastError());
                }
            }
        }
        finally {
            this.connection.close();
        }
    }

    private void retrieveWordContexts(int paramNum) throws QueryException, InterruptedException, IOException {
        int paramLen = this.parametersLength[paramNum];
        Query q = new Query(this.connection, this.parametersWords[paramNum]);
        q.launch(null);
        while (q.isRunning()) {
            Thread.sleep(500L);
        }
        MatchList ml = q.getMatchList();
        Thread.sleep(500L);
        int maxCount = ml.count() > paramLen ? paramLen : ml.count();
        int i = 0;
        while (i < maxCount) {
            PoliqarpContext con = new PoliqarpContext(this.connection, i);
            con.setPseudoMatch(this.pseudoMatch);
            this.contexts.add(con);
            ++i;
        }
    }

    private String getXMLContexts() {
        String xmlContexts = "<wsdcorpus>";
        int i = 0;
        while (i < this.contexts.size()) {
            xmlContexts = String.valueOf(xmlContexts) + this.contexts.get(i).toXML() + "\n";
            ++i;
        }
        xmlContexts = String.valueOf(xmlContexts) + "</wsdcorpus>";
        return xmlContexts;
    }

    public static String getPseudowordsCorpus(String[] pp, int[] pl) {
        Pseudowords pi = new Pseudowords(pp, pl);
        try {
            pi.retrieveAllContexts();
            return pi.getXMLContexts();
        }
        catch (Exception e) {
            System.err.println("Error while connecting or retreving data from poliqarp server");
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        String[] words = new String[]{"pies", "kot", "suka"};
        int[] maxContext = new int[]{1, 2, 3};
        String contextXML = Pseudowords.getPseudowordsCorpus(words, maxContext);
        System.out.println(contextXML);
    }
}

