/*
 * Decompiled with CFR 0.152.
 */
package wsdde.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import wsdde.corpus.KWIC;
import wsdde.corpus.WSDCorpus;
import wsdde.general.Utils;

public abstract class FeatureGenerator
implements Serializable {
    private static final long serialVersionUID = 6162623914640045887L;
    public HashMap<String, String> parameters;

    public FeatureGenerator(Element featureGeneratorElement) {
        this.parameters = new HashMap();
        NodeList params = featureGeneratorElement.getElementsByTagName("param");
        int i = 0;
        while (i < params.getLength()) {
            Element parameter = (Element)params.item(i);
            this.parameters.put(parameter.getAttribute("name"), parameter.getAttribute("value"));
            ++i;
        }
        this.prepareParams();
    }

    public FeatureGenerator(HashMap<String, String> parameters) {
        this.parameters = parameters;
        this.prepareParams();
    }

    public abstract void prepareParams();

    public HashMap<String, String> changeParam() {
        return this.parameters;
    }

    public FeatureGenerator() {
    }

    public static String description() {
        return "impement it in child class!";
    }

    public static String getXSD(String fgName, boolean meta) {
        String name = String.valueOf(fgName) + "_" + (meta ? "meta" : "desc") + ".xsd";
        InputStream is = FeatureGenerator.class.getResourceAsStream(name);
        return Utils.convertStreamToString(is);
    }

    public static HashMap<String, String> getChangedParams(String featureGeneratorName, HashMap<String, String> params) {
        return null;
    }

    public String getParam(String paramName) {
        return this.parameters.get(paramName);
    }

    public void setParam(String paramName, String paramValue) {
        this.parameters.put(paramName, paramValue);
    }

    public Vector<String> paramList() {
        Vector<String> v = new Vector<String>();
        Set<String> s = this.parameters.keySet();
        for (String string : s) {
            v.add(string);
        }
        return v;
    }

    public abstract void generate(WSDCorpus var1);

    public String id() {
        return "implement in child class";
    }

    public void feature(WSDCorpus wsdcorp, KWIC kwic, String feature) {
        StringBuffer sb = new StringBuffer();
        sb.append(feature);
        sb.append('_');
        sb.append(this.id());
        kwic.counter.increase(sb.toString());
        wsdcorp.whichGenerator.put(sb.toString(), this);
    }

    public boolean isBinary() {
        if (this.parameters.containsKey("binary")) {
            return Integer.parseInt(this.getParam("binary")) == 1;
        }
        return true;
    }

    public static FeatureGenerator getGenerator(Element feature_generator_element) {
        String class_name = feature_generator_element.getTagName();
        try {
            Class<?> FG_class = Class.forName(class_name);
            Constructor<?> con = FG_class.getConstructor(Element.class);
            Object obj = con.newInstance(feature_generator_element);
            return (FeatureGenerator)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FeatureGenerator getGenerator(String fgName, HashMap<String, String> parameters) {
        try {
            Class<?> FG_class = Class.forName(fgName);
            Constructor<?> con = FG_class.getConstructor(HashMap.class);
            Object obj = con.newInstance(parameters);
            return (FeatureGenerator)obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile().replace("%20", " ")));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(FeatureGenerator.findClasses(directory, packageName));
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Class class1 : classes) {
            strings.add(class1.getCanonicalName());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static List<Class> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList<Class> classes = new ArrayList<Class>();
        if (!directory.exists()) {
            return classes;
        }
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                classes.addAll(FeatureGenerator.findClasses(file, String.valueOf(packageName) + "." + file.getName()));
            } else if (file.getName().endsWith(".class")) {
                classes.add(Class.forName(String.valueOf(packageName) + '.' + file.getName().substring(0, file.getName().length() - 6)));
            }
            ++n2;
        }
        return classes;
    }

    private static String[] getClassesFromJar() {
        try {
            CodeSource src = FeatureGenerator.class.getProtectionDomain().getCodeSource();
            ArrayList<String> list = new ArrayList<String>();
            if (src != null) {
                URL jar = src.getLocation();
                ZipInputStream zip = new ZipInputStream(jar.openStream());
                ZipEntry ze = null;
                while ((ze = zip.getNextEntry()) != null) {
                    String entryName = ze.getName();
                    if (!entryName.endsWith(".class")) continue;
                    entryName = entryName.replace('/', '.').substring(0, entryName.lastIndexOf(46));
                    list.add(entryName);
                }
            }
            return list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getGeneratorsXSDs(boolean meta) {
        StringBuffer sb = new StringBuffer();
        try {
            String[] cs = FeatureGenerator.getClassesFromJar();
            Vector<String> v = new Vector<String>(Arrays.asList(cs));
            cs = FeatureGenerator.getClasses("wsdde.generator");
            v.addAll(Arrays.asList(cs));
            for (String classt : v) {
                Class<?> class1 = Class.forName(classt);
                if (!class1.getSuperclass().getCanonicalName().equals("wsdde.generator.FeatureGenerator")) continue;
                Class<?> FG_class = Class.forName(class1.getCanonicalName());
                Method m = FG_class.getDeclaredMethod("description", null);
                String o = (String)m.invoke(null, null);
                sb.append("<!--");
                sb.append(o);
                sb.append("-->");
                Constructor<?> con = FG_class.getConstructor(new Class[0]);
                FeatureGenerator obj = (FeatureGenerator)con.newInstance(new Object[0]);
                m = FG_class.getDeclaredMethod("id", null);
                String id = (String)m.invoke((Object)obj, null);
                m = FG_class.getSuperclass().getDeclaredMethod("getXSD", String.class, Boolean.TYPE);
                o = (String)m.invoke(null, id, meta);
                sb.append(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Vector<HashMap<String, String>> getParametersOption(String fGName, HashMap<String, String> params, int quantity) {
        Vector<HashMap<String, String>> v = new Vector<HashMap<String, String>>();
        FeatureGenerator fg = FeatureGenerator.getGenerator(fGName, params);
        int i = 0;
        while (i < quantity) {
            v.add(fg.changeParam());
            ++i;
        }
        return v;
    }

    public static void main(String[] args) {
        System.out.println(FeatureGenerator.getGeneratorsXSDs(true));
    }
}

